/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.client;

import com.mumfrey.liteloader.ChatRenderListener;
import com.mumfrey.liteloader.EntityRenderListener;
import com.mumfrey.liteloader.FrameBufferListener;
import com.mumfrey.liteloader.GameLoopListener;
import com.mumfrey.liteloader.HUDRenderListener;
import com.mumfrey.liteloader.InitCompleteListener;
import com.mumfrey.liteloader.OutboundChatFilter;
import com.mumfrey.liteloader.OutboundChatListener;
import com.mumfrey.liteloader.PlayerClickListener;
import com.mumfrey.liteloader.PlayerInteractionListener;
import com.mumfrey.liteloader.PostRenderListener;
import com.mumfrey.liteloader.PreRenderListener;
import com.mumfrey.liteloader.RenderListener;
import com.mumfrey.liteloader.ScreenshotListener;
import com.mumfrey.liteloader.Tickable;
import com.mumfrey.liteloader.ViewportListener;
import com.mumfrey.liteloader.client.GameEngineClient;
import com.mumfrey.liteloader.client.overlays.IEntityRenderer;
import com.mumfrey.liteloader.common.LoadingProgress;
import com.mumfrey.liteloader.core.InterfaceRegistrationDelegate;
import com.mumfrey.liteloader.core.LiteLoader;
import com.mumfrey.liteloader.core.LiteLoaderEventBroker;
import com.mumfrey.liteloader.core.event.HandlerList;
import com.mumfrey.liteloader.core.event.ProfilingHandlerList;
import com.mumfrey.liteloader.interfaces.FastIterableDeque;
import com.mumfrey.liteloader.launch.LoaderProperties;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import org.lwjgl.input.Mouse;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class LiteLoaderEventBrokerClient
extends LiteLoaderEventBroker<bib, chd>
implements ceq {
    private static LiteLoaderEventBrokerClient instance;
    protected final GameEngineClient engineClient;
    private int screenWidth = 854;
    private int screenHeight = 480;
    private boolean wasFullScreen = false;
    private int worldHashCode = 0;
    private FastIterableDeque<Tickable> tickListeners;
    private FastIterableDeque<GameLoopListener> loopListeners = new HandlerList<GameLoopListener>(GameLoopListener.class);
    private FastIterableDeque<RenderListener> renderListeners = new HandlerList<RenderListener>(RenderListener.class);
    private FastIterableDeque<PreRenderListener> preRenderListeners = new HandlerList<PreRenderListener>(PreRenderListener.class);
    private FastIterableDeque<PostRenderListener> postRenderListeners = new HandlerList<PostRenderListener>(PostRenderListener.class);
    private FastIterableDeque<HUDRenderListener> hudRenderListeners = new HandlerList<HUDRenderListener>(HUDRenderListener.class);
    private FastIterableDeque<ChatRenderListener> chatRenderListeners = new HandlerList<ChatRenderListener>(ChatRenderListener.class);
    private FastIterableDeque<OutboundChatListener> outboundChatListeners = new HandlerList<OutboundChatListener>(OutboundChatListener.class);
    private FastIterableDeque<ViewportListener> viewportListeners = new HandlerList<ViewportListener>(ViewportListener.class);
    private FastIterableDeque<FrameBufferListener> frameBufferListeners = new HandlerList<FrameBufferListener>(FrameBufferListener.class);
    private FastIterableDeque<InitCompleteListener> initListeners = new HandlerList<InitCompleteListener>(InitCompleteListener.class);
    private FastIterableDeque<OutboundChatFilter> outboundChatFilters = new HandlerList<OutboundChatFilter>(OutboundChatFilter.class, HandlerList.ReturnLogicOp.AND);
    private FastIterableDeque<ScreenshotListener> screenshotListeners = new HandlerList<ScreenshotListener>(ScreenshotListener.class, HandlerList.ReturnLogicOp.AND_BREAK_ON_FALSE);
    private FastIterableDeque<EntityRenderListener> entityRenderListeners = new HandlerList<EntityRenderListener>(EntityRenderListener.class);
    private FastIterableDeque<PlayerClickListener> playerClickListeners = new HandlerList<PlayerClickListener>(PlayerClickListener.class, HandlerList.ReturnLogicOp.AND);

    public LiteLoaderEventBrokerClient(LiteLoader loader, GameEngineClient engine, LoaderProperties properties) {
        super(loader, engine, properties);
        instance = this;
        this.engineClient = engine;
        this.tickListeners = new ProfilingHandlerList<Tickable>(Tickable.class, this.engineClient.getProfiler());
    }

    public static LiteLoaderEventBrokerClient getInstance() {
        return instance;
    }

    public void a(cep resourceManager) {
        LoadingProgress.setMessage("Reloading Resources...");
    }

    @Override
    public void registerInterfaces(InterfaceRegistrationDelegate delegate) {
        super.registerInterfaces(delegate);
        delegate.registerInterface(Tickable.class);
        delegate.registerInterface(GameLoopListener.class);
        delegate.registerInterface(RenderListener.class);
        delegate.registerInterface(PreRenderListener.class);
        delegate.registerInterface(PostRenderListener.class);
        delegate.registerInterface(HUDRenderListener.class);
        delegate.registerInterface(ChatRenderListener.class);
        delegate.registerInterface(OutboundChatListener.class);
        delegate.registerInterface(ViewportListener.class);
        delegate.registerInterface(FrameBufferListener.class);
        delegate.registerInterface(InitCompleteListener.class);
        delegate.registerInterface(OutboundChatFilter.class);
        delegate.registerInterface(ScreenshotListener.class);
        delegate.registerInterface(EntityRenderListener.class);
        delegate.registerInterface(PlayerClickListener.class);
    }

    @Override
    public void initProvider() {
    }

    public void addTickListener(Tickable tickable) {
        this.tickListeners.add(tickable);
    }

    public void addLoopListener(GameLoopListener loopListener) {
        this.loopListeners.add(loopListener);
    }

    public void addInitListener(InitCompleteListener initCompleteListener) {
        this.initListeners.add(initCompleteListener);
    }

    public void addRenderListener(RenderListener renderListener) {
        this.renderListeners.add(renderListener);
    }

    public void addPreRenderListener(PreRenderListener preRenderListener) {
        this.preRenderListeners.add(preRenderListener);
    }

    public void addPostRenderListener(PostRenderListener postRenderListener) {
        this.postRenderListeners.add(postRenderListener);
    }

    public void addChatRenderListener(ChatRenderListener chatRenderListener) {
        this.chatRenderListeners.add(chatRenderListener);
    }

    public void addHUDRenderListener(HUDRenderListener hudRenderListener) {
        this.hudRenderListeners.add(hudRenderListener);
    }

    public void addOutboundChatListener(OutboundChatListener outboundChatListener) {
        this.outboundChatListeners.add(outboundChatListener);
    }

    public void addOutboundChatFiler(OutboundChatFilter outboundChatFilter) {
        this.outboundChatFilters.add(outboundChatFilter);
    }

    public void addViewportListener(ViewportListener viewportListener) {
        this.viewportListeners.add(viewportListener);
    }

    public void addFrameBufferListener(FrameBufferListener frameBufferListener) {
        this.frameBufferListeners.add(frameBufferListener);
    }

    public void addScreenshotListener(ScreenshotListener screenshotListener) {
        this.screenshotListeners.add(screenshotListener);
    }

    public void addEntityRenderListener(EntityRenderListener entityRenderListener) {
        this.entityRenderListeners.add(entityRenderListener);
    }

    public void addEntityRenderListener(PlayerClickListener playerClickListener) {
        this.playerClickListeners.add(playerClickListener);
    }

    @Override
    public void onStartupComplete() {
        this.engine.getResources().refreshResources(false);
        for (InitCompleteListener initMod : this.initListeners) {
            try {
                LoadingProgress.setMessage("Calling late init for mod %s...", initMod.getName());
                LiteLoaderLogger.info("Calling late init for mod %s", initMod.getName());
                initMod.onInitCompleted((bib)this.engine.getClient(), this.loader);
            }
            catch (Throwable th) {
                this.mods.onLateInitFailed(initMod, th);
                LiteLoaderLogger.warning(th, "Error calling late init for mod %s", initMod.getName());
            }
        }
        this.onResize(this.engineClient.getClient());
        super.onStartupComplete();
    }

    public void onResize(bib minecraft) {
        bit currentResolution = this.engineClient.getScaledResolution();
        this.screenWidth = currentResolution.a();
        this.screenHeight = currentResolution.b();
        if (this.wasFullScreen != minecraft.J()) {
            ((ViewportListener)this.viewportListeners.all()).onFullScreenToggled(minecraft.J());
        }
        this.wasFullScreen = minecraft.J();
        ((ViewportListener)this.viewportListeners.all()).onViewportResized(currentResolution, minecraft.d, minecraft.e);
    }

    public void onRender() {
        ((RenderListener)this.renderListeners.all()).onRender();
    }

    public void postRenderEntities(float partialTicks, long timeSlice) {
        ((PostRenderListener)this.postRenderListeners.all()).onPostRenderEntities(partialTicks);
    }

    public void postRender(float partialTicks, long timeSlice) {
        ((IEntityRenderer)this.engineClient.getClient().o).setupCamera(partialTicks, 0);
        ((PostRenderListener)this.postRenderListeners.all()).onPostRender(partialTicks);
    }

    public void preRenderGUI(float partialTicks) {
        ((RenderListener)this.renderListeners.all()).onRenderGui(this.engineClient.getCurrentScreen());
    }

    public void onSetupCameraTransform(int pass, float partialTicks, long timeSlice) {
        ((RenderListener)this.renderListeners.all()).onSetupCameraTransform();
        ((PreRenderListener)this.preRenderListeners.all()).onSetupCameraTransform(partialTicks, pass, timeSlice);
    }

    public void onRenderChat(bjb chatGui, float partialTicks) {
        ((ChatRenderListener)this.chatRenderListeners.all()).onPreRenderChat(this.screenWidth, this.screenHeight, chatGui);
    }

    public void postRenderChat(bjb chatGui, float partialTicks) {
        ((ChatRenderListener)this.chatRenderListeners.all()).onPostRenderChat(this.screenWidth, this.screenHeight, chatGui);
    }

    public void onRenderHUD(float partialTicks) {
        ((HUDRenderListener)this.hudRenderListeners.all()).onPreRenderHUD(this.screenWidth, this.screenHeight);
    }

    public void postRenderHUD(float partialTicks) {
        ((HUDRenderListener)this.hudRenderListeners.all()).onPostRenderHUD(this.screenWidth, this.screenHeight);
    }

    public void onTimerUpdate() {
        bib minecraft = (bib)this.engine.getClient();
        ((GameLoopListener)this.loopListeners.all()).onRunGameLoop(minecraft);
    }

    public void onTick(boolean clock, float partialTicks) {
        int worldHashCode;
        this.profiler.c("litemods");
        bib minecraft = (bib)this.engine.getClient();
        vg renderViewEntity = minecraft.aa();
        boolean inGame = renderViewEntity != null && renderViewEntity.l != null;
        this.profiler.a("loader");
        super.onTick(clock, partialTicks, inGame);
        int mouseX = Mouse.getX() * this.screenWidth / minecraft.d;
        int mouseY = this.screenHeight - Mouse.getY() * this.screenHeight / minecraft.e - 1;
        this.profiler.c("postrender");
        super.onPostRender(mouseX, mouseY, partialTicks);
        this.profiler.b();
        ((Tickable)this.tickListeners.all()).onTick(minecraft, partialTicks, inGame, clock);
        int n = worldHashCode = minecraft.f != null ? minecraft.f.hashCode() : 0;
        if (worldHashCode != this.worldHashCode) {
            this.worldHashCode = worldHashCode;
            super.onWorldChanged((amu)minecraft.f);
        }
    }

    void onSendChatMessage(la packet, String message) {
        ((OutboundChatListener)this.outboundChatListeners.all()).onSendChatMessage(packet, message);
    }

    public void onSendChatMessage(CallbackInfo e, String message) {
        if (!((OutboundChatFilter)this.outboundChatFilters.all()).onSendChatMessage(message)) {
            e.cancel();
        }
    }

    public void preRenderFBO(bvd framebuffer) {
        ((FrameBufferListener)this.frameBufferListeners.all()).preRenderFBO(framebuffer);
    }

    public void onRenderFBO(bvd framebuffer, int width, int height) {
        ((FrameBufferListener)this.frameBufferListeners.all()).onRenderFBO(framebuffer, width, height);
    }

    public void postRenderFBO(bvd framebuffer) {
        ((FrameBufferListener)this.frameBufferListeners.all()).postRenderFBO(framebuffer);
    }

    public void onRenderWorld(float partialTicks, long timeSlice) {
        ((PreRenderListener)this.preRenderListeners.all()).onRenderWorld(partialTicks);
    }

    public void onRenderSky(float partialTicks, int pass, long timeSlice) {
        ((PreRenderListener)this.preRenderListeners.all()).onRenderSky(partialTicks, pass);
    }

    public void onRenderClouds(float partialTicks, int pass, buy renderGlobal) {
        ((PreRenderListener)this.preRenderListeners.all()).onRenderClouds(partialTicks, pass, renderGlobal);
    }

    public void onRenderTerrain(float partialTicks, int pass, long timeSlice) {
        ((PreRenderListener)this.preRenderListeners.all()).onRenderTerrain(partialTicks, pass);
    }

    public void onScreenshot(CallbackInfoReturnable<hh> ci, String name, int width, int height, bvd fbo) {
        LiteLoaderEventBroker.ReturnValue<hh> ret = new LiteLoaderEventBroker.ReturnValue<hh>(ci.getReturnValue());
        if (!((ScreenshotListener)this.screenshotListeners.all()).onSaveScreenshot(name, width, height, fbo, ret)) {
            ci.setReturnValue(ret.get());
        }
    }

    public <T extends vg> void onRenderEntity(bzf source, T entity, double xPos, double yPos, double zPos, float yaw, float partialTicks, bzg<T> render) {
        ((EntityRenderListener)this.entityRenderListeners.all()).onRenderEntity(render, entity, xPos, yPos, zPos, yaw, partialTicks);
    }

    public <T extends vg> void onPostRenderEntity(bzf source, T entity, double xPos, double yPos, double zPos, float yaw, float partialTicks, bzg<T> render) {
        ((EntityRenderListener)this.entityRenderListeners.all()).onPostRenderEntity(render, entity, xPos, yPos, zPos, yaw, partialTicks);
    }

    public boolean onClickMouse(bud player, PlayerInteractionListener.MouseButton button) {
        return ((PlayerClickListener)this.playerClickListeners.all()).onMouseClicked(player, button);
    }

    public boolean onMouseHeld(bud player, PlayerInteractionListener.MouseButton button) {
        return ((PlayerClickListener)this.playerClickListeners.all()).onMouseHeld(player, button);
    }
}

