/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.client.gui;

import com.mumfrey.liteloader.LiteMod;
import com.mumfrey.liteloader.api.ModInfoDecorator;
import com.mumfrey.liteloader.client.gui.GuiLiteLoaderPanel;
import com.mumfrey.liteloader.client.gui.GuiPanel;
import com.mumfrey.liteloader.client.gui.GuiSimpleScrollBar;
import com.mumfrey.liteloader.client.gui.modlist.ModList;
import com.mumfrey.liteloader.client.gui.modlist.ModListContainer;
import com.mumfrey.liteloader.core.LiteLoaderMods;
import com.mumfrey.liteloader.gl.GL;
import com.mumfrey.liteloader.gl.GLClippingPlanes;
import com.mumfrey.liteloader.launch.LoaderEnvironment;
import com.mumfrey.liteloader.modconfig.ConfigManager;
import com.mumfrey.liteloader.modconfig.ConfigPanel;
import java.util.List;

public class GuiPanelMods
extends GuiPanel
implements ModListContainer {
    private static final int SCROLLBAR_WIDTH = 5;
    private final GuiLiteLoaderPanel parentScreen;
    private final ConfigManager configManager;
    private ModList modList;
    private bja btnToggle;
    private bja btnConfig;
    private int listHeight = 100;
    private GuiSimpleScrollBar scrollBar = new GuiSimpleScrollBar();

    public GuiPanelMods(GuiLiteLoaderPanel parentScreen, bib minecraft, LiteLoaderMods mods, LoaderEnvironment environment, ConfigManager configManager, int brandColour, List<ModInfoDecorator> decorators) {
        super(minecraft);
        this.parentScreen = parentScreen;
        this.configManager = configManager;
        this.modList = new ModList(this, minecraft, mods, environment, configManager, brandColour, decorators);
    }

    @Override
    public GuiLiteLoaderPanel getParentScreen() {
        return this.parentScreen;
    }

    @Override
    public void setConfigButtonVisible(boolean visible) {
        this.btnConfig.m = visible;
    }

    @Override
    public void setEnableButtonVisible(boolean visible) {
        this.btnToggle.m = visible;
    }

    @Override
    public void setEnableButtonText(String displayString) {
        this.btnToggle.j = displayString;
    }

    @Override
    boolean stealFocus() {
        return false;
    }

    @Override
    void setSize(int width, int height) {
        super.setSize(width, height);
        int rightPanelLeftEdge = 16 + (this.width - 12 - 12 - 4) / 2;
        this.controls.clear();
        this.btnToggle = new bja(0, rightPanelLeftEdge, this.height - 26 - 24, 90, 20, cey.a((String)"gui.enablemod", (Object[])new Object[0]));
        this.controls.add(this.btnToggle);
        this.btnConfig = new bja(1, rightPanelLeftEdge + 92, this.height - 26 - 24, 69, 20, cey.a((String)"gui.modsettings", (Object[])new Object[0]));
        this.controls.add(this.btnConfig);
        this.modList.setSize(width, height);
    }

    @Override
    void onTick() {
        this.modList.onTick();
    }

    @Override
    void onHidden() {
    }

    @Override
    void onShown() {
    }

    @Override
    void mousePressed(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            if (this.scrollBar.wasMouseOver()) {
                this.scrollBar.setDragging(true);
            }
            if (mouseY > 83 && mouseY < this.height - 26) {
                this.modList.mousePressed(mouseX, mouseY, mouseButton);
            }
        }
        super.mousePressed(mouseX, mouseY, mouseButton);
    }

    @Override
    void keyPressed(char keyChar, int keyCode) {
        if (keyCode == 1) {
            this.parentScreen.onToggled();
            return;
        }
        if (!this.modList.keyPressed(keyChar, keyCode)) {
            if (keyCode == 61) {
                this.parentScreen.showLogPanel();
            } else if (keyCode == 59) {
                this.parentScreen.showAboutPanel();
            }
        }
    }

    @Override
    void mouseMoved(int mouseX, int mouseY) {
    }

    @Override
    void mouseReleased(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            this.scrollBar.setDragging(false);
            this.modList.mouseReleased(mouseX, mouseY, mouseButton);
        }
    }

    @Override
    void mouseWheelScrolled(int mouseWheelDelta) {
        if (!this.modList.mouseWheelScrolled(mouseWheelDelta)) {
            this.scrollBar.offsetValue(-mouseWheelDelta / 8);
        }
    }

    @Override
    public void showConfig() {
        this.actionPerformed(this.btnConfig);
    }

    @Override
    void actionPerformed(bja control) {
        Class<? extends LiteMod> modClass;
        if (control.k == 0) {
            this.modList.toggleSelectedMod();
        }
        if (control.k == 1 && (modClass = this.modList.getSelectedModClass()) != null) {
            ConfigPanel panel = this.configManager.getPanel(modClass);
            LiteMod mod = this.modList.getSelectedModInstance();
            this.parentScreen.openConfigPanel(panel, mod);
        }
    }

    @Override
    void draw(int mouseX, int mouseY, float partialTicks) {
        this.parentScreen.drawInfoPanel(mouseX, mouseY, partialTicks, 0, 26);
        int innerWidth = this.width - 12 - 12 - 4;
        int panelWidth = innerWidth / 2;
        int panelHeight = this.height - 26 - 83;
        this.drawModsList(mouseX, mouseY, partialTicks, panelWidth, panelHeight);
        int left = 12 + panelWidth;
        int top = 83;
        int spaceForButtons = this.btnConfig.m || this.btnToggle.m ? 28 : 0;
        int bottom = this.height - 26 - spaceForButtons;
        GLClippingPlanes.glEnableClipping(left, this.width - 12, top, bottom);
        this.modList.drawModPanel(mouseX, mouseY, partialTicks, left, top, this.width - 12 - left, panelHeight - spaceForButtons);
        GLClippingPlanes.glDisableClipping();
        super.draw(mouseX, mouseY, partialTicks);
    }

    private void drawModsList(int mouseX, int mouseY, float partialTicks, int width, int height) {
        this.scrollBar.drawScrollBar(mouseX, mouseY, partialTicks, 12 + width - 5, 83, 5, height, this.listHeight);
        GLClippingPlanes.glEnableClipping(12, 12 + width - 5 - 1, 83, this.height - 26);
        GL.glPushMatrix();
        GL.glTranslatef(0.0f, 83 - this.scrollBar.getValue(), 0.0f);
        this.listHeight = this.modList.drawModList(mouseX, mouseY -= 83 - this.scrollBar.getValue(), partialTicks, 12, 0, width - 5 - 1, height);
        this.scrollBar.setMaxValue(this.listHeight - height);
        GL.glPopMatrix();
        GLClippingPlanes.glDisableClipping();
    }

    @Override
    public void scrollTo(int yPosTop, int yPosBottom) {
        if (yPosTop < this.scrollBar.getValue()) {
            this.scrollBar.setValue(yPosTop);
            return;
        }
        int panelHeight = this.height - 26 - 83;
        if (yPosBottom - this.scrollBar.getValue() > panelHeight) {
            this.scrollBar.setValue(yPosBottom - panelHeight);
        }
    }
}

