/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.util;

import java.util.List;

public abstract class ChatUtilities {
    private static String formattingCodeLookup;

    private ChatUtilities() {
    }

    public static hn getChatStyleFromCode(char code) {
        int pos = formattingCodeLookup.indexOf(code);
        if (pos < 0) {
            return null;
        }
        a format = a.values()[pos];
        hn style = new hn();
        if (format.d()) {
            style.a(format);
        } else if (format.c()) {
            switch (format) {
                case r: {
                    style.a(Boolean.valueOf(true));
                    break;
                }
                case u: {
                    style.b(Boolean.valueOf(true));
                    break;
                }
                case s: {
                    style.c(Boolean.valueOf(true));
                    break;
                }
                case t: {
                    style.d(Boolean.valueOf(true));
                    break;
                }
                case q: {
                    style.e(Boolean.valueOf(true));
                    break;
                }
                default: {
                    return style;
                }
            }
        }
        return style;
    }

    public static hh convertLegacyCodes(hh chat) {
        return ChatUtilities.covertCodesInPlace(chat);
    }

    private static List<hh> covertCodesInPlace(List<hh> siblings) {
        for (int index = 0; index < siblings.size(); ++index) {
            siblings.set(index, ChatUtilities.covertCodesInPlace(siblings.get(index)));
        }
        return siblings;
    }

    private static hh covertCodesInPlace(hh component) {
        hh newComponent = null;
        if (component instanceof ho) {
            ho textComponent = (ho)component;
            hn style = textComponent.b();
            String text = textComponent.d();
            int pos = text.indexOf(167);
            while (pos > -1 && text != null) {
                if (pos < text.length() - 1) {
                    hh head = new ho(pos > 0 ? text.substring(0, pos) : "").a(style);
                    style = ChatUtilities.getChatStyleFromCode(text.charAt(pos + 1));
                    text = text.substring(pos + 2);
                    newComponent = newComponent == null ? head : newComponent.a(head);
                    pos = text.indexOf(167);
                    continue;
                }
                text = null;
            }
            if (text != null) {
                hh tail = new ho(text).a(style);
                hh hh2 = newComponent = newComponent == null ? tail : newComponent.a(tail);
            }
        }
        if (newComponent == null) {
            ChatUtilities.covertCodesInPlace(component.a());
            return component;
        }
        for (hh oldSibling : ChatUtilities.covertCodesInPlace(component.a())) {
            newComponent.a(oldSibling);
        }
        return newComponent;
    }

    static {
        StringBuilder formattingCodes = new StringBuilder();
        for (a chatFormat : a.values()) {
            formattingCodes.append(chatFormat.toString().charAt(1));
        }
        formattingCodeLookup = formattingCodes.toString();
    }
}

