/*
 * Decompiled with CFR 0.152.
 */
package pixelradar.api;

import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.Collection;
import pixelradar.api.IMwDataProvider;

public class MwAPI {
    private static HashBiMap<String, IMwDataProvider> dataProviders = HashBiMap.create();
    private static IMwDataProvider currentProvider = null;
    private static ArrayList<String> providerKeys = new ArrayList();

    public static void registerDataProvider(String name, IMwDataProvider handler) {
        dataProviders.put((Object)name, (Object)handler);
        providerKeys.add(name);
    }

    public static Collection<IMwDataProvider> getDataProviders() {
        return dataProviders.values();
    }

    public static IMwDataProvider getDataProvider(String name) {
        return (IMwDataProvider)dataProviders.get((Object)name);
    }

    public static String getProviderName(IMwDataProvider provider) {
        return (String)dataProviders.inverse().get((Object)provider);
    }

    public static IMwDataProvider getCurrentDataProvider() {
        return currentProvider;
    }

    public static String getCurrentProviderName() {
        if (currentProvider != null) {
            return MwAPI.getProviderName(currentProvider);
        }
        return "None";
    }

    public static IMwDataProvider setCurrentDataProvider(String name) {
        currentProvider = (IMwDataProvider)dataProviders.get((Object)name);
        return currentProvider;
    }

    public static IMwDataProvider setCurrentDataProvider(IMwDataProvider provider) {
        currentProvider = provider;
        return currentProvider;
    }

    public static IMwDataProvider setNextProvider() {
        if (currentProvider != null) {
            int index = providerKeys.indexOf(MwAPI.getCurrentProviderName());
            if (index + 1 >= providerKeys.size()) {
                currentProvider = null;
            } else {
                String nextKey = providerKeys.get(index + 1);
                currentProvider = MwAPI.getDataProvider(nextKey);
            }
        } else if (providerKeys.size() > 0) {
            currentProvider = MwAPI.getDataProvider(providerKeys.get(0));
        }
        return currentProvider;
    }

    public static IMwDataProvider setPrevProvider() {
        if (currentProvider != null) {
            int index = providerKeys.indexOf(MwAPI.getCurrentProviderName());
            if (index - 1 < 0) {
                currentProvider = null;
            } else {
                String prevKey = providerKeys.get(index - 1);
                currentProvider = MwAPI.getDataProvider(prevKey);
            }
        } else if (providerKeys.size() > 0) {
            currentProvider = MwAPI.getDataProvider(providerKeys.get(providerKeys.size() - 1));
        }
        return currentProvider;
    }
}

