/*
 * Decompiled with CFR 0.152.
 */
package pixelradar.config;

import java.io.File;
import java.util.Optional;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import pixelradar.config.Config;
import pixelradar.util.Logging;
import pixelradar.util.Utils;

public class ConfigurationHandler {
    public static Configuration configuration;

    public static void init(File configFile) {
        if (configuration == null) {
            configuration = new Configuration(configFile);
            ConfigurationHandler.setMapModeDefaults();
            ConfigurationHandler.loadConfig();
            Config.fullScreenMap.loadConfig();
            Config.largeMap.loadConfig();
            Config.smallMap.loadConfig();
            Config.pokeradar.loadConfig();
            if (configuration.hasChanged()) {
                configuration.save();
            }
            configuration.get("mw.configgui.ctgy.general", "overlayModeIndex", Config.overlayModeIndexDef).setShowInGui(false);
            configuration.get("mw.configgui.ctgy.general", "overlayZoomLevel", Config.zoomInLevelsDef).setShowInGui(false);
        }
    }

    public static void loadConfig() {
        Config.linearTextureScaling = configuration.getBoolean("linearTextureScaling", "mw.configgui.ctgy.general", Config.linearTextureScalingDef, "", "mw.config.linearTextureScaling");
        Config.useSavedBlockColours = configuration.getBoolean("useSavedBlockColours", "mw.configgui.ctgy.general", Config.useSavedBlockColoursDef, "", "mw.config.useSavedBlockColours");
        Config.teleportEnabled = configuration.getBoolean("teleportEnabled", "mw.configgui.ctgy.general", Config.teleportEnabledDef, "", "mw.config.teleportEnabled");
        Config.teleportCommand = configuration.getString("teleportCommand", "mw.configgui.ctgy.general", Config.teleportCommandDef, "", "mw.config.teleportCommand");
        Config.maxChunkSaveDistSq = configuration.getInt("maxChunkSaveDistSq", "mw.configgui.ctgy.general", Config.maxChunkSaveDistSqDef, 1, 65536, "", "mw.config.maxChunkSaveDistSq");
        Config.mapPixelSnapEnabled = configuration.getBoolean("mapPixelSnapEnabled", "mw.configgui.ctgy.general", Config.mapPixelSnapEnabledDef, "", "mw.config.mapPixelSnapEnabled");
        Config.maxDeathMarkers = configuration.getInt("maxDeathMarkers", "mw.configgui.ctgy.general", Config.maxDeathMarkersDef, 0, 1000, "", "mw.config.maxDeathMarkers");
        Config.chunksPerTick = configuration.getInt("chunksPerTick", "mw.configgui.ctgy.general", Config.chunksPerTickDef, 1, 500, "", "mw.config.chunksPerTick");
        Config.saveDirOverride = configuration.getString("saveDirOverride", "mw.configgui.ctgy.general", Config.saveDirOverrideDef, "", "mw.config.saveDirOverride");
        Config.portNumberInWorldNameEnabled = configuration.getBoolean("portNumberInWorldNameEnabled", "mw.configgui.ctgy.general", Config.portNumberInWorldNameEnabledDef, "", "mw.config.portNumberInWorldNameEnabled");
        Config.undergroundMode = configuration.getBoolean("undergroundMode", "mw.configgui.ctgy.general", Config.undergroundModeDef, "", "mw.config.undergroundMode");
        Config.regionFileOutputEnabledSP = configuration.getBoolean("regionFileOutputEnabledSP", "mw.configgui.ctgy.general", Config.regionFileOutputEnabledSPDef, "", "mw.config.regionFileOutputEnabledSP");
        Config.regionFileOutputEnabledMP = configuration.getBoolean("regionFileOutputEnabledMP", "mw.configgui.ctgy.general", Config.regionFileOutputEnabledMPDef, "", "mw.config.regionFileOutputEnabledMP");
        Config.backgroundTextureMode = configuration.getString("backgroundTextureMode", "mw.configgui.ctgy.general", Config.backgroundTextureModeDef, "", Utils.getLocalizedBgModeArray(Config.backgroundModeStringArray), "mw.config.backgroundTextureMode");
        Config.zoomOutLevels = configuration.getInt("zoomOutLevels", "mw.configgui.ctgy.general", Config.zoomOutLevelsDef, 1, 256, "", "mw.config.zoomOutLevels");
        Config.zoomInLevels = -configuration.getInt("zoomInLevels", "mw.configgui.ctgy.general", -Config.zoomInLevelsDef, 1, 256, "", "mw.config.zoomInLevels");
        Config.configTextureSize = configuration.getInt("textureSize", "mw.configgui.ctgy.general", Config.configTextureSizeDef, 1024, 4096, "", "mw.config.textureSize");
        Config.overlayModeIndex = configuration.getInt("overlayModeIndex", "mw.configgui.ctgy.general", Config.overlayModeIndexDef, 0, 1000, "", "mw.config.overlayModeIndex");
        Config.overlayZoomLevel = configuration.getInt("overlayZoomLevel", "mw.configgui.ctgy.general", Config.overlayZoomLevelDef, Config.zoomInLevels, Config.zoomOutLevels, "", "mw.config.overlayZoomLevel");
        Config.moreRealisticMap = configuration.getBoolean("moreRealisticMap", "mw.configgui.ctgy.general", Config.moreRealisticMapDef, "", "mw.config.moreRealisticMap");
        Config.newMarkerDialog = configuration.getBoolean("newMarkerDialog", "mw.configgui.ctgy.general", Config.newMarkerDialogDef, "", "mw.config.newMarkerDialog");
        Config.playerTrailEnabled = configuration.getBoolean("playerTrailEnabled", "mw.configgui.ctgy.general", Config.playerTrailEnabledDef, "", "mw.config.playerTrailEnabled");
        Config.playerTrailMarkerIntervalMills = configuration.getInt("playerTrailMaxLength", "mw.configgui.ctgy.general", Config.playerTrailMaxLengthDef, 1, 50, "", "mw.config.playerTrailMaxLength");
        Config.playerTrailMarkerIntervalMills = configuration.getInt("playerTrailMarkerIntervalMillis", "mw.configgui.ctgy.general", (int)Config.playerTrailMarkerIntervalMillsDef, 100, 360000, "", "mw.config.playerTrailMarkerIntervalMills");
        Config.drawMarkersDistanceInWorld = configuration.getBoolean("drawMarkersDistanceInWorld", "mw.configgui.ctgy.general", Config.drawMarkersDistanceInWorldDef, "", "mw.config.drawMarkersDistanceInWorld");
        configuration.getCategory("mw.configgui.ctgy.general").remove((Object)"drawMarkersInWorld");
        configuration.getCategory("mw.configgui.ctgy.general").remove((Object)"drawMarkersNameInWorld");
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if ("pixelradar".equalsIgnoreCase(event.getModID())) {
            Optional.ofNullable(event.getConfigID()).ifPresent(e -> {
                switch (e) {
                    case "mw.configgui.ctgy.general": {
                        ConfigurationHandler.loadConfig();
                        break;
                    }
                    case "fullscreenmap": {
                        Config.fullScreenMap.loadConfig();
                        break;
                    }
                    case "largemap": {
                        Config.largeMap.loadConfig();
                        break;
                    }
                    case "smallmap": {
                        Config.smallMap.loadConfig();
                        break;
                    }
                    case "pixelradar": {
                        Config.pokeradar.loadConfig();
                        break;
                    }
                    default: {
                        Logging.logError("Unknown pixelradar.config id: %s", event.getConfigID());
                    }
                }
            });
            if (configuration.hasChanged()) {
                configuration.save();
            }
        }
    }

    public static void setMapModeDefaults() {
        Config.fullScreenMap.setDefaults();
        Config.largeMap.setDefaults();
        Config.smallMap.setDefaults();
        Config.pokeradar.setDefaults();
    }
}

