/*
 * Decompiled with CFR 0.152.
 */
package pixelradar.config;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.config.Configuration;
import pixelradar.Mw;
import pixelradar.util.Utils;

public class WorldConfig {
    private static WorldConfig instance = null;
    public Configuration worldConfiguration;
    public List<Integer> dimensionList = new ArrayList<Integer>();

    private WorldConfig() {
        File worldConfigFile = new File(Mw.getInstance().worldDir, "pixelradar.cfg");
        this.worldConfiguration = new Configuration(worldConfigFile);
        this.initDimensionList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WorldConfig getInstance() {
        if (instance != null) return instance;
        Class<WorldConfig> clazz = WorldConfig.class;
        synchronized (WorldConfig.class) {
            if (instance != null) return instance;
            instance = new WorldConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void saveWorldConfig() {
        this.worldConfiguration.save();
    }

    public void initDimensionList() {
        this.dimensionList.clear();
        this.worldConfiguration.get("world", "dimensionList", Utils.integerListToIntArray(this.dimensionList));
        this.addDimension(0);
        this.cleanDimensionList();
    }

    public void addDimension(int dimension) {
        int i = this.dimensionList.indexOf(dimension);
        if (i < 0) {
            this.dimensionList.add(dimension);
        }
    }

    public void cleanDimensionList() {
        ArrayList<Integer> dimensionListCopy = new ArrayList<Integer>(this.dimensionList);
        this.dimensionList.clear();
        for (Integer i : dimensionListCopy) {
            int dimension = i;
            this.addDimension(dimension);
        }
    }
}

