/*
 * Decompiled with CFR 0.152.
 */
package pixelradar.entities;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.battles.raids.RaidData;
import com.pixelmonmod.pixelmon.blocks.enums.EnumPokeChestType;
import com.pixelmonmod.pixelmon.blocks.enums.EnumPokechestVisibility;
import com.pixelmonmod.pixelmon.blocks.tileEntities.TileEntityIlexShrine;
import com.pixelmonmod.pixelmon.blocks.tileEntities.TileEntityPlateHolder;
import com.pixelmonmod.pixelmon.blocks.tileEntities.TileEntityPokeChest;
import com.pixelmonmod.pixelmon.blocks.tileEntities.TileEntityShrine;
import com.pixelmonmod.pixelmon.blocks.tileEntities.TileEntityTimespaceAltar;
import com.pixelmonmod.pixelmon.blocks.tileEntities.TileEntityZygardeCell;
import com.pixelmonmod.pixelmon.entities.EntityDen;
import com.pixelmonmod.pixelmon.entities.EntityWormhole;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.npcs.EntityNPC;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.forms.IEnumForm;
import com.pixelmonmod.pixelmon.pokedex.Pokedex;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import pixelradar.config.PokeradarConfig;
import pixelradar.entities.EntityType;
import pixelradar.gui.RadarGui;
import pixelradar.map.MapRenderer;
import pixelradar.map.PKMarker;
import pixelradar.util.Reference;

public class EntityFinder {
    public static List<PKMarker> pkMarkers = new ArrayList<PKMarker>();

    public static void getAndDraw(MapRenderer mp, Minecraft mc) {
        if (mc.field_71441_e != null && mc.field_71441_e.func_72910_y().size() > 1) {
            List entityList = mc.field_71441_e.field_72996_f;
            List tileList = mc.field_71441_e.field_147482_g;
            EntityFinder.addEntityList(entityList, mp, mc);
            EntityFinder.addTileList(tileList, mp, mc);
        }
    }

    public static void addEntityList(List<Entity> entityList, MapRenderer mp, Minecraft mc) {
        for (Entity entityIt : entityList) {
            EntityPixelmon entity;
            if (entityIt instanceof EntityPixelmon) {
                entity = (EntityPixelmon)entityIt;
                if (entity.hasOwner() && !PokeradarConfig.drawPlayerPixelmonLines) continue;
                try {
                    SpawnLocationType spawnLocation = entity.getSpawnLocation();
                    EnumBossMode bossMode = entity.getBossMode();
                    EntityType type = EntityType.REGULAR;
                    String desc = "";
                    String localizedName = entity.getLocalizedName();
                    if (entity.isBossPokemon()) {
                        if (bossMode != EnumBossMode.NotBoss && bossMode != EnumBossMode.Equal) {
                            switch (bossMode) {
                                case Uncommon: {
                                    type = EntityType.BOSS_UNCOMMON;
                                    break;
                                }
                                case Rare: {
                                    type = EntityType.BOSS_RARE;
                                    break;
                                }
                                case Epic: {
                                    type = EntityType.BOSS_EPIC;
                                    break;
                                }
                                case Legendary: {
                                    type = EntityType.BOSS_LEGENDARY;
                                    break;
                                }
                                case Ultimate: {
                                    type = EntityType.BOSS_ULTIMATE;
                                    break;
                                }
                                case Spooky: {
                                    type = EntityType.BOSS_SPOOKY;
                                    break;
                                }
                                case Drowned: {
                                    type = EntityType.BOSS_DROWNED;
                                    break;
                                }
                                default: {
                                    type = EntityType.BOSS_COMMON;
                                }
                            }
                            desc = bossMode.getLocalizedName();
                        }
                    } else {
                        String name = entity.getPokemonName();
                        if (Reference.LEGENDARIES.contains(name)) {
                            type = EntityType.LEGENDARY;
                            desc = I18n.func_135052_a((String)"mw.finder.msg.legendary", (Object[])new Object[0]) + " ";
                        } else if (Reference.ULTRA_BEASTS.contains(name)) {
                            type = EntityType.ULTRA_BEAST;
                            desc = I18n.func_135052_a((String)"mw.finder.msg.ultra_beast", (Object[])new Object[0]) + " ";
                        } else if (Reference.DITTOS.contains(name)) {
                            type = EntityType.DITTO;
                            desc = I18n.func_135052_a((String)"mw.finder.msg.ditto", (Object[])new Object[0]) + " ";
                        } else {
                            IEnumForm form = entity.getPokemonData().getFormEnum();
                            boolean isShiny = entity.getPokemonData().isShiny();
                            String nameLower = name.toLowerCase();
                            if (isShiny) {
                                type = EntityType.SHINY;
                            }
                            if (RadarGui.searchString != null) {
                                String[] nameArr;
                                String lowerSearchString = RadarGui.searchString.replace("\uff0c", ",").toLowerCase();
                                for (String s : nameArr = lowerSearchString.split(",")) {
                                    if (s.trim().length() < 2 || !nameLower.contains(s.trim()) && !localizedName.contains(s.trim())) continue;
                                    type = isShiny ? EntityType.SPECIAL : EntityType.SEARCHED;
                                }
                                if (mc.func_71356_B() && (lowerSearchString.contains("pokedex") || lowerSearchString.contains(I18n.func_135052_a((String)"mw.finder.msg.dex", (Object[])new Object[0])))) {
                                    Pokedex playerDex = Pixelmon.storageManager.getParty((UUID)mc.field_71439_g.func_110124_au()).pokedex;
                                    Pokedex.loadPokedex();
                                    if (!playerDex.hasCaught(EnumSpecies.getFromNameAnyCase((String)name))) {
                                        type = EntityType.DEX;
                                        desc = I18n.func_135052_a((String)"mw.finder.msg.missingDex", (Object[])new Object[0]) + " ";
                                    }
                                }
                            }
                            if (RadarGui.getGrowth() != null) {
                                boolean foundGrowth = false;
                                if (entity.getPokemonData().getGrowth().index == 8 && RadarGui.getGrowth().equals((Object)EnumGrowth.Microscopic)) {
                                    foundGrowth = true;
                                } else if (entity.getPokemonData().getGrowth().index == 0 && RadarGui.getGrowth().equals((Object)EnumGrowth.Pygmy)) {
                                    foundGrowth = true;
                                } else if (entity.getPokemonData().getGrowth().index == 1 && RadarGui.getGrowth().equals((Object)EnumGrowth.Runt)) {
                                    foundGrowth = true;
                                } else if (entity.getPokemonData().getGrowth().index == 2 && RadarGui.getGrowth().equals((Object)EnumGrowth.Small)) {
                                    foundGrowth = true;
                                } else if (entity.getPokemonData().getGrowth().index == 3 && RadarGui.getGrowth().equals((Object)EnumGrowth.Ordinary)) {
                                    foundGrowth = true;
                                } else if (entity.getPokemonData().getGrowth().index == 4 && RadarGui.getGrowth().equals((Object)EnumGrowth.Huge)) {
                                    foundGrowth = true;
                                } else if (entity.getPokemonData().getGrowth().index == 5 && RadarGui.getGrowth().equals((Object)EnumGrowth.Giant)) {
                                    foundGrowth = true;
                                } else if (entity.getPokemonData().getGrowth().index == 6 && RadarGui.getGrowth().equals((Object)EnumGrowth.Enormous)) {
                                    foundGrowth = true;
                                } else if (entity.getPokemonData().getGrowth().index == 7 && RadarGui.getGrowth().equals((Object)EnumGrowth.Ginormous)) {
                                    foundGrowth = true;
                                }
                                type = !foundGrowth ? (isShiny ? type : EntityType.REGULAR) : (isShiny ? EntityType.SPECIAL : EntityType.SEARCHED);
                            }
                            if (RadarGui.getForm() != null) {
                                boolean foundForm = false;
                                if (RadarGui.getForm().getFormSuffix().equals(form.getFormSuffix())) {
                                    foundForm = true;
                                }
                                type = !foundForm ? (isShiny ? type : EntityType.REGULAR) : (isShiny ? EntityType.SPECIAL : EntityType.SEARCHED);
                            }
                        }
                        desc = desc + (desc.isEmpty() ? "" : " ") + "Lvl " + entity.getPokemonData().getLevel();
                    }
                    if (spawnLocation != null && "Statue".equals(spawnLocation.toString())) {
                        type = EntityType.STATUE;
                        desc = "Statue";
                    }
                    pkMarkers.add(new PKMarker(type, (Entity)entity, localizedName, desc, type.getRadius(), mp, mc.field_71441_e.field_73011_w.getDimension()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (entityIt instanceof EntityOtherPlayerMP) {
                try {
                    entity = (EntityOtherPlayerMP)entityIt;
                    pkMarkers.add(new PKMarker(EntityType.PLAYER, (Entity)entity, entity.getDisplayNameString(), I18n.func_135052_a((String)"mw.finder.msg.player", (Object[])new Object[0]), EntityType.PLAYER.getRadius(), mp, mc.field_71441_e.field_73011_w.getDimension()));
                }
                catch (IllegalArgumentException | SecurityException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (entityIt instanceof NPCTrainer) {
                try {
                    entity = (NPCTrainer)entityIt;
                    pkMarkers.add(new PKMarker(EntityType.NPC, (Entity)entity, I18n.func_135052_a((String)"mw.finder.msg.npcTrainer", (Object[])new Object[0]), "Lvl: " + entity.getDisplayText(), EntityType.NPC.getRadius(), mp, mc.field_71441_e.field_73011_w.getDimension()));
                }
                catch (IllegalArgumentException | SecurityException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (entityIt instanceof EntityWormhole) {
                try {
                    entity = (EntityWormhole)entityIt;
                    pkMarkers.add(new PKMarker(EntityType.WORMHOLE, (Entity)entity, I18n.func_135052_a((String)"mw.finder.msg.wormhole", (Object[])new Object[0]), " ", EntityType.WORMHOLE.getRadius(), mp, mc.field_71441_e.field_73011_w.getDimension()));
                }
                catch (IllegalArgumentException | SecurityException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (entityIt instanceof EntityNPC) {
                try {
                    entity = (EntityNPC)entityIt;
                    pkMarkers.add(new PKMarker(EntityType.NPC, (Entity)entity, entity.getDisplayText(), I18n.func_135052_a((String)"mw.finder.msg.npc", (Object[])new Object[0]), EntityType.NPC.getRadius(), mp, mc.field_71441_e.field_73011_w.getDimension()));
                }
                catch (IllegalArgumentException | SecurityException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (!(entityIt instanceof EntityDen)) continue;
            try {
                entity = (EntityDen)entityIt;
                pkMarkers.add(new PKMarker(EntityType.DEN, (Entity)entity, I18n.func_135052_a((String)"mw.finder.msg.den", (Object[])new Object[0]), entity.getDisplay().isPresent() ? ((EntityPixelmon)entity.getDisplay().get()).getLocalizedName() + (entity.getData().isPresent() ? " R" + ((RaidData)entity.getData().get()).getStars() : "") : "", EntityType.DEN.getRadius(), mp, mc.field_71441_e.field_73011_w.getDimension()));
            }
            catch (IllegalArgumentException | SecurityException e) {
                e.printStackTrace();
            }
        }
    }

    private static void addTileList(List<TileEntity> tileList, MapRenderer mp, Minecraft mc) {
        for (TileEntity tileIt : tileList) {
            if (tileIt instanceof TileEntityPokeChest) {
                String desc;
                TileEntityPokeChest tile = (TileEntityPokeChest)tileIt;
                if (tile.getVisibility() == EnumPokechestVisibility.Hidden) {
                    desc = I18n.func_135052_a((String)"mw.finder.msg.loot.hidden", (Object[])new Object[0]);
                } else {
                    EnumPokeChestType chestType = tile.getType();
                    switch (chestType) {
                        case POKEBALL: {
                            desc = I18n.func_135052_a((String)"mw.finder.msg.loot.tier1", (Object[])new Object[0]);
                            break;
                        }
                        case ULTRABALL: {
                            desc = I18n.func_135052_a((String)"mw.finder.msg.loot.tier2", (Object[])new Object[0]);
                            break;
                        }
                        case MASTERBALL: {
                            desc = I18n.func_135052_a((String)"mw.finder.msg.loot.tier3", (Object[])new Object[0]);
                            break;
                        }
                        case BEASTBALL: {
                            desc = I18n.func_135052_a((String)"mw.finder.msg.loot.tier4", (Object[])new Object[0]);
                            break;
                        }
                        default: {
                            desc = I18n.func_135052_a((String)"mw.finder.msg.loot.special", (Object[])new Object[0]);
                        }
                    }
                }
                pkMarkers.add(new PKMarker(EntityType.LOOT, (TileEntity)tile, I18n.func_135052_a((String)"mw.finder.msg.loot", (Object[])new Object[0]), desc, EntityType.LOOT.getRadius(), mp, mc.field_71441_e.field_73011_w.getDimension()));
                continue;
            }
            if (tileIt instanceof TileEntityShrine) {
                EntityFinder.addShrine(tileIt, TileEntityShrine.class, mp, mc);
                continue;
            }
            if (tileIt instanceof TileEntityTimespaceAltar) {
                EntityFinder.addShrine(tileIt, TileEntityTimespaceAltar.class, mp, mc);
                continue;
            }
            if (tileIt instanceof TileEntityPlateHolder) {
                EntityFinder.addShrine(tileIt, TileEntityPlateHolder.class, mp, mc);
                continue;
            }
            if (tileIt instanceof TileEntityIlexShrine) {
                EntityFinder.addShrine(tileIt, TileEntityIlexShrine.class, mp, mc);
                continue;
            }
            if (!(tileIt instanceof TileEntityZygardeCell)) continue;
            EntityFinder.addGadget(tileIt, TileEntityZygardeCell.class, mp, mc);
        }
    }

    private static void addShrine(TileEntity tile, Class<? extends TileEntity> clazz, MapRenderer mp, Minecraft mc) {
        TileEntity tileEntity = clazz.cast(tile);
        String type = Optional.of(tileEntity.func_145838_q().func_149732_F()).orElse("");
        pkMarkers.add(new PKMarker(EntityType.SHRINE, tileEntity, I18n.func_135052_a((String)"mw.finder.msg.shrine", (Object[])new Object[0]), type, EntityType.SHRINE.getRadius(), mp, mc.field_71441_e.field_73011_w.getDimension()));
    }

    private static void addGadget(TileEntity tile, Class<? extends TileEntity> clazz, MapRenderer mp, Minecraft mc) {
        TileEntity tileEntity = clazz.cast(tile);
        String type = Optional.of(tileEntity.func_145838_q().func_149732_F()).orElse("");
        pkMarkers.add(new PKMarker(EntityType.GADGET, tileEntity, I18n.func_135052_a((String)"mw.finder.msg.gadget", (Object[])new Object[0]), type, EntityType.GADGET.getRadius(), mp, mc.field_71441_e.field_73011_w.getDimension()));
    }
}

