/*
 * Decompiled with CFR 0.152.
 */
package pixelradar.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public abstract class MwGuiSlot {
    protected final Minecraft mc;
    public int width;
    public int height;
    public int top;
    public int bottom;
    public int right;
    public int left;
    public final int scrollBarWidth = 6;
    private int scrollUpButtonID;
    private int scrollDownButtonID;
    protected int mouseX;
    protected int mouseY;
    protected boolean centerListVertically = true;
    protected float initialClickY = -2.0f;
    protected float scrollMultiplier;
    protected float amountScrolled;
    protected int selectedElement = -1;
    protected long lastClicked;
    protected boolean showSelectionBox = true;
    protected boolean hasListHeader;
    public int headerPadding;
    private boolean enabled = false;
    int spacingY = 4;

    public MwGuiSlot(Minecraft mcIn, int width, int height, int topIn, int bottomIn, int left) {
        this.mc = mcIn;
        this.width = width;
        this.height = height;
        this.top = topIn;
        this.bottom = bottomIn;
        this.left = left;
        this.right = left + width;
    }

    public void setDimensions(int widthIn, int heightIn, int topIn, int bottomIn, int left) {
        this.width = widthIn;
        this.height = heightIn;
        this.top = topIn;
        this.bottom = bottomIn;
        this.left = left;
        this.right = left + widthIn;
    }

    public void setShowSelectionBox(boolean showSelectionBoxIn) {
        this.showSelectionBox = showSelectionBoxIn;
    }

    protected void setHasListHeader(boolean hasListHeaderIn, int headerPaddingIn) {
        this.hasListHeader = hasListHeaderIn;
        this.headerPadding = headerPaddingIn;
        if (!hasListHeaderIn) {
            this.headerPadding = 0;
        }
    }

    protected abstract int getSize();

    protected abstract void elementClicked(int var1, boolean var2, int var3, int var4, int var5);

    protected abstract boolean isSelected(int var1);

    protected abstract int getSlotHeight(int var1);

    protected int getContentHeight() {
        int slotHeight = this.headerPadding;
        for (int index = 0; index < this.getSize(); ++index) {
            slotHeight += this.getSlotHeight(index);
        }
        return slotHeight;
    }

    protected abstract void drawBackground();

    protected void slotOutOfBounds(int index, int p_178040_2_, int p_178040_3_) {
    }

    protected abstract void drawSlot(int var1, int var2, int var3, int var4, int var5, int var6);

    protected void drawListHeader(int x, int y, Tessellator tess) {
    }

    protected void clickedHeader(int p_148132_1_, int p_148132_2_) {
    }

    protected void renderDecorations(int p_148142_1_, int p_148142_2_) {
    }

    public int getSlotIndexFromScreenCoords(int x, int y) {
        int k = this.left + (this.width / 2 - this.getListWidth() / 2);
        this.getClass();
        int l = this.left + (this.width / 2 + this.getListWidth() / 2) - 6;
        int i1 = y - this.top - this.headerPadding + (int)this.amountScrolled;
        int yStart = 0;
        int yStop = yStart + this.getSlotHeight(0);
        for (int index = 0; index < this.getSize(); ++index) {
            if (i1 >= yStart && i1 <= yStop) {
                return x < this.getScrollBarX() && x >= k && x <= l && i1 >= 0 ? index : -1;
            }
            yStart = yStop;
            yStop += this.getSlotHeight(index + 1);
        }
        return -1;
    }

    public void registerScrollButtons(int scrollUpButtonIDIn, int scrollDownButtonIDIn) {
        this.scrollUpButtonID = scrollUpButtonIDIn;
        this.scrollDownButtonID = scrollDownButtonIDIn;
    }

    protected void bindAmountScrolled() {
        int i = this.getMaxScroll();
        if (i < 0) {
            i /= 2;
        }
        if (!this.centerListVertically && i < 0) {
            i = 0;
        }
        this.amountScrolled = MathHelper.func_76131_a((float)this.amountScrolled, (float)0.0f, (float)i);
    }

    public int getMaxScroll() {
        return Math.max(0, this.getContentHeight() - (this.bottom - this.top));
    }

    public int getAmountScrolled() {
        return (int)this.amountScrolled;
    }

    public boolean isMouseYWithinSlotBounds() {
        return this.mouseY >= this.top && this.mouseY <= this.bottom;
    }

    public boolean isMouseXWithinSlotBounds() {
        return this.mouseX >= this.left && this.mouseX <= this.right;
    }

    public boolean isMouseInField() {
        return this.isMouseYWithinSlotBounds() && this.isMouseXWithinSlotBounds();
    }

    public void scrollBy(int amount) {
        this.amountScrolled += (float)amount;
        this.bindAmountScrolled();
        this.initialClickY = -2.0f;
    }

    public void actionPerformed(GuiButton button) {
        if (button.field_146124_l) {
            int slotHeight = this.getAverageSlotHeight();
            if (button.field_146127_k == this.scrollUpButtonID) {
                this.amountScrolled -= (float)(slotHeight * 2 / 3);
                this.initialClickY = -2.0f;
                this.bindAmountScrolled();
            } else if (button.field_146127_k == this.scrollDownButtonID) {
                this.amountScrolled += (float)(slotHeight * 2 / 3);
                this.initialClickY = -2.0f;
                this.bindAmountScrolled();
            }
        }
    }

    public void drawScreen(int mouseXIn, int mouseYIn, float f) {
        if (this.getEnabled()) {
            this.mouseX = mouseXIn;
            this.mouseY = mouseYIn;
            this.drawBackground();
            int k = this.getScrollBarX();
            this.getClass();
            int l = k + 6;
            this.bindAmountScrolled();
            GlStateManager.func_179140_f();
            GlStateManager.func_179106_n();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vertexbuffer = tessellator.func_178180_c();
            this.drawContainerBackground(tessellator);
            int i1 = this.left + (this.width / 2 - this.getListWidth() / 2);
            int j1 = this.top - (int)this.amountScrolled;
            if (this.hasListHeader) {
                this.drawListHeader(i1, j1, tessellator);
            }
            this.drawSelectionBox(i1, j1, mouseXIn, mouseYIn);
            GlStateManager.func_179097_i();
            GlStateManager.func_179147_l();
            GlStateManager.func_179120_a((int)770, (int)771, (int)0, (int)1);
            GlStateManager.func_179118_c();
            GlStateManager.func_179103_j((int)7425);
            GlStateManager.func_179090_x();
            int k1 = this.getMaxScroll();
            if (k1 > 0) {
                int l1 = (this.bottom - this.top) * (this.bottom - this.top) / this.getContentHeight();
                int i2 = (int)this.amountScrolled * (this.bottom - this.top - (l1 = MathHelper.func_76125_a((int)l1, (int)32, (int)(this.bottom - this.top - 8)))) / k1 + this.top;
                if (i2 < this.top) {
                    i2 = this.top;
                }
                vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                vertexbuffer.func_181662_b((double)k, (double)this.bottom, 0.0).func_187315_a(0.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                vertexbuffer.func_181662_b((double)l, (double)this.bottom, 0.0).func_187315_a(1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                vertexbuffer.func_181662_b((double)l, (double)this.top, 0.0).func_187315_a(1.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                vertexbuffer.func_181662_b((double)k, (double)this.top, 0.0).func_187315_a(0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                tessellator.func_78381_a();
                vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                vertexbuffer.func_181662_b((double)k, (double)(i2 + l1), 0.0).func_187315_a(0.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                vertexbuffer.func_181662_b((double)l, (double)(i2 + l1), 0.0).func_187315_a(1.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                vertexbuffer.func_181662_b((double)l, (double)i2, 0.0).func_187315_a(1.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                vertexbuffer.func_181662_b((double)k, (double)i2, 0.0).func_187315_a(0.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                tessellator.func_78381_a();
                vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                vertexbuffer.func_181662_b((double)k, (double)(i2 + l1 - 1), 0.0).func_187315_a(0.0, 1.0).func_181669_b(192, 192, 192, 255).func_181675_d();
                vertexbuffer.func_181662_b((double)(l - 1), (double)(i2 + l1 - 1), 0.0).func_187315_a(1.0, 1.0).func_181669_b(192, 192, 192, 255).func_181675_d();
                vertexbuffer.func_181662_b((double)(l - 1), (double)i2, 0.0).func_187315_a(1.0, 0.0).func_181669_b(192, 192, 192, 255).func_181675_d();
                vertexbuffer.func_181662_b((double)k, (double)i2, 0.0).func_187315_a(0.0, 0.0).func_181669_b(192, 192, 192, 255).func_181675_d();
                tessellator.func_78381_a();
            }
            this.renderDecorations(mouseXIn, mouseYIn);
            GlStateManager.func_179098_w();
            GlStateManager.func_179103_j((int)7424);
            GlStateManager.func_179141_d();
            GlStateManager.func_179084_k();
        }
    }

    public void handleMouseInput() {
        if (this.isMouseInField()) {
            int l1;
            if (Mouse.isButtonDown((int)0) && this.getEnabled()) {
                if (this.initialClickY == -1.0f) {
                    boolean flag = true;
                    if (this.mouseY >= this.top && this.mouseY <= this.bottom) {
                        int i = this.width / 2 - this.getListWidth() / 2 + this.left;
                        this.getClass();
                        int j = this.width / 2 + this.getListWidth() / 2 + this.left - 6;
                        int k = this.mouseY - this.top - this.headerPadding + (int)this.amountScrolled;
                        int l = this.getSlotIndexFromScreenCoords(this.mouseX, this.mouseY);
                        if (this.mouseX >= i && this.mouseX <= j && l >= 0 && k >= 0 && l < this.getSize()) {
                            boolean flag1 = l == this.selectedElement && Minecraft.func_71386_F() - this.lastClicked < 250L;
                            this.elementClicked(l, flag1, this.mouseX, this.mouseY, 0);
                            this.selectedElement = l;
                            this.lastClicked = Minecraft.func_71386_F();
                        } else if (this.mouseX >= i && this.mouseX <= j && k < 0) {
                            this.clickedHeader(this.mouseX - i, this.mouseY - this.top + (int)this.amountScrolled);
                            flag = false;
                        }
                        int i2 = this.getScrollBarX();
                        this.getClass();
                        int i1 = i2 + 6;
                        if (this.mouseX >= i2 && this.mouseX <= i1) {
                            this.scrollMultiplier = -1.0f;
                            int j1 = this.getMaxScroll();
                            if (j1 < 1) {
                                j1 = 1;
                            }
                            int k1 = (this.bottom - this.top) * (this.bottom - this.top) / this.getContentHeight();
                            k1 = MathHelper.func_76125_a((int)k1, (int)32, (int)(this.bottom - this.top - 8));
                            this.scrollMultiplier = (float)((double)this.scrollMultiplier / ((double)(this.bottom - this.top - k1) / (double)j1));
                        } else {
                            this.scrollMultiplier = 1.0f;
                        }
                        this.initialClickY = flag ? (float)this.mouseY : -2.0f;
                    } else {
                        this.initialClickY = -2.0f;
                    }
                } else if (this.initialClickY >= 0.0f) {
                    this.amountScrolled -= ((float)this.mouseY - this.initialClickY) * this.scrollMultiplier;
                    this.initialClickY = this.mouseY;
                }
            } else {
                this.initialClickY = -1.0f;
            }
            if (Mouse.isButtonDown((int)1) && this.getEnabled() && this.initialClickY == -1.0f && this.mouseY >= this.top && this.mouseY <= this.bottom) {
                int i = this.width / 2 - this.getListWidth() / 2 + this.left;
                this.getClass();
                int j = this.width / 2 + this.getListWidth() / 2 + this.left - 6;
                int k = this.mouseY - this.top - this.headerPadding + (int)this.amountScrolled;
                int l = this.getSlotIndexFromScreenCoords(this.mouseX, this.mouseY);
                if (this.mouseX >= i && this.mouseX <= j && l >= 0 && k >= 0 && l < this.getSize()) {
                    boolean flag1 = l == this.selectedElement && Minecraft.func_71386_F() - this.lastClicked < 250L;
                    this.elementClicked(l, flag1, this.mouseX, this.mouseY, 1);
                    this.selectedElement = l;
                    this.lastClicked = Minecraft.func_71386_F();
                } else if (this.mouseX >= i && this.mouseX <= j && k < 0) {
                    this.clickedHeader(this.mouseX - i, this.mouseY - this.top + (int)this.amountScrolled);
                }
            }
            if ((l1 = Mouse.getEventDWheel()) != 0) {
                if (l1 > 0) {
                    l1 = -1;
                } else if (l1 < 0) {
                    l1 = 1;
                }
                this.amountScrolled += (float)(l1 * this.getAverageSlotHeight() / 2);
            }
        }
    }

    public void setEnabled(boolean enabledIn) {
        this.enabled = enabledIn;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public int getListWidth() {
        return this.width;
    }

    protected void drawSelectionBox(int x, int y, int mouseXIn, int mouseYIn) {
        int i1 = this.getSize();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        int yTotal = y + this.headerPadding;
        for (int index = 0; index < i1; ++index) {
            int slotHeight = this.getSlotHeight(index);
            if (yTotal + slotHeight > this.bottom || yTotal < this.top) {
                this.slotOutOfBounds(index, x, yTotal);
                yTotal += slotHeight;
                continue;
            }
            if (this.showSelectionBox && this.isSelected(index)) {
                int xLeft = this.left + (this.width / 2 - this.getListWidth() / 2);
                this.getClass();
                int xRight = this.left + (this.width / 2 + this.getListWidth() / 2) - 6;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179090_x();
                vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                vertexbuffer.func_181662_b((double)xLeft, (double)(yTotal + slotHeight), 0.0).func_187315_a(0.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                vertexbuffer.func_181662_b((double)xRight, (double)(yTotal + slotHeight), 0.0).func_187315_a(1.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                vertexbuffer.func_181662_b((double)xRight, (double)yTotal, 0.0).func_187315_a(1.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                vertexbuffer.func_181662_b((double)xLeft, (double)yTotal, 0.0).func_187315_a(0.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                vertexbuffer.func_181662_b((double)(xLeft + 1), (double)(yTotal + slotHeight - 1), 0.0).func_187315_a(0.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                vertexbuffer.func_181662_b((double)(xRight - 1), (double)(yTotal + slotHeight - 1), 0.0).func_187315_a(1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                vertexbuffer.func_181662_b((double)(xRight - 1), (double)(yTotal + 1), 0.0).func_187315_a(1.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                vertexbuffer.func_181662_b((double)(xLeft + 1), (double)(yTotal + 1), 0.0).func_187315_a(0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_179098_w();
            }
            this.drawSlot(index, x + 4, yTotal + this.spacingY, slotHeight, mouseXIn, mouseYIn);
            yTotal += slotHeight;
        }
    }

    protected int getScrollBarX() {
        this.getClass();
        return this.left + this.width - 6;
    }

    public void setSlotXBoundsFromLeft(int leftIn) {
        this.left = leftIn;
        this.right = leftIn + this.width;
    }

    public int getAverageSlotHeight() {
        int height = 0;
        int biggest = 0;
        for (int index = 0; index < this.getSize(); ++index) {
            int slotheight = this.getSlotHeight(index);
            height += slotheight;
            biggest = biggest < slotheight ? slotheight : biggest;
        }
        return height > 0 ? height / this.getSize() : 9;
    }

    protected void drawContainerBackground(Tessellator tessellator) {
        Gui.func_73734_a((int)this.left, (int)this.top, (int)this.right, (int)this.bottom, (int)Integer.MIN_VALUE);
    }
}

