/*
 * Decompiled with CFR 0.152.
 */
package pixelradar.gui;

import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pixelradar.Mw;
import pixelradar.config.Config;
import pixelradar.gui.MwGuiTextDialog;
import pixelradar.map.MapView;

@SideOnly(value=Side.CLIENT)
public class MwGuiTeleportDialog
extends MwGuiTextDialog {
    final Mw mw;
    final MapView mapView;
    final int teleportX;
    final int teleportZ;

    public MwGuiTeleportDialog(GuiScreen parentScreen, Mw mw, MapView mapView, int x, int y, int z) {
        super(parentScreen, I18n.func_135052_a((String)"mw.gui.mwguimarkerdialognew.title", (Object[])new Object[0]) + ":", Integer.toString(y), I18n.func_135052_a((String)"mw.gui.mwguimarkerdialognew.error", (Object[])new Object[0]));
        this.mw = mw;
        this.mapView = mapView;
        this.teleportX = x;
        this.teleportZ = z;
        this.backToGameOnSubmit = true;
    }

    @Override
    public boolean submit() {
        boolean done = false;
        int height = this.getInputAsInt();
        if (this.inputValid) {
            Config.defaultTeleportHeight = height = Math.min(Math.max(0, height), 255);
            this.mw.teleportToMapPos(this.mapView, this.teleportX, height, this.teleportZ);
            done = true;
        }
        return done;
    }
}

