/*
 * Decompiled with CFR 0.152.
 */
package pixelradar.map;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import pixelradar.Mw;
import pixelradar.api.IMwChunkOverlay;
import pixelradar.api.IMwDataProvider;
import pixelradar.api.MwAPI;
import pixelradar.config.Config;
import pixelradar.config.MapModeConfig;
import pixelradar.config.PokeradarConfig;
import pixelradar.entities.EntityFinder;
import pixelradar.map.MapView;
import pixelradar.map.MapViewRequest;
import pixelradar.map.mapmode.MapMode;
import pixelradar.util.Reference;
import pixelradar.util.Render;

public class MapRenderer {
    protected Mw mw;
    private MapMode mapMode;
    private MapView mapView;
    public Point2D.Double playerArrowScreenPos = new Point2D.Double(0.0, 0.0);
    private int textOffset = 12;
    private int textY = 0;
    private int textX = 0;

    public MapRenderer(Mw mw, MapMode mapMode, MapView mapView) {
        this.mw = mw;
        this.mapMode = mapMode;
        this.mapView = mapView;
    }

    private void drawMap() {
        double h;
        double w;
        double v;
        double u;
        int regionZoomLevel = Math.max(0, this.mapView.getZoomLevel());
        double tSize = this.mw.textureSize;
        double zoomScale = 1 << regionZoomLevel;
        if (!this.mapMode.getConfig().circular && Config.mapPixelSnapEnabled && this.mapView.getZoomLevel() >= 0) {
            u = (double)Math.round(this.mapView.getMinX() / zoomScale) / tSize % 1.0;
            v = (double)Math.round(this.mapView.getMinZ() / zoomScale) / tSize % 1.0;
            w = (double)Math.round(this.mapView.getWidth() / zoomScale) / tSize;
            h = (double)Math.round(this.mapView.getHeight() / zoomScale) / tSize;
        } else {
            double tSizeInBlocks = tSize * zoomScale;
            u = this.mapView.getMinX() / tSizeInBlocks % 1.0;
            v = this.mapView.getMinZ() / tSizeInBlocks % 1.0;
            w = this.mapView.getWidth() / tSizeInBlocks;
            h = this.mapView.getHeight() / tSizeInBlocks;
        }
        GlStateManager.func_179094_E();
        if (this.mapMode.getConfig().rotate && this.mapMode.getConfig().circular) {
            GlStateManager.func_179114_b((float)this.mw.mapRotationDegrees, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if (this.mapMode.getConfig().circular) {
            Render.setCircularStencil(0.0, 0.0, (double)this.mapMode.getH() / 2.0);
        }
        if (this.mapView.getUndergroundMode() && regionZoomLevel == 0) {
            this.mw.undergroundMapTexture.requestView(this.mapView);
            Render.setColourWithAlphaPercent(0, this.mapMode.getConfig().alphaPercent);
            Render.drawRect(this.mapMode.getX(), this.mapMode.getY(), this.mapMode.getW(), this.mapMode.getH());
            Render.setColourWithAlphaPercent(0xFFFFFF, this.mapMode.getConfig().alphaPercent);
            this.mw.undergroundMapTexture.bind();
            Render.drawTexturedRect(this.mapMode.getX(), this.mapMode.getY(), this.mapMode.getW(), this.mapMode.getH(), u, v, u + w, v + h);
        } else {
            MapViewRequest req = new MapViewRequest(this.mapView);
            this.mw.mapTexture.requestView(req, this.mw.executor, this.mw.regionManager);
            this.drawBackground(tSize, u, v, w, h);
            if (this.mw.mapTexture.isLoaded(req)) {
                this.mw.mapTexture.bind();
                Render.setColourWithAlphaPercent(0xFFFFFF, this.mapMode.getConfig().alphaPercent);
                Render.drawTexturedRect(this.mapMode.getX(), this.mapMode.getY(), this.mapMode.getW(), this.mapMode.getH(), u, v, u + w, v + h);
            }
        }
        IMwDataProvider provider = this.drawOverlay();
        if (provider != null) {
            GlStateManager.func_179094_E();
            provider.onDraw(this.mapView, this.mapMode);
            GlStateManager.func_179121_F();
        }
        if (this.mapMode.getConfig().circular) {
            Render.disableStencil();
        }
        GlStateManager.func_179121_F();
    }

    private void drawBackground(double tSize, double u, double v, double w, double h) {
        if (!Config.backgroundTextureMode.equals(Config.backgroundModeStringArray[0])) {
            double bu1 = 0.0;
            double bu2 = 1.0;
            double bv1 = 0.0;
            double bv2 = 1.0;
            if (Config.backgroundTextureMode.equals(Config.backgroundModeStringArray[2])) {
                double bSize = tSize / 256.0;
                bu1 = u * bSize;
                bu2 = (u + w) * bSize;
                bv1 = v * bSize;
                bv2 = (v + h) * bSize;
            }
            this.mw.mc.field_71446_o.func_110577_a(Reference.backgroundTexture);
            Render.setColourWithAlphaPercent(0xFFFFFF, this.mapMode.getConfig().alphaPercent);
            Render.drawTexturedRect(this.mapMode.getX(), this.mapMode.getY(), this.mapMode.getW(), this.mapMode.getH(), bu1, bv1, bu2, bv2);
        } else {
            Render.setColourWithAlphaPercent(0, this.mapMode.getConfig().alphaPercent);
            Render.drawRect(this.mapMode.getX(), this.mapMode.getY(), this.mapMode.getW(), this.mapMode.getH());
        }
    }

    private void drawBorder() {
        if (this.mapMode.getConfig().circular) {
            this.mw.mc.field_71446_o.func_110577_a(Reference.roundMapTexture);
        } else {
            this.mw.mc.field_71446_o.func_110577_a(Reference.squareMapTexture);
        }
        Render.setColour(-1);
        Render.drawTexturedRect((double)this.mapMode.getX() / 0.75, (double)this.mapMode.getY() / 0.75, (double)this.mapMode.getW() / 0.75, (double)this.mapMode.getH() / 0.75, 0.0, 0.0, 1.0, 1.0);
    }

    public void drawEntityArrow(double x, double z, double r, boolean isPlayer) {
        double scale = this.mapView.getDimensionScaling(this.mapView.getDimension());
        Point2D.Double p = this.mapMode.getClampedScreenXY(this.mapView, x * scale, z * scale);
        if (isPlayer) {
            Render.setColour(-16777216);
            Render.drawArrow(p.x, p.y, r, 6.5);
            Render.setColour(-16776961);
        } else {
            Render.setColour(Color.BLACK.getRGB());
            Render.drawArrow(p.x, p.y, r, 6.5);
            Render.setColour(Color.LIGHT_GRAY.getRGB());
        }
        Render.drawArrow(p.x, p.y, r, 5.0);
    }

    private void drawPlayerArrow() {
        GlStateManager.func_179094_E();
        double scale = this.mapView.getDimensionScaling(this.mw.playerDimension);
        Point2D.Double p = this.mapMode.getClampedScreenXY(this.mapView, this.mw.playerX * scale, this.mw.playerZ * scale);
        this.playerArrowScreenPos.setLocation(p.x + (double)this.mapMode.getXTranslation(), p.y + (double)this.mapMode.getYTranslation());
        GlStateManager.func_179137_b((double)p.x, (double)p.y, (double)0.0);
        if (!this.mapMode.getConfig().rotate || !this.mapMode.getConfig().circular) {
            GlStateManager.func_179114_b((float)(-this.mw.mapRotationDegrees), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        double arrowSize = this.mapMode.getConfig().playerArrowSize;
        Render.setColour(-1);
        this.mw.mc.field_71446_o.func_110577_a(Reference.playerArrowTexture);
        Render.drawTexturedRect(-arrowSize, -arrowSize, arrowSize * 2.0, arrowSize * 2.0, 0.0, 0.0, 1.0, 1.0);
        GlStateManager.func_179121_F();
        EntityFinder.getAndDraw(this, this.mw.mc);
    }

    private void drawIcons() {
        GlStateManager.func_179094_E();
        if (this.mapMode.getConfig().rotate && this.mapMode.getConfig().circular) {
            GlStateManager.func_179114_b((float)this.mw.mapRotationDegrees, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        this.mw.markerManager.drawMarkers(this.mapMode, this.mapView);
        this.mw.markerManager.drawPKMarkers(this.mapMode, this.mapView, this, this.mw.mapRotationDegrees);
        if (this.mw.playerTrail.enabled) {
            this.mw.playerTrail.draw(this.mapMode, this.mapView);
        }
        this.drawNorthArrow();
        GlStateManager.func_179121_F();
        this.drawPlayerArrow();
    }

    private void drawNorthArrow() {
        if (this.mapMode.getConfig().rotate) {
            double y = (double)this.mapMode.getH() / 2.0;
            double arrowSize = this.mapMode.getConfig().playerArrowSize;
            Render.setColour(-1);
            this.mw.mc.field_71446_o.func_110577_a(Reference.northArrowTexture);
            Render.drawTexturedRect(-arrowSize, -y - arrowSize * 2.0, arrowSize * 2.0, arrowSize * 2.0, 0.0, 0.0, 1.0, 1.0);
        }
    }

    private void drawStatusText() {
        this.textOffset = 12;
        this.textY = this.mapMode.getTextY();
        this.textX = this.mapMode.getTextX();
        this.drawCoords();
        this.drawBiomeName();
        this.drawUndergroundMode();
    }

    private void drawCoords() {
        if (!this.mapMode.getConfig().coordsMode.equals(MapModeConfig.coordsModeStringArray[0])) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.textX, (float)this.textY, (float)0.0f);
            if (this.mapMode.getConfig().coordsMode.equals(MapModeConfig.coordsModeStringArray[1])) {
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)1.0f);
                this.textOffset = (int)((float)this.textOffset * 0.5f);
            }
            Render.drawCentredString(0, 0, this.mapMode.getTextColour(), "%d, %d, %d", this.mw.playerXInt, this.mw.playerYInt, this.mw.playerZInt);
            this.textY += this.textOffset;
            GlStateManager.func_179121_F();
        }
    }

    private void drawBiomeName() {
        if (!this.mapMode.getConfig().biomeMode.equals(MapModeConfig.coordsModeStringArray[0])) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.textX, (float)this.textY, (float)0.0f);
            if (this.mapMode.getConfig().biomeMode.equals(MapModeConfig.coordsModeStringArray[1])) {
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)1.0f);
                this.textOffset = (int)((float)this.textOffset * 0.5f);
            }
            Render.drawCentredString(0, 0, this.mapMode.getTextColour(), "".equals(this.mw.playerBiome) ? "BiomeName" : this.mw.playerBiome, new Object[0]);
            this.textY += this.textOffset;
            GlStateManager.func_179121_F();
        }
    }

    private void drawUndergroundMode() {
        if (Config.undergroundMode) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.textX, (float)this.textY, (float)0.0f);
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)1.0f);
            this.textOffset = (int)((float)this.textOffset * 0.5f);
            Render.drawCentredString(0, 0, this.mapMode.getTextColour(), I18n.func_135052_a((String)"key.mw_underground_mode", (Object[])new Object[0]), new Object[0]);
            this.textY += this.textOffset;
            GlStateManager.func_179121_F();
        }
    }

    private IMwDataProvider drawOverlay() {
        ArrayList<IMwChunkOverlay> overlays;
        IMwDataProvider provider = MwAPI.getCurrentDataProvider();
        if (provider != null && (overlays = provider.getChunksOverlay(this.mapView.getDimension(), this.mapView.getX(), this.mapView.getZ(), this.mapView.getMinX(), this.mapView.getMinZ(), this.mapView.getMaxX(), this.mapView.getMaxZ())) != null) {
            for (IMwChunkOverlay overlay : overlays) {
                MapRenderer.paintChunk(this.mapMode, this.mapView, overlay);
            }
        }
        return provider;
    }

    public void draw() {
        this.mapMode.updateMargin();
        this.mapMode.setScreenRes();
        this.mapView.setMapWH(this.mapMode);
        this.mapView.setTextureSize(this.mw.textureSize);
        if (PokeradarConfig.enableMap) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)this.mapMode.getXTranslation(), (double)this.mapMode.getYTranslation(), (double)0.0);
            this.drawMap();
            if (this.mapMode.getConfig().borderMode) {
                this.drawBorder();
            }
            this.drawIcons();
            this.drawStatusText();
            GlStateManager.func_179126_j();
            GlStateManager.func_179121_F();
        }
        EntityFinder.getAndDraw(this, this.mw.mc);
    }

    public void drawDummy() {
        double h;
        double w;
        this.mapMode.updateMargin();
        this.mapMode.setScreenRes();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)this.mapMode.getXTranslation(), (double)this.mapMode.getYTranslation(), (double)1000.0);
        double u = 0.0;
        double v = 0.0;
        if (!this.mapMode.getConfig().circular) {
            w = this.mapMode.getConfig().widthPercent / 100.0;
            h = this.mapMode.getConfig().heightPercent / 100.0;
        } else {
            double scale1 = this.mw.mc.field_71443_c < this.mw.mc.field_71440_d ? 1.0 : (double)this.mw.mc.field_71440_d / (double)this.mw.mc.field_71443_c;
            double scale2 = this.mw.mc.field_71443_c < this.mw.mc.field_71440_d ? (double)this.mw.mc.field_71443_c / (double)this.mw.mc.field_71440_d : 1.0;
            w = this.mapMode.getConfig().widthPercent / 100.0 * scale1;
            h = this.mapMode.getConfig().heightPercent / 100.0 * scale2;
        }
        GlStateManager.func_179094_E();
        if (this.mapMode.getConfig().rotate && this.mapMode.getConfig().circular) {
            GlStateManager.func_179114_b((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if (this.mapMode.getConfig().circular) {
            Render.setCircularStencil(0.0, 0.0, (double)this.mapMode.getH() / 2.0);
        }
        this.mw.mc.field_71446_o.func_110577_a(Reference.DummyMapTexture);
        Render.setColourWithAlphaPercent(0xFFFFFF, 60);
        Render.drawTexturedRect(this.mapMode.getX(), this.mapMode.getY(), this.mapMode.getW(), this.mapMode.getH(), u, v, u + w, v + h);
        if (this.mapMode.getConfig().circular) {
            Render.disableStencil();
        }
        GlStateManager.func_179121_F();
        if (this.mapMode.getConfig().borderMode) {
            this.drawBorder();
        }
        GlStateManager.func_179094_E();
        if (this.mapMode.getConfig().rotate && this.mapMode.getConfig().circular) {
            GlStateManager.func_179114_b((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if (this.mapMode.getConfig().rotate) {
            this.drawNorthArrow();
        }
        GlStateManager.func_179121_F();
        this.drawStatusText();
        GlStateManager.func_179126_j();
        GlStateManager.func_179121_F();
    }

    private static void paintChunk(MapMode mapMode, MapView mapView, IMwChunkOverlay overlay) {
        int chunkX = overlay.getCoordinates().x;
        int chunkZ = overlay.getCoordinates().y;
        float filling = overlay.getFilling();
        Point2D.Double topCorner = mapMode.blockXZtoScreenXY(mapView, chunkX << 4, chunkZ << 4);
        Point2D.Double botCorner = mapMode.blockXZtoScreenXY(mapView, chunkX + 1 << 4, chunkZ + 1 << 4);
        MapRenderer.calCornerCoords(mapMode, topCorner);
        MapRenderer.calCornerCoords(mapMode, botCorner);
        double sizeX = (botCorner.x - topCorner.x) * (double)filling;
        double sizeY = (botCorner.y - topCorner.y) * (double)filling;
        double offsetX = (botCorner.x - topCorner.x - sizeX) / 2.0;
        double offsetY = (botCorner.y - topCorner.y - sizeY) / 2.0;
        if (overlay.hasBorder()) {
            Render.setColour(overlay.getBorderColor());
            Render.drawRectBorder(topCorner.x + 1.0, topCorner.y + 1.0, botCorner.x - topCorner.x - 1.0, botCorner.y - topCorner.y - 1.0, overlay.getBorderWidth());
        }
        Render.setColour(overlay.getColor());
        Render.drawRect(topCorner.x + offsetX + 1.0, topCorner.y + offsetY + 1.0, sizeX - 1.0, sizeY - 1.0);
    }

    private static void calCornerCoords(MapMode mapMode, Point2D.Double corner) {
        corner.x = Math.max((double)mapMode.getX(), corner.x);
        corner.x = Math.min((double)(mapMode.getX() + mapMode.getW()), corner.x);
        corner.y = Math.max((double)mapMode.getY(), corner.y);
        corner.y = Math.min((double)(mapMode.getY() + mapMode.getH()), corner.y);
    }

    public MapMode getMapMode() {
        return this.mapMode;
    }

    public MapView getMapView() {
        return this.mapView;
    }
}

