/*
 * Decompiled with CFR 0.152.
 */
package pixelradar.map;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.client.gui.GuiResources;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import java.awt.geom.Point2D;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import pixelradar.entities.EntityType;
import pixelradar.map.MapRenderer;
import pixelradar.map.MapView;
import pixelradar.map.mapmode.MapMode;
import pixelradar.util.Render;

public class PKMarker {
    public Point2D.Double screenPos = new Point2D.Double(0.0, 0.0);
    public String name;
    public String desc;
    ResourceLocation sprite;
    public double r;
    public double x;
    public double y;
    public double z;
    public int coordX;
    public int coordY;
    public int coordZ;
    public int dimension;
    public EntityType type;
    private static final double BORDER_WIDTH = 0.4;
    private static final int BORDER_COLOR = -16777216;
    public float yaw;

    public PKMarker(EntityType type, Entity entity, String name, String desc, double radius, MapRenderer mp, int dimension) {
        this.name = name;
        if (entity instanceof EntityPixelmon) {
            EntityPixelmon entityPixelmon = (EntityPixelmon)entity;
            Pokemon pokemon = entityPixelmon.getPokemonData();
            if (pokemon.getForm() > 0 && entityPixelmon.getBaseStats() != null) {
                this.name = pokemon.getFormEnum().getLocalizedName() + " " + this.name;
            }
            if (pokemon.isShiny()) {
                this.name = this.name + " (" + I18n.func_135052_a((String)"mw.finder.msg.shiny", (Object[])new Object[0]) + ")";
            }
            this.sprite = GuiResources.getPokemonSprite((Pokemon)pokemon);
        }
        this.yaw = entity.field_70177_z;
        this.dimension = Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension();
        this.type = type;
        this.r = radius;
        this.desc = desc;
        this.x = entity.field_70165_t;
        this.y = entity.field_70163_u;
        this.z = entity.field_70161_v;
        this.coordX = (int)this.x;
        this.coordY = (int)this.y;
        this.coordZ = (int)this.z;
        double scale = mp.getMapView().getDimensionScaling(Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension());
        Point2D.Double p = mp.getMapMode().getClampedScreenXY(mp.getMapView(), this.x * scale, this.z * scale);
        this.screenPos.setLocation(p.x + (double)mp.getMapMode().getXTranslation(), p.y + (double)mp.getMapMode().getYTranslation());
    }

    public PKMarker(EntityType type, TileEntity entity, String name, String desc, double radius, MapRenderer mp, int dimension) {
        this.yaw = 0.0f;
        this.dimension = Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension();
        this.type = type;
        this.r = radius;
        this.name = name;
        this.desc = desc;
        this.x = entity.func_174877_v().func_177958_n();
        this.y = entity.func_174877_v().func_177956_o();
        this.z = entity.func_174877_v().func_177952_p();
        this.coordX = (int)this.x;
        this.coordY = (int)this.y;
        this.coordZ = (int)this.z;
        double scale = mp.getMapView().getDimensionScaling(Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension());
        Point2D.Double p = mp.getMapMode().getClampedScreenXY(mp.getMapView(), this.x * scale, this.z * scale);
        this.screenPos.setLocation(p.x + (double)mp.getMapMode().getXTranslation(), p.y + (double)mp.getMapMode().getYTranslation());
    }

    private boolean judgeTile(MapMode mapMode, MapView mapView) {
        if (this.type == EntityType.LOOT || this.type == EntityType.SHRINE || this.type == EntityType.GADGET || this.type == EntityType.DEN || this.type == EntityType.WORMHOLE) {
            this.drawTile(mapMode, mapView);
            return true;
        }
        return false;
    }

    public void draw(MapMode mapMode, MapView mapView) {
        if (this.judgeTile(mapMode, mapView)) {
            return;
        }
        double scale = mapView.getDimensionScaling(mapView.getDimension());
        Point2D.Double p = mapMode.getClampedScreenXY(mapView, this.x * scale, this.z * scale);
        Render.setColour(this.type.getColor().getRGB());
        Render.drawCircle(p.x, p.y, this.type.getRadius());
        Render.setColour(-16777216);
        Render.drawCircleBorder(p.x, p.y, this.type.getRadius(), 0.4);
    }

    public void drawPKTexture(MapMode mapMode, MapView mapView, float mapRotationDegrees) {
        if (this.judgeTile(mapMode, mapView)) {
            return;
        }
        double scale = mapView.getDimensionScaling(mapView.getDimension());
        Point2D.Double p = mapMode.getClampedScreenXY(mapView, this.x * scale, this.z * scale);
        double markerSize = this.type.getTextureDimension();
        Render.setColour(-1);
        if (this.sprite != null) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.sprite);
        }
        Render.drawTexturedRect(p.x - markerSize / 2.0, p.y - markerSize / 2.0, markerSize, markerSize);
    }

    public void drawTile(MapMode mapMode, MapView mapView) {
        double scale = mapView.getDimensionScaling(mapView.getDimension());
        Point2D.Double p = mapMode.getClampedScreenXY(mapView, this.x * scale, this.z * scale);
        Render.setColour(this.type.getColor().getRGB());
        Render.drawRect(p.x, p.y, this.type.getRadius(), this.type.getRadius());
        Render.setColour(-16777216);
        Render.drawRectBorder(p.x, p.y, this.type.getRadius(), this.type.getRadius(), 0.8);
    }

    public double getDistanceToMarker(Entity entityIn) {
        if (entityIn == null) {
            return 0.0;
        }
        double d0 = this.x - entityIn.field_70165_t;
        double d1 = this.y - entityIn.field_70163_u;
        double d2 = this.z - entityIn.field_70161_v;
        return MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
    }
}

