/*
 * Decompiled with CFR 0.152.
 */
package goblinbob.mobends.core.client.gui.elements;

import goblinbob.mobends.core.util.Draw;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiToggleButton {
    protected static final ResourceLocation BUTTON_TEXTURES = new ResourceLocation("textures/gui/widgets.png");
    private static final int FLIPPER_WIDTH = 30;
    private static final int HEIGHT = 20;
    protected int x = 0;
    protected int y = 0;
    protected boolean hovered = false;
    protected boolean enabled = true;
    protected boolean toggleState = false;
    protected final String title;
    protected final int labelWidth;

    public GuiToggleButton(String title, int minLabelWidth) {
        this.title = title;
        int titleWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(title) + 20;
        this.labelWidth = titleWidth > minLabelWidth ? titleWidth : minLabelWidth;
    }

    public void initGui(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void update(int mouseX, int mouseY) {
        this.hovered = mouseX >= this.x && mouseX <= this.x + this.labelWidth + 30 && mouseY >= this.y && mouseY <= this.y + 20;
    }

    public void draw() {
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer fontRenderer = mc.field_71466_p;
        mc.func_110434_K().func_110577_a(BUTTON_TEXTURES);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glBlendFunc((int)770, (int)771);
        int k = this.hovered ? 1 : 0;
        GL11.glPushMatrix();
        Draw.texturedModalRect(this.x, this.y, 0, 66 + k * 20, (this.labelWidth + 30) / 2, 20);
        Draw.texturedModalRect(this.x + this.labelWidth / 2, this.y, 200 - (this.labelWidth + 30) / 2, 66 + k * 20, (this.labelWidth + 30) / 2, 20);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        if (this.toggleState) {
            GL11.glColor3f((float)0.3f, (float)1.0f, (float)0.5f);
        } else {
            GL11.glColor3f((float)1.0f, (float)0.3f, (float)0.3f);
        }
        Draw.texturedModalRect(this.x + this.labelWidth, this.y, 0, 66 + k * 20, 15, 20);
        Draw.texturedModalRect(this.x + this.labelWidth + 15, this.y, 185, 66 + k * 20, 15, 20);
        GL11.glPopMatrix();
        int l = 0xE0E0E0;
        if (!this.enabled) {
            l = 0xA0A0A0;
        } else if (this.hovered) {
            l = 0xFFFFA0;
        }
        String stateText = this.toggleState ? "ON" : "OFF";
        int textWidth = fontRenderer.func_78256_a(stateText);
        fontRenderer.func_78276_b(stateText, this.x + this.labelWidth - textWidth / 2 + 15, this.y + 6, l);
        fontRenderer.func_78276_b(this.title, this.x + 10, this.y + 6, l);
        GL11.glBlendFunc((int)770, (int)771);
    }

    public void setToggleState(boolean state) {
        this.toggleState = state;
    }

    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.hovered && button == 0) {
            this.toggleState = !this.toggleState;
            return true;
        }
        return false;
    }

    public boolean getToggleState() {
        return this.toggleState;
    }
}

