/*
 * Decompiled with CFR 0.152.
 */
package goblinbob.mobends.core.client.gui.popup;

import goblinbob.mobends.core.client.gui.GuiBendsMenu;
import goblinbob.mobends.core.client.gui.elements.GuiCustomButton;
import goblinbob.mobends.core.util.Draw;
import goblinbob.mobends.core.util.GUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;

public class GuiPopUp {
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    private String[] title;
    protected FontRenderer fontRenderer;
    private List<Button> buttons;

    public GuiPopUp(String title, ButtonProps[] buttonProps) {
        this(title, 120, 60, buttonProps);
    }

    public GuiPopUp(String title, int width, int height, ButtonProps[] buttonProps) {
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.width = width;
        this.height = height;
        this.title = GUtil.wrapText(this.fontRenderer, title, width - 20);
        this.buttons = new ArrayList<Button>();
        for (ButtonProps buttonProp : buttonProps) {
            this.buttons.add(new Button(this.fontRenderer, buttonProp));
        }
    }

    public void initGui(int x, int y) {
        this.x = x - this.width / 2;
        this.y = y - this.height / 2;
        int offset = this.x + this.width - 5;
        for (Button button : this.buttons) {
            button.buttonUI.setPosition(offset - button.buttonUI.field_146120_f, this.y + this.height - 25);
            offset -= button.buttonUI.field_146120_f + 5;
        }
    }

    public void update(int mouseX, int mouseY) {
    }

    public void display(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiBendsMenu.ICONS_TEXTURE);
        Draw.texturedModalRect(this.x - 4, this.y - 4, 60, 64, 4, 4);
        Draw.texturedModalRect(this.x, this.y - 4, this.width, 4, 64, 64, 1, 4);
        Draw.texturedModalRect(this.x + this.width, this.y - 4, 65, 64, 4, 4);
        Draw.texturedModalRect(this.x + this.width, this.y, 4, this.height, 65, 68, 4, 1);
        Draw.texturedModalRect(this.x + this.width, this.y + this.height, 65, 69, 4, 4);
        Draw.texturedModalRect(this.x, this.y + this.height, this.width, 4, 64, 69, 1, 4);
        Draw.texturedModalRect(this.x - 4, this.y + this.height, 60, 69, 4, 4);
        Draw.texturedModalRect(this.x - 4, this.y, 4, this.height, 60, 68, 4, 1);
        Draw.texturedModalRect(this.x, this.y, this.width, this.height, 64, 68, 1, 1);
        int yOffset = 6;
        for (String line : this.title) {
            this.fontRenderer.func_175063_a(line, (float)(this.x + (this.width - this.fontRenderer.func_78256_a(line)) / 2), (float)(this.y + yOffset), 0xFFFFFF);
            yOffset += 9;
        }
        for (Button button : this.buttons) {
            button.buttonUI.drawButton(mouseX, mouseY, partialTicks);
        }
    }

    public void mouseClicked(int mouseX, int mouseY, int state) {
        for (Button button : this.buttons) {
            if (!button.buttonUI.func_146116_c(Minecraft.func_71410_x(), mouseX, mouseY)) continue;
            button.props.action.performAction();
            return;
        }
    }

    public static class Button {
        public ButtonProps props;
        public GuiCustomButton buttonUI;

        public Button(FontRenderer fontRenderer, ButtonProps props) {
            this.props = props;
            int labelWidth = fontRenderer.func_78256_a(props.label);
            this.buttonUI = new GuiCustomButton(Math.max(labelWidth + 10, 50), 20, props.label);
        }
    }

    public static class ButtonProps {
        private String label;
        private ButtonAction action;

        public ButtonProps(String label, ButtonAction action) {
            this.label = label;
            this.action = action;
        }
    }

    @FunctionalInterface
    public static interface ButtonAction {
        public void performAction();
    }
}

