/*
 * Decompiled with CFR 0.152.
 */
package goblinbob.mobends.standard.animation.controller;

import goblinbob.mobends.core.animation.controller.IAnimationController;
import goblinbob.mobends.core.animation.keyframe.AnimationLoader;
import goblinbob.mobends.core.client.event.DataUpdateHandler;
import goblinbob.mobends.core.kumo.state.KumoAnimatorState;
import goblinbob.mobends.core.kumo.state.template.AnimatorTemplate;
import goblinbob.mobends.core.kumo.state.template.MalformedKumoTemplateException;
import goblinbob.mobends.core.util.GsonResources;
import goblinbob.mobends.standard.data.WolfData;
import java.io.IOException;
import java.util.Collection;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class WolfController
implements IAnimationController<WolfData> {
    protected static final ResourceLocation WOLF_ANIMATOR = new ResourceLocation("mobends", "animators/wolf.json");
    protected AnimatorTemplate animatorTemplate;
    protected KumoAnimatorState<WolfData> kumoAnimatorState;

    public WolfController() {
        try {
            this.animatorTemplate = GsonResources.get(WOLF_ANIMATOR, AnimatorTemplate.class);
            this.kumoAnimatorState = new KumoAnimatorState(this.animatorTemplate, key -> {
                try {
                    return AnimationLoader.loadFromPath(key);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            });
        }
        catch (MalformedKumoTemplateException | IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Collection<String> perform(WolfData data) {
        EntityWolf wolf = (EntityWolf)data.getEntity();
        float ticks = (float)wolf.field_70173_aa + DataUpdateHandler.partialTicks;
        try {
            this.kumoAnimatorState.update(data, DataUpdateHandler.ticksPerFrame);
        }
        catch (MalformedKumoTemplateException e) {
            e.printStackTrace();
        }
        if (wolf.func_70631_g_()) {
            data.head.offsetScale = 0.5f;
            data.head.globalOffset.set(0.0f, 5.0f, -2.0f);
        } else {
            data.head.offsetScale = 1.0f;
            data.head.globalOffset.set(0.0f, 0.0f, 0.0f);
        }
        data.head.position.set(0.0f, -0.5f, -13.0f);
        data.head.rotation.localRotateY(((Float)data.headYaw.get()).floatValue()).finish();
        data.head.rotation.localRotateX(((Float)data.headPitch.get()).floatValue()).finish();
        data.head.rotation.localRotateZ((wolf.func_70917_k(DataUpdateHandler.partialTicks) + wolf.func_70923_f(DataUpdateHandler.partialTicks, 0.0f)) * 57.295776f).finish();
        data.mane.rotation.localRotateZ(wolf.func_70923_f(DataUpdateHandler.partialTicks, -0.08f) * 57.295776f).finish();
        data.tail.rotation.localRotateZ(wolf.func_70923_f(DataUpdateHandler.partialTicks, -0.2f) * 57.295776f).finish();
        data.tail.rotation.localRotateZ(wolf.func_70917_k(DataUpdateHandler.partialTicks) * MathHelper.func_76126_a((float)ticks) * 20.0f).finish();
        data.tail.rotation.localRotateX(wolf.func_70920_v() * 57.295776f - 90.0f).finish();
        data.head.offset.set(0.0f, 0.0f, 0.0f);
        return null;
    }
}

