/*
 * Decompiled with CFR 0.152.
 */
package goblinbob.mobends.standard.main;

import goblinbob.mobends.core.util.ErrorReporter;
import goblinbob.mobends.core.util.WildcardPattern;
import goblinbob.mobends.standard.AttackActionType;
import goblinbob.mobends.standard.UseActionType;
import goblinbob.mobends.standard.main.MalformedConfigException;
import goblinbob.mobends.standard.main.MoBends;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="mobends")
public class ModConfig {
    @Config.LangKey(value="mobends.config.show_arrow_trails")
    public static boolean showArrowTrails = true;
    @Config.LangKey(value="mobends.config.show_sword_trails")
    public static boolean showSwordTrail = true;
    @Config.LangKey(value="mobends.config.perform_spin_attack")
    public static boolean performSpinAttack = true;
    @Config.LangKey(value="mobends.config.item_use_classifications")
    public static String[] itemUseClassifications = new String[0];
    @Config.LangKey(value="mobends.config.item_attack_classifications")
    public static String[] itemAttackClassifications = new String[0];
    @Config.LangKey(value="mobends.config.keep_armor_as_vanilla")
    public static String[] keepArmorAsVanilla = new String[0];
    @Config.LangKey(value="mobends.config.keep_entity_as_vanilla")
    public static String[] keepEntityAsVanilla = new String[0];
    @Config.Ignore
    private static Map<Item, Boolean> keepArmorAsVanillaCache;
    @Config.Ignore
    private static Map<Entity, Boolean> keepEntityAsVanillaCache;
    @Config.Ignore
    private static Map<Item, UseActionType> itemUseClassificationCache;
    @Config.Ignore
    private static Map<Item, AttackActionType> itemAttackClassificationCache;
    @Config.Ignore
    private static LinkedList<ItemClassificationEntry<UseActionType>> itemUseClassificationEntries;
    @Config.Ignore
    private static LinkedList<ItemClassificationEntry<AttackActionType>> itemAttackClassificationEntries;
    @Config.Ignore
    private static List<Map<?, ?>> caches;

    private static <T> LinkedList<ItemClassificationEntry<T>> getOrMakeEntries(LinkedList<ItemClassificationEntry<T>> entries, String[] rawEntries, Function<String, T> parseFunction) {
        if (rawEntries.length == 0) {
            return entries;
        }
        if (entries.size() == 0) {
            for (String rawEntry : rawEntries) {
                try {
                    entries.addFirst(ItemClassificationEntry.parse(rawEntry, parseFunction));
                }
                catch (MalformedConfigException e) {
                    ErrorReporter.showErrorToPlayer(String.format("Invalid configuration! %s", e.getMessage()));
                }
            }
        }
        return entries;
    }

    private static boolean doesLocationMatchPattern(ResourceLocation resourceLocation, String pattern) {
        ResourceLocation patternLocation = new ResourceLocation(pattern);
        if (resourceLocation.equals((Object)patternLocation)) {
            return true;
        }
        WildcardPattern domainPattern = new WildcardPattern(patternLocation.func_110624_b());
        WildcardPattern pathPattern = new WildcardPattern(patternLocation.func_110623_a());
        return domainPattern.matches(resourceLocation.func_110624_b()) && pathPattern.matches(resourceLocation.func_110623_a());
    }

    private static boolean checkForPatterns(ResourceLocation resourceLocation, String[] patterns) {
        String resourceDomain = resourceLocation.func_110624_b();
        String resourcePath = resourceLocation.func_110623_a();
        for (String pattern : patterns) {
            ResourceLocation patternLocation = new ResourceLocation(pattern);
            if (resourceLocation.equals((Object)patternLocation)) {
                return true;
            }
            WildcardPattern domainPattern = new WildcardPattern(patternLocation.func_110624_b());
            WildcardPattern pathPattern = new WildcardPattern(patternLocation.func_110623_a());
            if (!domainPattern.matches(resourceDomain) || !pathPattern.matches(resourcePath)) continue;
            return true;
        }
        return false;
    }

    public static UseActionType getItemUseAction(Item item) {
        return itemUseClassificationCache.computeIfAbsent(item, i -> {
            ResourceLocation location = item.getRegistryName();
            if (location != null) {
                LinkedList<ItemClassificationEntry<UseActionType>> entries = ModConfig.getOrMakeEntries(itemUseClassificationEntries, itemUseClassifications, UseActionType::valueOf);
                for (ItemClassificationEntry itemClassificationEntry : entries) {
                    if (!ModConfig.doesLocationMatchPattern(location, itemClassificationEntry.pattern)) continue;
                    return (UseActionType)((Object)((Object)itemClassificationEntry.classification));
                }
            }
            return null;
        });
    }

    public static AttackActionType getItemAttackAction(Item item) {
        return itemAttackClassificationCache.computeIfAbsent(item, i -> {
            ResourceLocation location = item.getRegistryName();
            if (location != null) {
                LinkedList<ItemClassificationEntry<AttackActionType>> entries = ModConfig.getOrMakeEntries(itemAttackClassificationEntries, itemAttackClassifications, AttackActionType::valueOf);
                for (ItemClassificationEntry itemClassificationEntry : entries) {
                    if (!ModConfig.doesLocationMatchPattern(location, itemClassificationEntry.pattern)) continue;
                    return (AttackActionType)((Object)((Object)itemClassificationEntry.classification));
                }
            }
            return null;
        });
    }

    public static boolean shouldKeepArmorAsVanilla(Item item) {
        return keepArmorAsVanillaCache.computeIfAbsent(item, i -> ModConfig.checkForPatterns(i.getRegistryName(), keepArmorAsVanilla));
    }

    public static boolean shouldKeepEntityAsVanilla(Entity entity) {
        return keepEntityAsVanillaCache.computeIfAbsent(entity, e -> {
            ResourceLocation location = EntityList.func_191301_a((Entity)entity);
            return location != null && ModConfig.checkForPatterns(location, keepEntityAsVanilla);
        });
    }

    static {
        itemUseClassificationEntries = new LinkedList();
        itemAttackClassificationEntries = new LinkedList();
        Map[] mapArray = new Map[4];
        keepArmorAsVanillaCache = new HashMap<Item, Boolean>();
        mapArray[0] = keepArmorAsVanillaCache;
        keepEntityAsVanillaCache = new HashMap<Entity, Boolean>();
        mapArray[1] = keepEntityAsVanillaCache;
        itemUseClassificationCache = new HashMap<Item, UseActionType>();
        mapArray[2] = itemUseClassificationCache;
        itemAttackClassificationCache = new HashMap<Item, AttackActionType>();
        mapArray[3] = itemAttackClassificationCache;
        caches = Arrays.asList(mapArray);
    }

    private static class ItemClassificationEntry<T> {
        public final String pattern;
        public final T classification;

        public ItemClassificationEntry(String pattern, T classification) {
            this.pattern = pattern;
            this.classification = classification;
        }

        public static <T> ItemClassificationEntry<T> parse(String encoded, Function<String, T> parsingFunction) {
            int indexOfEquals = encoded.indexOf("=");
            if (indexOfEquals == -1) {
                throw new IllegalArgumentException(String.format("No equals sign found in the item classification entry: %s", encoded));
            }
            String pattern = encoded.substring(0, indexOfEquals);
            String encodedActionType = encoded.substring(indexOfEquals + 1).toUpperCase();
            try {
                T actionType = parsingFunction.apply(encodedActionType);
                return new ItemClassificationEntry<T>(pattern, actionType);
            }
            catch (IllegalArgumentException e) {
                throw new MalformedConfigException(String.format("Unknown action type: %s", encodedActionType), e);
            }
        }
    }

    @Mod.EventBusSubscriber(modid="mobends")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("mobends")) {
                ConfigManager.sync((String)"mobends", (Config.Type)Config.Type.INSTANCE);
                for (Map cache : caches) {
                    cache.clear();
                }
                itemUseClassificationEntries.clear();
                ModConfig.getOrMakeEntries(itemUseClassificationEntries, itemUseClassifications, UseActionType::valueOf);
                itemAttackClassificationEntries.clear();
                ModConfig.getOrMakeEntries(itemAttackClassificationEntries, itemAttackClassifications, AttackActionType::valueOf);
                MoBends.refreshSystems();
            }
        }
    }
}

