/*
 * Decompiled with CFR 0.152.
 */
package me.zhenxin.zmusic.player;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import me.zhenxin.zmusic.ZMusic;
import me.zhenxin.zmusic.player.decoder.BuffPack;
import me.zhenxin.zmusic.player.decoder.IDecoder;
import me.zhenxin.zmusic.player.decoder.flac.FlacDecoder;
import me.zhenxin.zmusic.player.decoder.mp3.Mp3Decoder;
import me.zhenxin.zmusic.player.decoder.ogg.OggDecoder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL10;

public class MusicPlayer
extends InputStream {
    private static final Logger log = LogManager.getLogger(MusicPlayer.class);
    private HttpURLConnection connection;
    private String url;
    private InputStream content;
    private boolean isClose = false;
    private boolean reload = false;
    private IDecoder decoder;
    private final Queue<String> urls = new ConcurrentLinkedQueue<String>();
    private int time = 0;
    private long local = 0L;
    private final Semaphore semaphore = new Semaphore(0);
    private final Semaphore semaphore1 = new Semaphore(0);
    private final Queue<ByteBuffer> queue = new ConcurrentLinkedQueue<ByteBuffer>();
    private boolean isPlay = false;
    private boolean wait = false;
    private int index;
    private int frequency;
    private int channels;

    public MusicPlayer() {
        try {
            new Thread(this::run, "zmusic-player-thread").start();
            ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
            service.scheduleAtFixedRate(this::run1, 0L, 10L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void run1() {
        if (this.isPlay) {
            this.time += 10;
        }
    }

    public boolean isPlay() {
        return this.isPlay;
    }

    public static URL get(URL url) {
        if (url.toString().contains("https://music.163.com/song/media/outer/url?id=") || url.toString().contains("http://music.163.com/song/media/outer/url?id=")) {
            try {
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(4000);
                connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36 Edg/84.0.522.52");
                connection.setRequestProperty("Host", "music.163.com");
                connection.connect();
                if (connection.getResponseCode() == 302) {
                    return new URL(connection.getHeaderField("Location"));
                }
                return connection.getURL();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return url;
    }

    public void set(String time) {
        try {
            int time1 = Integer.parseInt(time);
            this.set(time1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void set(int time) {
        this.closePlayer();
        this.time = time;
        this.urls.add(this.url);
        this.semaphore.release();
    }

    public void connect() throws IOException {
        this.streamClose();
        URL urlObject = new URL(this.url);
        this.connection = (HttpURLConnection)urlObject.openConnection();
        this.connection.setRequestProperty("Range", "bytes=" + this.local + "-");
        this.connection.setRequestProperty("User-Agent", "ZMusic Mod/" + ZMusic.getVersion());
        this.connection.connect();
        int responseCode = this.connection.getResponseCode();
        if (responseCode < 200 || responseCode >= 300) {
            throw new IOException("Failed to connect, response code: " + responseCode);
        }
        this.content = new BufferedInputStream(this.connection.getInputStream());
    }

    private void run() {
        while (true) {
            try {
                while (true) {
                    int m_numqueued;
                    block18: {
                        this.semaphore.acquire();
                        this.url = this.urls.poll();
                        if (this.url == null || this.url.isEmpty()) continue;
                        this.urls.clear();
                        URL nowURL = new URL(this.url);
                        nowURL = MusicPlayer.get(nowURL);
                        if (nowURL == null) continue;
                        try {
                            this.local = 0L;
                            this.connect();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            log.warn("Failed to get the music!");
                            continue;
                        }
                        this.decoder = new FlacDecoder(this);
                        if (!this.decoder.set()) {
                            this.local = 0L;
                            this.connect();
                            this.decoder = new OggDecoder(this);
                            if (!this.decoder.set()) {
                                this.local = 0L;
                                this.connect();
                                this.decoder = new Mp3Decoder(this);
                                if (!this.decoder.set()) {
                                    log.warn("An unsupported file format!");
                                    continue;
                                }
                            }
                        }
                        this.isPlay = true;
                        this.index = AL10.alGenSources();
                        for (m_numqueued = AL10.alGetSourcei((int)this.index, (int)4117); m_numqueued > 0; --m_numqueued) {
                            int temp = AL10.alSourceUnqueueBuffers((int)this.index);
                            AL10.alDeleteBuffers((int)temp);
                        }
                        this.frequency = this.decoder.getOutputFrequency();
                        this.channels = this.decoder.getOutputChannels();
                        if (this.channels != 1 && this.channels != 2) continue;
                        if (this.time != 0) {
                            this.decoder.set(this.time);
                        }
                        this.queue.clear();
                        this.reload = false;
                        this.isClose = false;
                        try {
                            BuffPack output;
                            while (!this.isClose && (output = this.decoder.decodeFrame()) != null) {
                                ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)output.len).put(output.buff, 0, output.len);
                                ((Buffer)byteBuffer).flip();
                                this.queue.add(byteBuffer);
                            }
                        }
                        catch (Exception e) {
                            if (this.isClose) break block18;
                            e.printStackTrace();
                        }
                    }
                    this.streamClose();
                    this.decodeClose();
                    while (!this.isClose && AL10.alGetSourcei((int)this.index, (int)4112) == 4114) {
                        AL10.alSourcef((int)this.index, (int)4106, (float)ZMusic.getSoundManager().volume());
                        Thread.sleep(100L);
                    }
                    if (!this.reload) {
                        this.wait = true;
                        if (this.semaphore1.tryAcquire(500L, TimeUnit.MILLISECONDS) && this.reload) {
                            this.urls.add(this.url);
                            this.semaphore.release();
                            continue;
                        }
                        this.isPlay = false;
                        AL10.alSourceStop((int)this.index);
                        for (m_numqueued = AL10.alGetSourcei((int)this.index, (int)4117); m_numqueued > 0; --m_numqueued) {
                            int temp = AL10.alSourceUnqueueBuffers((int)this.index);
                            AL10.alDeleteBuffers((int)temp);
                        }
                        AL10.alDeleteSources((int)this.index);
                        continue;
                    }
                    this.urls.add(this.url);
                    this.semaphore.release();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void tick() {
        if (this.wait) {
            this.wait = false;
            this.semaphore1.release();
        }
        if (this.isClose) {
            this.queue.clear();
            return;
        }
        while (!this.queue.isEmpty()) {
            ByteBuffer byteBuffer = this.queue.poll();
            if (byteBuffer == null) continue;
            if (this.isClose) {
                return;
            }
            IntBuffer intBuffer = BufferUtils.createIntBuffer((int)1);
            AL10.alGenBuffers((IntBuffer)intBuffer);
            AL10.alBufferData((int)intBuffer.get(0), (int)(this.channels == 1 ? 4353 : 4355), (ByteBuffer)byteBuffer, (int)this.frequency);
            AL10.alSourcef((int)this.index, (int)4106, (float)ZMusic.getSoundManager().volume());
            AL10.alSourceQueueBuffers((int)this.index, (IntBuffer)intBuffer);
            if (AL10.alGetSourcei((int)this.index, (int)4112) == 4114) continue;
            AL10.alSourcePlay((int)this.index);
        }
    }

    public void closePlayer() {
        this.isClose = true;
    }

    public void setMusic(String url) {
        this.time = 0;
        this.closePlayer();
        this.urls.add(url);
        this.semaphore.release();
    }

    private void streamClose() throws IOException {
        if (this.content != null) {
            this.content.close();
            this.content = null;
        }
        if (this.connection != null) {
            this.connection.disconnect();
            this.connection = null;
        }
    }

    private void decodeClose() throws Exception {
        if (this.decoder != null) {
            this.decoder.close();
            this.decoder = null;
        }
    }

    @Override
    public int read() throws IOException {
        return this.content.read();
    }

    @Override
    public int read(byte[] buf) throws IOException {
        return this.content.read(buf);
    }

    @Override
    public synchronized int read(byte[] buf, int off, int len) throws IOException {
        try {
            int temp = this.content.read(buf, off, len);
            this.local += (long)temp;
            return temp;
        }
        catch (IOException ex) {
            this.connect();
            return this.read(buf, off, len);
        }
    }

    @Override
    public synchronized int available() throws IOException {
        return this.content.available();
    }

    @Override
    public void close() throws IOException {
        this.streamClose();
    }

    public void setLocal(long local) throws IOException {
        this.streamClose();
        this.local = local;
        this.connect();
    }

    public void setReload() {
        if (this.isPlay) {
            this.reload = true;
            this.isClose = true;
        }
    }
}

