/*
 * Decompiled with CFR 0.152.
 */
package me.zhenxin.zmusic.player.decoder.flac;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import me.zhenxin.zmusic.player.decoder.flac.DataFormatException;
import me.zhenxin.zmusic.player.decoder.flac.FlacLowLevelInput;
import me.zhenxin.zmusic.player.decoder.flac.FrameInfo;

public final class FrameDecoder {
    public FlacLowLevelInput in;
    public int expectedSampleDepth;
    private long[] temp0;
    private long[] temp1;
    private int currentBlockSize;
    private static final int[][] FIXED_PREDICTION_COEFFICIENTS = new int[][]{new int[0], {1}, {2, -1}, {3, -3, 1}, {4, -6, 4, -1}};

    public FrameDecoder(FlacLowLevelInput in, int expectDepth) {
        this.in = in;
        this.expectedSampleDepth = expectDepth;
        this.temp0 = new long[65536];
        this.temp1 = new long[65536];
        this.currentBlockSize = -1;
    }

    public FrameInfo readFrame(int[][] outSamples, int outOffset) throws IOException {
        Objects.requireNonNull(this.in);
        if (this.currentBlockSize != -1) {
            throw new IllegalStateException("Concurrent call");
        }
        long startByte = this.in.getPosition();
        FrameInfo meta = FrameInfo.readFrame(this.in);
        if (meta == null) {
            return null;
        }
        if (meta.sampleDepth != -1 && meta.sampleDepth != this.expectedSampleDepth) {
            throw new DataFormatException("Sample depth mismatch");
        }
        this.currentBlockSize = meta.blockSize;
        Objects.requireNonNull(outSamples);
        if (outOffset < 0 || outOffset > outSamples[0].length) {
            throw new IndexOutOfBoundsException();
        }
        if (outSamples.length < meta.numChannels) {
            throw new IllegalArgumentException("Output array too small for number of channels");
        }
        if (outOffset > outSamples[0].length - this.currentBlockSize) {
            throw new IndexOutOfBoundsException();
        }
        this.decodeSubframes(this.expectedSampleDepth, meta.channelAssignment, outSamples, outOffset);
        if (this.in.readUint((8 - this.in.getBitPosition()) % 8) != 0) {
            throw new DataFormatException("Invalid padding bits");
        }
        int computedCrc16 = this.in.getCrc16();
        if (this.in.readUint(16) != computedCrc16) {
            throw new DataFormatException("CRC-16 mismatch");
        }
        long frameSize = this.in.getPosition() - startByte;
        if (frameSize < 10L) {
            throw new AssertionError();
        }
        if ((long)((int)frameSize) != frameSize) {
            throw new DataFormatException("Frame size too large");
        }
        meta.frameSize = (int)frameSize;
        this.currentBlockSize = -1;
        return meta;
    }

    private void decodeSubframes(int sampleDepth, int chanAsgn, int[][] outSamples, int outOffset) throws IOException {
        if (sampleDepth < 1 || sampleDepth > 32) {
            throw new IllegalArgumentException();
        }
        if (chanAsgn >>> 4 != 0) {
            throw new IllegalArgumentException();
        }
        if (0 <= chanAsgn && chanAsgn <= 7) {
            int numChannels = chanAsgn + 1;
            for (int ch = 0; ch < numChannels; ++ch) {
                this.decodeSubframe(sampleDepth, this.temp0);
                int[] outChan = outSamples[ch];
                for (int i = 0; i < this.currentBlockSize; ++i) {
                    outChan[outOffset + i] = FrameDecoder.checkBitDepth(this.temp0[i], sampleDepth);
                }
            }
        } else if (8 <= chanAsgn && chanAsgn <= 10) {
            int i;
            this.decodeSubframe(sampleDepth + (chanAsgn == 9 ? 1 : 0), this.temp0);
            this.decodeSubframe(sampleDepth + (chanAsgn == 9 ? 0 : 1), this.temp1);
            if (chanAsgn == 8) {
                for (i = 0; i < this.currentBlockSize; ++i) {
                    this.temp1[i] = this.temp0[i] - this.temp1[i];
                }
            } else if (chanAsgn == 9) {
                for (i = 0; i < this.currentBlockSize; ++i) {
                    int n = i;
                    this.temp0[n] = this.temp0[n] + this.temp1[i];
                }
            } else if (chanAsgn == 10) {
                for (i = 0; i < this.currentBlockSize; ++i) {
                    long right;
                    long side = this.temp1[i];
                    this.temp1[i] = right = this.temp0[i] - (side >> 1);
                    this.temp0[i] = right + side;
                }
            } else {
                throw new AssertionError();
            }
            int[] outLeft = outSamples[0];
            int[] outRight = outSamples[1];
            for (int i2 = 0; i2 < this.currentBlockSize; ++i2) {
                outLeft[outOffset + i2] = FrameDecoder.checkBitDepth(this.temp0[i2], sampleDepth);
                outRight[outOffset + i2] = FrameDecoder.checkBitDepth(this.temp1[i2], sampleDepth);
            }
        } else {
            throw new DataFormatException("Reserved channel assignment");
        }
    }

    private static int checkBitDepth(long val, int depth) {
        assert (1 <= depth && depth <= 32);
        if (val >> depth - 1 == val >> depth) {
            return (int)val;
        }
        throw new IllegalArgumentException(val + " is not a signed " + depth + "-bit value");
    }

    private void decodeSubframe(int sampleDepth, long[] result) throws IOException {
        int i;
        Objects.requireNonNull(result);
        if (sampleDepth < 1 || sampleDepth > 33) {
            throw new IllegalArgumentException();
        }
        if (result.length < this.currentBlockSize) {
            throw new IllegalArgumentException();
        }
        if (this.in.readUint(1) != 0) {
            throw new DataFormatException("Invalid padding bit");
        }
        int type = this.in.readUint(6);
        int shift = this.in.readUint(1);
        if (shift == 1) {
            while (this.in.readUint(1) == 0) {
                if (shift >= sampleDepth) {
                    throw new DataFormatException("Waste-bits-per-sample exceeds sample depth");
                }
                ++shift;
            }
        }
        if (0 > shift || shift > sampleDepth) {
            throw new AssertionError();
        }
        sampleDepth -= shift;
        if (type == 0) {
            Arrays.fill(result, 0, this.currentBlockSize, (long)this.in.readSignedInt(sampleDepth));
        } else if (type == 1) {
            for (i = 0; i < this.currentBlockSize; ++i) {
                result[i] = this.in.readSignedInt(sampleDepth);
            }
        } else if (8 <= type && type <= 12) {
            this.decodeFixedPredictionSubframe(type - 8, sampleDepth, result);
        } else if (32 <= type && type <= 63) {
            this.decodeLinearPredictiveCodingSubframe(type - 31, sampleDepth, result);
        } else {
            throw new DataFormatException("Reserved subframe type");
        }
        if (shift > 0) {
            i = 0;
            while (i < this.currentBlockSize) {
                int n = i++;
                result[n] = result[n] << shift;
            }
        }
    }

    private void decodeFixedPredictionSubframe(int predOrder, int sampleDepth, long[] result) throws IOException {
        Objects.requireNonNull(result);
        if (sampleDepth < 1 || sampleDepth > 33) {
            throw new IllegalArgumentException();
        }
        if (predOrder < 0 || predOrder >= FIXED_PREDICTION_COEFFICIENTS.length) {
            throw new IllegalArgumentException();
        }
        if (predOrder > this.currentBlockSize) {
            throw new DataFormatException("Fixed prediction order exceeds block size");
        }
        if (result.length < this.currentBlockSize) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < predOrder; ++i) {
            result[i] = this.in.readSignedInt(sampleDepth);
        }
        this.readResiduals(predOrder, result);
        this.restoreLpc(result, FIXED_PREDICTION_COEFFICIENTS[predOrder], sampleDepth, 0);
    }

    private void decodeLinearPredictiveCodingSubframe(int lpcOrder, int sampleDepth, long[] result) throws IOException {
        Objects.requireNonNull(result);
        if (sampleDepth < 1 || sampleDepth > 33) {
            throw new IllegalArgumentException();
        }
        if (lpcOrder < 1 || lpcOrder > 32) {
            throw new IllegalArgumentException();
        }
        if (lpcOrder > this.currentBlockSize) {
            throw new DataFormatException("LPC order exceeds block size");
        }
        if (result.length < this.currentBlockSize) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < lpcOrder; ++i) {
            result[i] = this.in.readSignedInt(sampleDepth);
        }
        int precision = this.in.readUint(4) + 1;
        if (precision == 16) {
            throw new DataFormatException("Invalid LPC precision");
        }
        int shift = this.in.readSignedInt(5);
        if (shift < 0) {
            throw new DataFormatException("Invalid LPC shift");
        }
        int[] coefs = new int[lpcOrder];
        for (int i = 0; i < coefs.length; ++i) {
            coefs[i] = this.in.readSignedInt(precision);
        }
        this.readResiduals(lpcOrder, result);
        this.restoreLpc(result, coefs, sampleDepth, shift);
    }

    private void restoreLpc(long[] result, int[] coefs, int sampleDepth, int shift) {
        Objects.requireNonNull(result);
        Objects.requireNonNull(coefs);
        if (result.length < this.currentBlockSize) {
            throw new IllegalArgumentException();
        }
        if (sampleDepth < 1 || sampleDepth > 33) {
            throw new IllegalArgumentException();
        }
        if (shift < 0 || shift > 63) {
            throw new IllegalArgumentException();
        }
        long lowerBound = -1 << sampleDepth - 1;
        long upperBound = -(lowerBound + 1L);
        for (int i = coefs.length; i < this.currentBlockSize; ++i) {
            long sum = 0L;
            for (int j = 0; j < coefs.length; ++j) {
                sum += result[i - 1 - j] * (long)coefs[j];
            }
            assert (sum >> 53 == 0L || sum >> 53 == -1L);
            if ((sum = result[i] + (sum >> shift)) < lowerBound || sum > upperBound) {
                throw new DataFormatException("Post-LPC result exceeds bit depth");
            }
            result[i] = sum;
        }
    }

    private void readResiduals(int warmup, long[] result) throws IOException {
        int inc;
        Objects.requireNonNull(result);
        if (warmup < 0 || warmup > this.currentBlockSize) {
            throw new IllegalArgumentException();
        }
        if (result.length < this.currentBlockSize) {
            throw new IllegalArgumentException();
        }
        int method = this.in.readUint(2);
        if (method >= 2) {
            throw new DataFormatException("Reserved residual coding method");
        }
        assert (method == 0 || method == 1);
        int paramBits = method == 0 ? 4 : 5;
        int escapeParam = method == 0 ? 15 : 31;
        int partitionOrder = this.in.readUint(4);
        int numPartitions = 1 << partitionOrder;
        if (this.currentBlockSize % numPartitions != 0) {
            throw new DataFormatException("Block size not divisible by number of Rice partitions");
        }
        int resultIndex = warmup;
        for (int partEnd = inc = this.currentBlockSize >>> partitionOrder; partEnd <= this.currentBlockSize; partEnd += inc) {
            int param = this.in.readUint(paramBits);
            if (param == escapeParam) {
                int numBits = this.in.readUint(5);
                while (resultIndex < partEnd) {
                    result[resultIndex] = this.in.readSignedInt(numBits);
                    ++resultIndex;
                }
                continue;
            }
            this.in.readRiceSignedInts(param, result, resultIndex, partEnd);
            resultIndex = partEnd;
        }
    }
}

