/*
 * Decompiled with CFR 0.152.
 */
package me.zhenxin.zmusic.player.decoder.mp3;

import me.zhenxin.zmusic.player.decoder.mp3.Obuffer;

public class SampleBuffer
extends Obuffer {
    private final short[] buffer = new short[2304];
    private final int[] bufferp = new int[2];
    private final int channels;

    public SampleBuffer(int number_of_channels) {
        this.channels = number_of_channels;
        for (int i = 0; i < number_of_channels; ++i) {
            this.bufferp[i] = (short)i;
        }
    }

    public short[] getBuffer() {
        return this.buffer;
    }

    public int getBufferLength() {
        return this.bufferp[0];
    }

    @Override
    public void append(int channel, short value) {
        this.buffer[this.bufferp[channel]] = value;
        int n = channel;
        this.bufferp[n] = this.bufferp[n] + this.channels;
    }

    @Override
    public void appendSamples(int channel, float[] f) {
        int pos = this.bufferp[channel];
        int i = 0;
        while (i < 32) {
            short s;
            float fs;
            fs = (fs = f[i++]) > 32767.0f ? 32767.0f : Math.max(fs, -32767.0f);
            this.buffer[pos] = s = (short)fs;
            pos += this.channels;
        }
        this.bufferp[channel] = pos;
    }

    @Override
    public void clear_buffer() {
        for (int i = 0; i < this.channels; ++i) {
            this.bufferp[i] = (short)i;
        }
    }
}

