/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.oredict;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.oredict.OreIngredient;

public class OreDictionary {
    private static final boolean DEBUG = false;
    private static boolean hasInit = false;
    private static List<String> idToName = new ArrayList<String>();
    private static Map<String, Integer> nameToId = new HashMap<String, Integer>(128);
    private static List<fi<aip>> idToStack = Lists.newArrayList();
    private static List<fi<aip>> idToStackUn = Lists.newArrayList();
    private static Map<Integer, List<Integer>> stackToId = Maps.newHashMapWithExpectedSize((int)96);
    public static final fi<aip> EMPTY_LIST = fi.a();
    public static final int WILDCARD_VALUE = Short.MAX_VALUE;

    private static void initVanillaEntries() {
        if (!hasInit) {
            OreDictionary.registerOre("logWood", new aip(aox.r, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("logWood", new aip(aox.s, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("plankWood", new aip(aox.f, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("slabWood", new aip((aow)aox.bM, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("stairWood", aox.ad);
            OreDictionary.registerOre("stairWood", aox.bU);
            OreDictionary.registerOre("stairWood", aox.bV);
            OreDictionary.registerOre("stairWood", aox.bW);
            OreDictionary.registerOre("stairWood", aox.cC);
            OreDictionary.registerOre("stairWood", aox.cD);
            OreDictionary.registerOre("fenceWood", aox.aO);
            OreDictionary.registerOre("fenceWood", aox.aP);
            OreDictionary.registerOre("fenceWood", aox.aQ);
            OreDictionary.registerOre("fenceWood", aox.aR);
            OreDictionary.registerOre("fenceWood", aox.aS);
            OreDictionary.registerOre("fenceWood", aox.aT);
            OreDictionary.registerOre("fenceGateWood", aox.bo);
            OreDictionary.registerOre("fenceGateWood", aox.bp);
            OreDictionary.registerOre("fenceGateWood", aox.bq);
            OreDictionary.registerOre("fenceGateWood", aox.br);
            OreDictionary.registerOre("fenceGateWood", aox.bs);
            OreDictionary.registerOre("fenceGateWood", aox.bt);
            OreDictionary.registerOre("stickWood", air.B);
            OreDictionary.registerOre("treeSapling", new aip(aox.g, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("treeLeaves", new aip((aow)aox.t, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("treeLeaves", new aip((aow)aox.u, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("vine", aox.bn);
            OreDictionary.registerOre("oreGold", aox.o);
            OreDictionary.registerOre("oreIron", aox.p);
            OreDictionary.registerOre("oreLapis", aox.x);
            OreDictionary.registerOre("oreDiamond", aox.ag);
            OreDictionary.registerOre("oreRedstone", aox.aC);
            OreDictionary.registerOre("oreEmerald", aox.bP);
            OreDictionary.registerOre("oreQuartz", aox.co);
            OreDictionary.registerOre("oreCoal", aox.q);
            OreDictionary.registerOre("ingotIron", air.m);
            OreDictionary.registerOre("ingotGold", air.n);
            OreDictionary.registerOre("ingotBrick", air.aP);
            OreDictionary.registerOre("ingotBrickNether", air.cq);
            OreDictionary.registerOre("nuggetGold", air.bF);
            OreDictionary.registerOre("nuggetIron", air.da);
            OreDictionary.registerOre("gemDiamond", air.l);
            OreDictionary.registerOre("gemEmerald", air.bZ);
            OreDictionary.registerOre("gemQuartz", air.cr);
            OreDictionary.registerOre("gemPrismarine", air.cN);
            OreDictionary.registerOre("dustPrismarine", air.cO);
            OreDictionary.registerOre("dustRedstone", air.aF);
            OreDictionary.registerOre("dustGlowstone", air.bb);
            OreDictionary.registerOre("gemLapis", new aip(air.be, 1, 4));
            OreDictionary.registerOre("blockGold", aox.R);
            OreDictionary.registerOre("blockIron", aox.S);
            OreDictionary.registerOre("blockLapis", aox.y);
            OreDictionary.registerOre("blockDiamond", aox.ah);
            OreDictionary.registerOre("blockRedstone", aox.cn);
            OreDictionary.registerOre("blockEmerald", aox.bT);
            OreDictionary.registerOre("blockQuartz", aox.cq);
            OreDictionary.registerOre("blockCoal", aox.cA);
            OreDictionary.registerOre("cropWheat", air.R);
            OreDictionary.registerOre("cropPotato", air.cd);
            OreDictionary.registerOre("cropCarrot", air.cc);
            OreDictionary.registerOre("cropNetherWart", air.bG);
            OreDictionary.registerOre("sugarcane", air.aR);
            OreDictionary.registerOre("blockCactus", (aow)aox.aK);
            OreDictionary.registerOre("dye", new aip(air.be, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("paper", new aip(air.aS));
            OreDictionary.registerOre("slimeball", air.aU);
            OreDictionary.registerOre("enderpearl", air.bC);
            OreDictionary.registerOre("bone", air.bf);
            OreDictionary.registerOre("gunpowder", air.K);
            OreDictionary.registerOre("string", air.I);
            OreDictionary.registerOre("netherStar", air.ck);
            OreDictionary.registerOre("leather", air.aN);
            OreDictionary.registerOre("feather", air.J);
            OreDictionary.registerOre("egg", air.aX);
            OreDictionary.registerOre("record", air.cB);
            OreDictionary.registerOre("record", air.cC);
            OreDictionary.registerOre("record", air.cD);
            OreDictionary.registerOre("record", air.cE);
            OreDictionary.registerOre("record", air.cF);
            OreDictionary.registerOre("record", air.cG);
            OreDictionary.registerOre("record", air.cH);
            OreDictionary.registerOre("record", air.cI);
            OreDictionary.registerOre("record", air.cJ);
            OreDictionary.registerOre("record", air.cK);
            OreDictionary.registerOre("record", air.cL);
            OreDictionary.registerOre("record", air.cM);
            OreDictionary.registerOre("dirt", aox.d);
            OreDictionary.registerOre("grass", (aow)aox.c);
            OreDictionary.registerOre("stone", aox.b);
            OreDictionary.registerOre("cobblestone", aox.e);
            OreDictionary.registerOre("gravel", aox.n);
            OreDictionary.registerOre("sand", new aip((aow)aox.m, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("sandstone", new aip(aox.A, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("sandstone", new aip(aox.cM, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("netherrack", aox.aV);
            OreDictionary.registerOre("obsidian", aox.Z);
            OreDictionary.registerOre("glowstone", aox.aX);
            OreDictionary.registerOre("endstone", aox.bH);
            OreDictionary.registerOre("torch", aox.aa);
            OreDictionary.registerOre("workbench", aox.ai);
            OreDictionary.registerOre("blockSlime", aox.cE);
            OreDictionary.registerOre("blockPrismarine", new aip(aox.cI, 1, asx.a.a.a()));
            OreDictionary.registerOre("blockPrismarineBrick", new aip(aox.cI, 1, asx.a.b.a()));
            OreDictionary.registerOre("blockPrismarineDark", new aip(aox.cI, 1, asx.a.c.a()));
            OreDictionary.registerOre("stoneGranite", new aip(aox.b, 1, 1));
            OreDictionary.registerOre("stoneGranitePolished", new aip(aox.b, 1, 2));
            OreDictionary.registerOre("stoneDiorite", new aip(aox.b, 1, 3));
            OreDictionary.registerOre("stoneDioritePolished", new aip(aox.b, 1, 4));
            OreDictionary.registerOre("stoneAndesite", new aip(aox.b, 1, 5));
            OreDictionary.registerOre("stoneAndesitePolished", new aip(aox.b, 1, 6));
            OreDictionary.registerOre("blockGlassColorless", aox.w);
            OreDictionary.registerOre("blockGlass", aox.w);
            OreDictionary.registerOre("blockGlass", new aip((aow)aox.cG, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("paneGlassColorless", aox.bj);
            OreDictionary.registerOre("paneGlass", aox.bj);
            OreDictionary.registerOre("paneGlass", new aip((aow)aox.cH, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("chest", (aow)aox.ae);
            OreDictionary.registerOre("chest", aox.bQ);
            OreDictionary.registerOre("chest", aox.cg);
            OreDictionary.registerOre("chestWood", (aow)aox.ae);
            OreDictionary.registerOre("chestEnder", aox.bQ);
            OreDictionary.registerOre("chestTrapped", aox.cg);
        }
        HashMap<aip, String> replacements = new HashMap<aip, String>();
        replacements.put(new aip(air.B), "stickWood");
        replacements.put(new aip(aox.f, 1, 0), "plankWood");
        replacements.put(new aip(aox.f, 1, 1), "plankWood");
        replacements.put(new aip(aox.f, 1, 2), "plankWood");
        replacements.put(new aip(aox.f, 1, 3), "plankWood");
        replacements.put(new aip(aox.f, 1, 4), "plankWood");
        replacements.put(new aip(aox.f, 1, 5), "plankWood");
        replacements.put(new aip(aox.f, 1, Short.MAX_VALUE), "plankWood");
        replacements.put(new aip((aow)aox.bM, 1, Short.MAX_VALUE), "slabWood");
        replacements.put(new aip(air.n), "ingotGold");
        replacements.put(new aip(air.m), "ingotIron");
        replacements.put(new aip(air.l), "gemDiamond");
        replacements.put(new aip(air.bZ), "gemEmerald");
        replacements.put(new aip(air.cN), "gemPrismarine");
        replacements.put(new aip(air.cO), "dustPrismarine");
        replacements.put(new aip(air.aF), "dustRedstone");
        replacements.put(new aip(air.bb), "dustGlowstone");
        replacements.put(new aip(air.aR), "sugarcane");
        replacements.put(new aip((aow)aox.aK), "blockCactus");
        replacements.put(new aip(air.aS), "paper");
        replacements.put(new aip(air.aU), "slimeball");
        replacements.put(new aip(air.I), "string");
        replacements.put(new aip(air.aN), "leather");
        replacements.put(new aip(air.bC), "enderpearl");
        replacements.put(new aip(air.K), "gunpowder");
        replacements.put(new aip(air.ck), "netherStar");
        replacements.put(new aip(air.J), "feather");
        replacements.put(new aip(air.bf), "bone");
        replacements.put(new aip(air.aX), "egg");
        replacements.put(new aip(aox.b), "stone");
        replacements.put(new aip(aox.e), "cobblestone");
        replacements.put(new aip(aox.e, 1, Short.MAX_VALUE), "cobblestone");
        replacements.put(new aip(aox.aX), "glowstone");
        replacements.put(new aip(aox.w), "blockGlassColorless");
        replacements.put(new aip(aox.cI), "prismarine");
        replacements.put(new aip(aox.b, 1, 1), "stoneGranite");
        replacements.put(new aip(aox.b, 1, 2), "stoneGranitePolished");
        replacements.put(new aip(aox.b, 1, 3), "stoneDiorite");
        replacements.put(new aip(aox.b, 1, 4), "stoneDioritePolished");
        replacements.put(new aip(aox.b, 1, 5), "stoneAndesite");
        replacements.put(new aip(aox.b, 1, 6), "stoneAndesitePolished");
        replacements.put(new aip((aow)aox.ae), "chestWood");
        replacements.put(new aip(aox.bQ), "chestEnder");
        replacements.put(new aip(aox.cg), "chestTrapped");
        String[] dyes = new String[]{"Black", "Red", "Green", "Brown", "Blue", "Purple", "Cyan", "LightGray", "Gray", "Pink", "Lime", "Yellow", "LightBlue", "Magenta", "Orange", "White"};
        for (int i2 = 0; i2 < 16; ++i2) {
            aip dye = new aip(air.be, 1, i2);
            aip block = new aip((aow)aox.cG, 1, 15 - i2);
            aip pane = new aip((aow)aox.cH, 1, 15 - i2);
            if (!hasInit) {
                OreDictionary.registerOre("dye" + dyes[i2], dye);
                OreDictionary.registerOre("blockGlass" + dyes[i2], block);
                OreDictionary.registerOre("paneGlass" + dyes[i2], pane);
            }
            replacements.put(dye, "dye" + dyes[i2]);
            replacements.put(block, "blockGlass" + dyes[i2]);
            replacements.put(pane, "paneGlass" + dyes[i2]);
        }
        hasInit = true;
        aip[] replaceStacks = replacements.keySet().toArray(new aip[replacements.keySet().size()]);
        aip[] exclusions = new aip[]{new aip(aox.y), new aip(air.bk), new aip(aox.bf), new aip((aow)aox.U, 1, Short.MAX_VALUE), new aip(aox.aw), new aip(aox.bZ), new aip(aox.aO), new aip(aox.bo), new aip(aox.ad), new aip(aox.aP), new aip(aox.bp), new aip(aox.bU), new aip(aox.bq), new aip(aox.aQ), new aip(aox.bV), new aip(aox.aR), new aip(aox.br), new aip(aox.bW), new aip(aox.aT), new aip(aox.bt), new aip(aox.cC), new aip(aox.aS), new aip(aox.bs), new aip(aox.cD), new aip((aow)aox.bM, 1, Short.MAX_VALUE), new aip(aox.bj), new aip(aox.di), new aip(air.aH), new aip(air.aI), new aip(air.aJ), new aip(air.aK), new aip(air.aL), new aip(air.aM), new aip(air.at), new aip(air.au), new aip(air.av), new aip(air.aw), new aip(air.ax), new aip(air.ay), aip.a};
        FMLLog.log.info("Starts to replace vanilla recipe ingredients with ore ingredients.");
        int replaced = 0;
        for (akt obj : aku.a) {
            aip output;
            if (obj.getClass() != akw.class && obj.getClass() != akx.class || !(output = obj.b()).b() && OreDictionary.containsMatch(false, new aip[]{output}, exclusions)) continue;
            HashSet replacedIngs = new HashSet();
            fi lst = obj.d();
            for (int x = 0; x < lst.size(); ++x) {
                akq ing = (akq)lst.get(x);
                aip[] ingredients = ing.a();
                String oreName = null;
                boolean skip = false;
                for (aip stack : ingredients) {
                    boolean matches = false;
                    for (Map.Entry ent : replacements.entrySet()) {
                        if (!OreDictionary.itemMatches((aip)ent.getKey(), stack, true)) continue;
                        matches = true;
                        if (oreName != null && !oreName.equals(ent.getValue())) {
                            FMLLog.log.info("Invalid recipe found with multiple oredict ingredients in the same ingredient...");
                            skip = true;
                            break;
                        }
                        if (oreName != null) continue;
                        oreName = (String)ent.getValue();
                        break;
                    }
                    if (!matches && oreName != null) {
                        skip = true;
                    }
                    if (skip) break;
                }
                if (skip || oreName == null) continue;
                lst.set(x, (Object)new OreIngredient(oreName));
                ++replaced;
            }
        }
        FMLLog.log.info("Replaced {} ore ingredients", (Object)replaced);
    }

    public static int getOreID(String name) {
        Integer val = nameToId.get(name);
        if (val == null) {
            idToName.add(name);
            val = idToName.size() - 1;
            nameToId.put(name, val);
            fi back = fi.a();
            idToStack.add((fi<aip>)back);
            idToStackUn.add((fi<aip>)back);
        }
        return val;
    }

    public static String getOreName(int id) {
        return id >= 0 && id < idToName.size() ? idToName.get(id) : "Unknown";
    }

    public static int[] getOreIDs(@Nonnull aip stack) {
        if (stack.b()) {
            throw new IllegalArgumentException("Stack can not be invalid!");
        }
        HashSet<Integer> set = new HashSet<Integer>();
        nf registryName = stack.c().delegate.name();
        if (registryName == null) {
            FMLLog.log.debug("Attempted to find the oreIDs for an unregistered object ({}). This won't work very well.", (Object)stack);
            return new int[0];
        }
        int id = ain.g.a(stack.c().delegate.get());
        List<Integer> ids = stackToId.get(id);
        if (ids != null) {
            set.addAll(ids);
        }
        if ((ids = stackToId.get(id | stack.i() + 1 << 16)) != null) {
            set.addAll(ids);
        }
        Integer[] tmp = set.toArray(new Integer[set.size()]);
        int[] ret = new int[tmp.length];
        for (int x = 0; x < tmp.length; ++x) {
            ret[x] = tmp[x];
        }
        return ret;
    }

    public static fi<aip> getOres(String name) {
        return OreDictionary.getOres(OreDictionary.getOreID(name));
    }

    public static fi<aip> getOres(String name, boolean alwaysCreateEntry) {
        if (alwaysCreateEntry) {
            return OreDictionary.getOres(OreDictionary.getOreID(name));
        }
        return nameToId.get(name) != null ? OreDictionary.getOres(OreDictionary.getOreID(name)) : EMPTY_LIST;
    }

    public static boolean doesOreNameExist(String name) {
        return nameToId.get(name) != null;
    }

    public static String[] getOreNames() {
        return idToName.toArray(new String[idToName.size()]);
    }

    private static fi<aip> getOres(int id) {
        return idToStackUn.size() > id ? idToStackUn.get(id) : EMPTY_LIST;
    }

    private static boolean containsMatch(boolean strict, aip[] inputs, aip ... targets) {
        for (aip input : inputs) {
            for (aip target : targets) {
                if (!OreDictionary.itemMatches(target, input, strict)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsMatch(boolean strict, fi<aip> inputs, aip ... targets) {
        for (aip input : inputs) {
            for (aip target : targets) {
                if (!OreDictionary.itemMatches(target, input, strict)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean itemMatches(@Nonnull aip target, @Nonnull aip input, boolean strict) {
        if (input.b() && !target.b() || !input.b() && target.b()) {
            return false;
        }
        return target.c() == input.c() && (target.j() == Short.MAX_VALUE && !strict || target.j() == input.j());
    }

    public static void registerOre(String name, ain ore) {
        OreDictionary.registerOre(name, new aip(ore));
    }

    public static void registerOre(String name, aow ore) {
        OreDictionary.registerOre(name, new aip(ore));
    }

    public static void registerOre(String name, @Nonnull aip ore) {
        OreDictionary.registerOreImpl(name, ore);
    }

    private static void registerOreImpl(String name, @Nonnull aip ore) {
        ArrayList ids;
        int hash;
        if ("Unknown".equals(name)) {
            return;
        }
        if (ore.b()) {
            FMLLog.bigWarning("Invalid registration attempt for an Ore Dictionary item with name {} has occurred. The registration has been denied to prevent crashes. The mod responsible for the registration needs to correct this.", name);
            return;
        }
        int oreID = OreDictionary.getOreID(name);
        nf registryName = ore.c().delegate.name();
        if (registryName == null) {
            ModContainer modContainer = Loader.instance().activeModContainer();
            String modContainerName = modContainer == null ? null : modContainer.getName();
            FMLLog.bigWarning("A broken ore dictionary registration with name {} has occurred. It adds an item (type: {}) which is currently unknown to the game registry. This dictionary item can only support a single value when registered with ores like this, and NO I am not going to turn this spam off. Just register your ore dictionary entries after the GameRegistry.\nTO USERS: YES this is a BUG in the mod " + modContainerName + " report it to them!", name, ore.c().getClass());
            hash = -1;
        } else {
            hash = ain.g.a(ore.c().delegate.get());
        }
        if (ore.i() != Short.MAX_VALUE) {
            hash |= ore.i() + 1 << 16;
        }
        if ((ids = stackToId.get(hash)) != null && ids.contains(oreID)) {
            return;
        }
        if (ids == null) {
            ids = Lists.newArrayList();
            stackToId.put(hash, ids);
        }
        ids.add(oreID);
        ore = ore.l();
        idToStack.get(oreID).add((Object)ore);
        MinecraftForge.EVENT_BUS.post(new OreRegisterEvent(name, ore));
    }

    public static void rebakeMap() {
        stackToId.clear();
        for (int id = 0; id < idToStack.size(); ++id) {
            fi<aip> ores = idToStack.get(id);
            if (ores == null) continue;
            for (aip ore : ores) {
                int hash;
                nf name = ore.c().delegate.name();
                if (name == null) {
                    FMLLog.log.debug("Defaulting unregistered ore dictionary entry for ore dictionary {}: type {} to -1", (Object)OreDictionary.getOreName(id), ore.c().getClass());
                    hash = -1;
                } else {
                    hash = ain.g.a(ore.c().delegate.get());
                }
                if (ore.i() != Short.MAX_VALUE) {
                    hash |= ore.i() + 1 << 16;
                }
                List ids = stackToId.computeIfAbsent(hash, k2 -> Lists.newArrayList());
                ids.add(id);
            }
        }
    }

    static {
        OreDictionary.initVanillaEntries();
    }

    public static class OreRegisterEvent
    extends Event {
        private final String Name;
        private final aip Ore;

        public OreRegisterEvent(String name, @Nonnull aip ore) {
            this.Name = name;
            this.Ore = ore;
        }

        public String getName() {
            return this.Name;
        }

        @Nonnull
        public aip getOre() {
            return this.Ore;
        }
    }
}

