#version 120

/*
AirLoocke42’ shaders, Derived From Chocapic13 v4.4 Beta
Place two leading Slashes in front of the following '#define' lines in order to disable an option.
*/

//----------Shadows----------//

const int shadowMapResolution = 512;		
const float shadowDistance = 51.2;		

#define SHADOW_DARKNESS 1.4	

//----------End of Shadows----------//

//----------Lighting----------//
	
#define DYNAMIC_HANDLIGHT		
#define SUNLIGHTAMOUNT 7.0	
	
vec3 torchcolor = vec3(0.6,0.32,0.1);	
#define TORCH_ATTEN 5.0			
#define TORCH_INTENSITY 8.0	

#define ATTENUATION 3.0
#define MIN_LIGHT 0.005

//----------End of Lighting----------//

//----------Visual----------//

#define GODRAYS
	const float density = 0.7;			
	const int NUM_SAMPLES = 5;	
	const float grnoise = 0.012;			
	
//#define CELSHADING
	#define BORDER 1.0

//----------End of Visual----------//


const float sunPathRotation = -40.0f;	
const float wetnessHalflife = 70.0f;
const float drynessHalflife = 70.0f;
const bool shadowHardwareFiltering = true;

const int R8 = 0;
const int gdepthFormat = R8;
const int noiseTextureResolution = 32;
const bool generateShadowMipmap = false; 

#define SHADOW_MAP_BIAS 0.80

varying vec4 texcoord;
varying vec3 lightVector;
varying vec3 sunlight_color;
varying vec3 ambient_color;
varying float handItemLight;

uniform sampler2D gcolor;
uniform sampler2D depthtex0;
uniform sampler2D depthtex1;
uniform sampler2D gnormal;
uniform sampler2DShadow shadow;
uniform sampler2D gaux1;
uniform sampler2D noisetex;

uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 shadowProjection;
uniform mat4 shadowModelView;
uniform vec3 sunPosition;
uniform vec3 upPosition;
uniform vec3 cameraPosition;
uniform float near;
uniform float far;
uniform vec3 skyColor;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float wetness;
uniform float aspectRatio;
uniform float frameTimeCounter;
uniform ivec2 eyeBrightnessSmooth;
uniform int isEyeInWater;
uniform int worldTime;
uniform int fogMode;

float cdist(vec2 coord){
    return distance(coord,vec2(0.5))*2.0;
}

vec3 convertScreenSpaceToWorldSpace(vec2 co, float depth) {
    vec4 fragposition = gbufferProjectionInverse * vec4(vec3(co, depth) * 2.0 - 1.0, 1.0);
    fragposition /= fragposition.w;
    return fragposition.xyz;
}

vec3 convertCameraSpaceToScreenSpace(vec3 cameraSpace) {
    vec4 clipSpace = gbufferProjection * vec4(cameraSpace, 1.0);
    vec3 NDCSpace = clipSpace.xyz / clipSpace.w;
    vec3 screenSpace = 0.5 * NDCSpace + 0.5;
    return screenSpace;
}

float luma(vec3 color) {
	return dot(color,vec3(0.299, 0.587, 0.114));
}

float ld(float depth) {
    return (2.0 * near) / (far + near - depth * (far - near));
}
vec3 nvec3(vec4 pos) {
    return pos.xyz/pos.w;
}

vec4 nvec4(vec3 pos) {
    return vec4(pos.xyz, 1.0);
}
float edepth(vec2 coord) {
	return texture2D(depthtex0,coord).z;
}

vec2 texel = vec2(1.0/viewWidth,1.0/viewHeight);

float pw = 1.0/ viewWidth;
float ph = 1.0/ viewHeight;

vec3 aux = texture2D(gaux1, texcoord.st).rgb;
vec3 sunPos = sunPosition;
vec3 normal = texture2D(gnormal, texcoord.st).rgb * 2.0f - 1.0f;

float pixeldepth = texture2D(depthtex0,texcoord.xy).x;


float handlight = handItemLight;
float torch_lightmap = pow(aux.b,TORCH_ATTEN)*TORCH_INTENSITY;

float sky_lightmap = pow(aux.r,ATTENUATION);
float iswet = wetness*pow(sky_lightmap,5.0)*sqrt(0.5+max(dot(normal,normalize(upPosition)),0.0));
	
float mat(float n) { return fract(sin(n)*43758.5453); }

float noise(vec2 x){
      vec2 p = floor(x);
      vec2 f = fract(x); 

      float iRes = 32.0;
      float n = p.x + p.y* iRes;

    return mix(mix(mat(n-1.0), mat(n),f.x), mix(mat(n+(iRes-1.0)), mat(n+iRes),f.x),f.y);
}

float getCNoise(vec4 fragpos, float x, float y, float z) {

	vec4 wrldpos = gbufferModelViewInverse * fragpos / far * 2048;

	float common = (wrldpos.y + length(wrldpos.y))/100, t = frameTimeCounter;  
	float f = 0.25, frq = 1.0, ap = 0.5;

	vec2 wind = vec2(t/5.0)/(x+2.0), camPos = (wrldpos.xz*z*0.5/wrldpos.y);
	vec2 pos = -1+16*(camPos + wind/y); pos /= x/y;

 	f += noise((pos*frq))*ap, frq *= 2.1, ap *= 0.5;
	f += noise((pos*frq))*ap, frq *= 2.1, ap *= 0.5;
	f += noise((pos*frq))*ap, frq *= 2.1, ap *= 0.5;
	f += noise((pos*frq))*ap, frq *= 2.1, ap *= 0.5;
	f += noise((pos*frq))*ap, frq *= 2.1, ap *= 0.5;
 	f += noise((pos*frq))*ap, frq *= 2.1, ap *= 0.5;
	f += noise((pos*frq))*ap, frq *= 2.1, ap *= 0.5;
	f += noise((pos*frq))*ap, frq *= 2.1, ap *= 0.5;
	f += noise((pos*frq))*ap, frq *= 2.1, ap *= 0.5;
	f += noise((pos*frq))*ap, frq *= 2.1, ap *= 0.5;

	f += sin(pos.x + t)*0.025; f += sin(pos.y + t)*0.025;

	f /= 0.72; float tex = f, b = 0.875, c = tex - (b+0.2);
	if(c <= 0) c = 0; tex = ((1.0 - pow(b, c))*common);

	float getCNoise = tex * (1-rainStrength);

    return getCNoise;
}

void main() {
	
	#ifndef DYNAMIC_HANDLIGHT
	handlight = 0.0;
	#endif

	//unpack material flags
	float shadowexit = float(aux.g > 0.1 && aux.g < 0.3);
	float land = float(aux.g > 0.04);
	float iswater = float(aux.g > 0.04 && aux.g < 0.07);
	float translucent = float(aux.g > 0.3 && aux.g < 0.5);
	float hand = float(aux.g > 0.75 && aux.g < 0.85);

	float fresnel_pow = 5.0;
	float shading = 0.0f;
	float spec = 0.0;
	
	vec3 color = texture2D(gcolor, texcoord.st).rgb;
	color = pow(color,vec3(2.2));
	color = pow(color,vec3(1.0+iswet*0.5));
	
	vec4 fragposition = gbufferProjectionInverse * vec4(texcoord.s * 2.0f - 1.0f, texcoord.t * 2.0f - 1.0f, 2.0f * pixeldepth - 1.0f, 1.0f);
	fragposition /= fragposition.w;
	

	float time = float(worldTime);
	float transition_fading = 1.0-(clamp((time-12000.0)/300.0,0.0,1.0)-clamp((time-13000.0)/300.0,0.0,1.0) + clamp((time-22800.0)/200.0,0.0,1.0)-clamp((time-23400.0)/200.0,0.0,1.0));	//fading between sun/moon shadows
	float night = clamp((time-12000.0)/300.0,0.0,1.0)-clamp((time-22800.0)/200.0,0.0,1.0);
	
	
	float dist = length(fragposition.xyz);
	float distof = clamp(1.0-dist/shadowDistance,0.0,1.0);
	float distof2 = clamp(1.0-dist/(shadowDistance*0.75),0.0,1.0);
	float shadow_fade = clamp(distof*12.0,0.0,1.0);
	float sss_fade = pow(distof2,0.2);
	
	float volumetric_cone = max(dot(normalize(fragposition.xyz), lightVector),0.0);

	vec4 worldposition = vec4(0.0), horize = vec4(0.0);
	
	worldposition = gbufferModelViewInverse * fragposition;	
	
	horize = worldposition / far * 128.0;

        float horizon = abs(horize.y - texcoord.y);

	float skyPos = max(pow(max(1.0 - horizon/3500.0, 0.01), 8.0)-0.1, 0.0);
	      skyPos = clamp(skyPos, 0.35, 1.0);

	float vista = max(pow(max(1.0 - horizon/500.0, 0.01), 8.0)-0.1, 0.0);

	vec3 skyGradient = ((ambient_color*16 + sunlight_color*8)/16.0);

	vec3 skyC = vec3(0.15, 0.4, 1.0) * 0.6 * (1.0-rainStrength);
	     skyC += vec3(0.4) * rainStrength * (1.0-night);
	     skyC += vec3(0.1) * rainStrength * night;

	vec3 sunC = sunlight_color * (1.0-night);
	     sunC += vec3(0.15, 0.4, 1.0) * 10.0 * night;
 
	float stars = mat(horize.x);
	stars *= stars;
	stars *= stars;
	stars *= stars;
	stars *= stars;
	stars *= stars;
	stars *= stars;
	stars *= stars;
	stars *= stars;
	stars *= stars;
	stars *= stars;
	stars *= stars;
	stars *= stars;

	if (land < 0.1) {
	color.rgb = skyGradient * skyPos * skyC;
	color.rgb = mix(color.rgb, skyGradient * 0.3, vista);

	color.rgb += clamp(pow(volumetric_cone, 700.0), 0.0, 0.2) * sunlight_color * 2.0 * (1.0-night) * (1.0-rainStrength);
	color.rgb += clamp(pow(volumetric_cone, 1e3), 0.0, 0.2) * vec3(0.7, 0.8, 1.0) * 2.0 * night * (1.0-rainStrength);

	color += (pow(stars, 1.2)*night) * (horize.y + length(horize.y))/100;
	}

	if (land > 0.9 && isEyeInWater < 0.1) {

	/*--reprojecting into shadow space --*/

	float xzDistanceSquared = worldposition.x * worldposition.x + worldposition.z * worldposition.z;
	float yDistanceSquared  = worldposition.y * worldposition.y;
	
	worldposition = shadowModelView * worldposition;
	float comparedepth = -worldposition.z;
	worldposition = shadowProjection * worldposition;
	worldposition /= worldposition.w;
	
	float distb = sqrt(worldposition.x * worldposition.x + worldposition.y * worldposition.y);
	float distortFactor = (1.0f - SHADOW_MAP_BIAS) + distb * SHADOW_MAP_BIAS;
	worldposition.xy *= 1.0f / distortFactor;
	worldposition = worldposition * 0.5f + 0.5f;
	/*---------------------------------*/
	
	float diffthresh = 1.0*distortFactor+iswater+translucent;

	float step = 2.0/shadowMapResolution*(1.0+rainStrength*5.0);
	
	shadow_fade = 1.0-clamp((max(abs(worldposition.x-0.5),abs(worldposition.y-0.5))*2.0-0.9),0.0,0.1)*10.0;

	if (sky_lightmap < 0.1) { shading = 0.0; } else {			
	shading = shadow2D(shadow,vec3(worldposition.st, worldposition.z-diffthresh/300)).x;
	}	

	float ao = 1.0;
	
	float sss_transparency = mix(0.0,0.75,translucent);		
	float sunlight_direct = 1.0;

	vec3 npos = normalize(fragposition.xyz);
	
	float NdotL = dot(normal, lightVector);

	sunlight_direct = max(NdotL,0.0);
	
	sunlight_direct = mix(sunlight_direct,0.6,translucent*min(sss_fade+0.5,1.0));
	float sss = pow(max(dot(npos, lightVector),0.0),20.0)*sss_transparency*clamp(-NdotL,0.0,1.0)*translucent*8.0;
	
	sss = mix(0.0,sss,sss_fade);
	shading = clamp(shading,0.0,1.0);

	vec3 Sunlight_lightmap = sunlight_color*mix(max(sky_lightmap-rainStrength*0.95,0.0),shading*(1.0-rainStrength*0.95),shadow_fade)*SUNLIGHTAMOUNT *sunlight_direct*transition_fading ;
		
		
	float visibility = sky_lightmap;
	float bouncefactor = (dot(normal,normalize(upPosition))*0.5+0.5)*sky_lightmap;
		
	vec3 reflected_sunlight = SHADOW_DARKNESS*sky_lightmap*sunlight_color*(max(-NdotL*0.3,0.0)+1.0)*ao*0.5*(1.0-rainStrength*0.95);
		
	vec3 sky_light = SHADOW_DARKNESS*ambient_color*vec3(0.8,0.8,1.0)*ao * mix(0.25,0.5,bouncefactor) * visibility*2.0;
		
	vec3 Torchlight_lightmap = (torch_lightmap) *  torchcolor ;
		
	vec3 color_sunlight = Sunlight_lightmap;
	vec3 color_torchlight = Torchlight_lightmap;

	color = (reflected_sunlight + sky_light + MIN_LIGHT*ao + Sunlight_lightmap + color_torchlight*ao  +  sss * sunlight_color * shading *(1.0-rainStrength*0.9)*transition_fading*5.0)*color ;

	float gfactor = mix(0.0,1.0,iswater);

	spec = clamp(pow(max(0.0f, dot(normalize(lightVector - normalize(fragposition.xyz)), normal)), 300.0)*3.0,0.0,1.0) * land * (1.0-isEyeInWater) * shading;

	} else if (isEyeInWater < 0.1 && (aux.g < 0.02) ){
		color = color*6.0;	
	}

	vec3 basic_colour = sunlight_color*(1-night) + (vec3(4,6,16)/225.0/1.3)*night;

	if (land < 0.1) {
	color.rgb += (basic_colour * getCNoise(fragposition, 24, 2.0, 2));
	color.rgb += (basic_colour * getCNoise(fragposition, 8., 1.1, 2));
	}

	if(aux.g > 0.02 && aux.g < 0.04) color *= 5.0;

/* DRAWBUFFERS:31 */

	#ifdef GODRAYS
	vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
	tpos = vec4(tpos.xyz/tpos.w,1.0);
	vec2 pos1 = tpos.xy/tpos.z;
	vec2 lightPos = pos1*0.5+0.5;
	
	float gr = 0.0;
	
	float truepos = pow(clamp(dot(-lightVector,tpos.xyz)/length(tpos.xyz),0.0,1.0),0.5);		//temporary fix that check if the sun/moon position is correct
	
	if (truepos > 0.05) {	
		vec2 deltaTextCoord = vec2( texcoord.st - lightPos.xy );
		vec2 textCoord = texcoord.st;
		deltaTextCoord *= 1.0 /  float(NUM_SAMPLES) * density;
	
			float avgdecay = 0.0;
			float distx = abs(texcoord.x*aspectRatio-lightPos.x*aspectRatio);
			float disty = abs(texcoord.y-lightPos.y);
			
			for(int i=0; i < NUM_SAMPLES ; i++) {			
				textCoord -= deltaTextCoord;
				float sample = step(texture2D(gaux1, textCoord).g,0.01);
				gr += sample;
		}
	}
	#endif

	color = clamp(color/16.0,0.0,1.0);

	gl_FragData[0] = vec4(color, spec);
	gl_FragData[1] = vec4(vec3((gr/NUM_SAMPLES)),1.0);
}