#version 400 compatibility

/*






!! DO NOT REMOVE !! !! DO NOT REMOVE !!

This code is from Chocapic13' shaders
Read the terms of modification and sharing before changing something below please !
!! DO NOT REMOVE !! !! DO NOT REMOVE !!


Sharing and modification rules

Sharing a modified version of my shaders:
-You are not allowed to claim any of the code included in "Chocapic13' shaders" as your own
-You can share a modified version of my shaders if you respect the following title scheme : " -Name of the shaderpack- (Chocapic13' Shaders edit) "
-You cannot use any monetizing links
-The rules of modification and sharing have to be same as the one here (copy paste all these rules in your post), you cannot make your own rules
-I have to be clearly credited
-You cannot use any version older than "Chocapic13' Shaders V4" as a base, however you can modify older versions for personal use
-Common sense : if you want a feature from another shaderpack or want to use a piece of code found on the web, make sure the code is open source. In doubt ask the creator.
-Common sense #2 : share your modification only if you think it adds something really useful to the shaderpack(not only 2-3 constants changed)


Special level of permission; with written permission from Chocapic13, if you think your shaderpack is an huge modification from the original (code wise, the look/performance is not taken in account):
-Allows to use monetizing links
-Allows to create your own sharing rules
-Shaderpack name can be chosen
-Listed on Chocapic13' shaders official thread
-Chocapic13 still have to be clearly credited


Using this shaderpack in a video or a picture:
-You are allowed to use this shaderpack for screenshots and videos if you give the shaderpack name in the description/message
-You are allowed to use this shaderpack in monetized videos if you respect the rule above.


Minecraft website:
-The download link must redirect to the link given in the shaderpack's official thread
-You are not allowed to add any monetizing link to the shaderpack download

If you are not sure about what you are allowed to do or not, PM Chocapic13 on http://www.minecraftforum.net/
Not respecting these rules can and will result in a request of thread/download shutdown to the host/administrator, with or without warning. Intellectual property stealing is punished by law.











*/
const vec3 moonlightS =vec3(0.575, 1.05, 1.4) * 0.01;
const vec3 moonlight = vec3(0.55, 0.9, 1.35) * 0.001;
/*
Disable an effect by putting "//" before "#define" when there is no number after
You can tweak the numbers, the impact on the shaders is self-explained in the variable's name or in a comment
*/

//go to line 46 for changing sunlight color and ambient color line 89 for moon light color
/*--------------------------------*/
out vec2 texcoord;
out vec3 sunVec;
out vec3 moonVec;
out vec3 upVec;
out float tr;
out float tempSample;
out vec3 sunlight;

out float SdotU;
out float MdotU;
out float sunVisibility;
out float moonVisibility;
out vec3 scatSunlight;

out vec3 ambientUp;
out vec3 ambientLeft;
out vec3 ambientRight;
out vec3 ambientB;
out vec3 ambientF;
out vec3 ambientDown;
out vec2 tempOffset;


uniform vec3 skyColor;
uniform vec3 sunPosition;
uniform vec3 upPosition;
uniform int worldTime;
uniform int heldItemId;
uniform int heldBlockLightValue;
uniform float rainStrength;
uniform float wetness;
uniform ivec2 eyeBrightnessSmooth;
uniform int frameCounter;

uniform vec3 cameraPosition;
uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;
uniform mat4 shadowProjection;
uniform mat4 shadowModelView;
/*--------------------------------*/


const vec3 ToD[7] = vec3[7](  vec3(0.58597,0.22,0.02)*1.,
								vec3(0.58597,0.31,0.08)*0.85,
								vec3(0.58597,0.45,0.16)*0.6,
								vec3(0.58597,0.46,0.28)*0.5,
								vec3(0.58597,0.47,0.3)*0.7,
								vec3(0.58597,0.47,0.32)*1.,
								vec3(0.58597,0.47,0.33)*1.1);

vec3 sky_color = ivec3(60,170,255)/255.0;
/*--------------------------------*/
float luma(vec3 color) {
	return dot(color,vec3(0.299, 0.587, 0.114));
}


// earth shadow hack
const float pi = 3.141592653589793238462643383279502884197169;

	float turbidity = 5.;
	float rayleighCoefficient = 2.0;

	// constants for mie scattering
	const float mieCoefficient = 0.005;
	const float mieDirectionalG = 0.76;
	const float v = 4.0;

	// Wavelength of the primary colors RGB in nanometers.
	const vec3 primaryWavelengths = vec3(680, 550, 450) * 1.0E-9;
	
	float n = 1.00029; // refractive index of air
	float N = 2.54743E25; // number of molecules per unit volume for air at 288.15K and 1013mb (sea level -45 celsius)
	float pn = 0.035;	// depolarization factor for standard air

	// optical length at zenith for molecules
	float rayleighZenithLength = 8.4E3 ;
	float mieZenithLength = 1.25E3;
	
	const vec3 K = vec3(0.686, 0.678, 0.666);

	float sunIntensity = 1000.0;

	// earth shadow hack
	float cutoffAngle = pi * 0.5128205128205128;
	float steepness = 1.5;


float RayleighPhase(float cosViewSunAngle)
{
	/*
	Rayleigh phase function.
			   3
	p(θ) =	________   [1 + cos(θ)^2]
			   16π
	*/

	return (3.0 / (16.0*pi)) * (1.0 + pow(max(cosViewSunAngle, 0.0), 2.0));
}

float hgPhase(float cosViewSunAngle, float g)
{

	/*
	Henyey-Greenstein phase function.
			   1		 		1 − g^2 
	p(θ) =	________   ____________________________
			   4π		[1 + g^2 − 2g cos(θ)]^(3/2)
	*/


	return (1.0 / (4.0 * pi)) * ((1.0 - pow(g, 2.0)) / pow(1.0 + pow(g, 2.0) - 2.0*g * cosViewSunAngle, 1.5));
}

vec3 totalMie(vec3 lambda, vec3 K, float T, float v)
{
	float c = (0.2 * T ) * 10E-18;
	return 0.434 * c * pi * pow((2.0 * pi) / lambda, vec3(v - 2.0)) * K;
}

vec3 totalRayleigh(vec3 lambda, float n, float N, float pn){
	return (24.0 * pow(pi, 3.0) * pow(pow(n, 2.0) - 1.0, 2.0) * (6.0 + 3.0 * pn))
	/ (N * pow(lambda, vec3(4.0)) * pow(pow(n, 2.0) + 2.0, 2.0) * (6.0 - 7.0 * pn));
}

float SunIntensity(float zenithAngleCos, float sunIntensity, float cutoffAngle, float steepness)
{
	return sunIntensity * max(0.0, 1.0 - exp(-((cutoffAngle - acos(zenithAngleCos))/steepness)));
}

float calcSun(vec3 fragpos, vec3 sunVec){

	const float sunAngularDiameterCos = 0.99873194915;

	float cosViewSunAngle = dot(normalize(fragpos.rgb), sunVec);
	float sundisk = smoothstep(sunAngularDiameterCos,sunAngularDiameterCos+0.0001,cosViewSunAngle);

	return 10000.0 * sundisk * (1.0 - rainStrength);

}

float calcMoon(vec3 fragpos, vec3 moonVec){

	const float moonAngularDiameterCos = 0.99833194915;

	float cosViewSunAngle = dot(normalize(fragpos.rgb), moonVec);
	float moondisk = smoothstep(moonAngularDiameterCos,moonAngularDiameterCos+0.001,cosViewSunAngle);

	return clamp(4.0 * moondisk, 0.0, 15.0) * (1.0 - rainStrength);

}

vec3 getAtmosphericScattering(vec3 color, vec3 fragpos){

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	float turbidity = 5.;
	float rayleighCoefficient = 2.5;

	// constants for mie scattering
	const float mieCoefficient = 0.02;
	const float mieDirectionalG = 0.7;
	const float v = 4.0;

	// Wavelength of the primary colors RGB in nanometers.
	const vec3 primaryWavelengths = vec3(680, 550, 450) * 1.0E-9;
	
	float n = 1.00029; // refractive index of air
	float N = 2.54743E25; // number of molecules per unit volume for air at 288.15K and 1013mb (sea level -45 celsius)
	float pn = 0.035;	// depolarization factor for standard air

	// optical length at zenith for molecules
	float rayleighZenithLength = 8.4E3 ;
	float mieZenithLength = 1.25E3;
	
	const vec3 K = vec3(0.686, 0.678, 0.666);

	float sunIntensity = 1000.0;

	// earth shadow hack
	float cutoffAngle = pi * 0.5128205128205128;
	float steepness = 1.5;

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	// Cos Angles
	float cosViewSunAngle = dot(normalize(fragpos.rgb), sunVec);
	float cosSunUpAngle = dot(sunVec, upVec) * 0.95 + 0.05; //Has a lower offset making it scatter when sun is below the horizon.
	float cosUpViewAngle = pow(abs(dot(upVec, normalize(fragpos.rgb))),1.0)*sign(dot(upVec, normalize(fragpos.rgb)));
	float sunAngle = max(0.0, cosSunUpAngle * 0.95 + 0.05);
	
	vec3 sunE = vec3(1.076449,0.986088,0.905627)*SunIntensity(cosSunUpAngle, sunIntensity, cutoffAngle, steepness);  // Get sun intensity based on how high in the sky it is
	
	vec3 totalRayleigh = totalRayleigh(primaryWavelengths, n, N, pn);

	vec3 rayleighAtX = totalRayleigh * rayleighCoefficient;

	vec3 mieAtX = totalMie(primaryWavelengths, K, turbidity, v) * mieCoefficient;

	float zenithAngle = max(0.0, cosUpViewAngle);

	float rayleighOpticalLength = rayleighZenithLength / zenithAngle;
	float mieOpticalLength = mieZenithLength / zenithAngle;
	
	float rayleighOpticalLengthSun = rayleighZenithLength / sunAngle;
	float mieOpticalLengthSun = mieZenithLength / sunAngle;
	
	vec3 Fex = exp(-(rayleighAtX * rayleighOpticalLength + mieAtX * mieOpticalLength));
	vec3 FexSun = exp(-(rayleighAtX * rayleighOpticalLengthSun + mieAtX * mieOpticalLengthSun));

	vec3 rayleighXtoEye = rayleighAtX * RayleighPhase(cosViewSunAngle)*(1.0+exp(-sqrt(Fex*FexSun)));
	vec3 mieXtoEye = mieAtX *  hgPhase(cosViewSunAngle , mieDirectionalG)*FexSun;

	vec3 totalLightAtX = rayleighAtX + mieAtX;
	vec3 lightFromXtoEye = rayleighXtoEye + mieXtoEye;

	vec3 scattering = sunE * (lightFromXtoEye / totalLightAtX);

	vec3 sky = scattering *(1.0-Fex);
	float SdotE = dot(sunVec,normalize(fragpos.xyz));
	float EdotU = clamp(1.0-dot(upVec,normalize(fragpos.xyz)),0.,1.25);
	vec3 rainSky = vec3(0.1,0.14,0.2)*sunlight*0.15*exp(SdotE*SdotE*SdotE*2. + EdotU*EdotU*EdotU) + vec3(0.1,0.12,0.15)*length(sunlight);
	
	
	return sky*1.5*(1.0-rainStrength)+rainSky*rainStrength/0.0075*0.5;
}
float HaltonSeq(int prime, int index)
    {
        float r = 0.;
        float f = 1.;
        int i = index;
        while (i > 0)
        {
            f /= prime;
            r += f * (i % prime);
            i = int(i / float(prime));
        }
        return r;
    }
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////


void main() {

	vec2 trCalc = min(abs(worldTime-vec2(23250.0,12700.0)),300.0);
	tr = max(min(trCalc.x,trCalc.y)/300.,0.0);
	tr *= tr;
	/*--------------------------------*/
	gl_Position = ftransform();
	texcoord = (gl_MultiTexCoord0).xy;
	/*--------------------------------*/

	/*--------------------------------*/
	sunVec = normalize(sunPosition);
	moonVec = normalize(-sunPosition);
	upVec = normalize(upPosition);

	SdotU = dot(sunVec,upVec);
	MdotU = dot(moonVec,upVec);
	sunVisibility = pow(clamp(SdotU+0.15,0.0,0.3)/0.3,4.4);
	moonVisibility = pow(clamp(MdotU+0.15,0.0,0.3)/0.3,4.4);
	/*--------------------------------*/

	//reduced the sun color to a 7 array
	float hour = max(mod(worldTime/1000.0+2.0,24.0)-2.0,0.0);  //-0.1
	float cmpH = max(-abs(floor(hour)-6.0)+6.0,0.0); //12
	float cmpH1 = max(-abs(floor(hour)-5.0)+6.0,0.0); //1


	vec3 temp = ToD[int(cmpH)];
	vec3 temp2 = ToD[int(cmpH1)];

	sunlight = mix(temp,temp2,fract(hour));


	
	ambientUp = vec3(0.);
	ambientLeft = vec3(0.);
	ambientRight = vec3(0.);
	ambientB = vec3(0.);
	ambientF = vec3(0.);
	ambientDown = vec3(0.);

	
	
	//sample ambient skylight
	for (int i = -8; i < 9; i++) {
		for (int j = -8; j < 9; j++) {
		vec2 ij = vec2(i,j)/10.;
	    ij = sqrt(abs(ij))*sign(ij);
		float height = 1.0-ij.x*ij.x-ij.y*ij.y;
		if (height > 0.0){
			vec4 pos = vec4(normalize(vec3(ij.x,sqrt(height),ij.y)),0.0);
			vec4 posV = gbufferModelView*pos;
			
			
			vec3 samplee = max(vec3(0.),getAtmosphericScattering(vec3(0.),posV.xyz)/17./17.*0.0075/0.81*pi*vec3(1.0,0.95,0.81))*sunVisibility + moonlight*pi*0.7*(exp(dot(moonVec,normalize(posV.xyz))*1.))/17./17.*(1.0-rainStrength*0.5);
			
			ambientUp += samplee*(pos.y+abs(pos.x/8.)+abs(pos.z/8.));
			ambientLeft += samplee*(max(-pos.x,0.0)+max(pos.y/8.,0.0)+abs(pos.z/8.));
			ambientRight += samplee*(max(pos.x,0.0)+max(pos.y/8.,0.0)+abs(pos.z/8.));
			ambientB += samplee*(max(pos.z,0.0)+abs(pos.x/8.)+max(pos.y/8.,0.0));
			ambientF += samplee*(max(-pos.z,0.0)+abs(pos.x/8.)+max(pos.y/8.,0.0));
			ambientDown += samplee*(max(pos.y/4.,0.0)+abs(pos.x/8.)+abs(pos.z/8.));
	}
	}
	}

	float cosSunUpAngle = dot(sunVec, upVec) * 0.95 + 0.05; //Has a lower offset making it scatter when sun is below the horizon.
	float sunE = SunIntensity(cosSunUpAngle, sunIntensity, cutoffAngle, steepness);  // Get sun intensity based on how high in the sky it is
	
	scatSunlight = sunlight;
	
	sunlight = (sunlight)/luma(sunlight)*sunE*0.0075*0.075*3.*sunVisibility;
	
	int frame = int(mod(frameCounter*1.0,16.));
	tempOffset = vec2(HaltonSeq(2,frame+1),HaltonSeq(3,frame+1))-0.5;
		tempSample = HaltonSeq(3,frame+1);
}
