#version 400 compatibility

/*






!! DO NOT REMOVE !! !! DO NOT REMOVE !!

This code is from Chocapic13' shaders
Read the terms of modification and sharing before changing something below please !
!! DO NOT REMOVE !! !! DO NOT REMOVE !!


Sharing and modification rules

Sharing a modified version of my shaders:
-You are not allowed to claim any of the code included in "Chocapic13' shaders" as your own
-You can share a modified version of my shaders if you respect the following title scheme : " -Name of the shaderpack- (Chocapic13' Shaders edit) "
-You cannot use any monetizing links
-The rules of modification and sharing have to be same as the one here (copy paste all these rules in your post), you cannot make your own rules
-I have to be clearly credited
-You cannot use any version older than "Chocapic13' Shaders V4" as a base, however you can modify older versions for personal use
-Common sense : if you want a feature from another shaderpack or want to use a piece of code found on the web, make sure the code is open source. In doubt ask the creator.
-Common sense #2 : share your modification only if you think it adds something really useful to the shaderpack(not only 2-3 constants changed)


Special level of permission; with written permission from Chocapic13, if you think your shaderpack is an huge modification from the original (code wise, the look/performance is not taken in account):
-Allows to use monetizing links
-Allows to create your own sharing rules
-Shaderpack name can be chosen
-Listed on Chocapic13' shaders official thread
-Chocapic13 still have to be clearly credited


Using this shaderpack in a video or a picture:
-You are allowed to use this shaderpack for screenshots and videos if you give the shaderpack name in the description/message
-You are allowed to use this shaderpack in monetized videos if you respect the rule above.


Minecraft website:
-The download link must redirect to the link given in the shaderpack's official thread
-You are not allowed to add any monetizing link to the shaderpack download

If you are not sure about what you are allowed to do or not, PM Chocapic13 on http://www.minecraftforum.net/
Not respecting these rules can and will result in a request of thread/download shutdown to the host/administrator, with or without warning. Intellectual property stealing is punished by law.











*/

#define VIGNETTE_STRENGTH 1. 
#define VIGNETTE_START 0.3	//distance from the center of the screen where the vignette effect start (0-1)
#define VIGNETTE_END 0.95		//distance from the center of the screen where the vignette effect end (0-1), bigger than VIGNETTE_START

	#define SHADOW_MAP_BIAS 0.8
#define UNDERWATERFIX //fixes shadows and other stuff underwater
/*--------------------------------*/
in vec2 texcoord;
in float tempSample;
in float mulfov;

uniform sampler2D colortex4;
uniform sampler2D gaux4;
uniform sampler2D depthtex1;


const int 		noiseTextureResolution  = 128;
uniform vec3 cameraPosition;

uniform vec3 previousCameraPosition;
uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferPreviousProjection;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;
uniform mat4 shadowModelView;
uniform mat4 shadowProjection;
uniform mat4 gbufferPreviousModelView;
uniform ivec2 eyeBrightnessSmooth;
uniform ivec2 eyeBrightness;
uniform int isEyeInWater;
uniform int worldTime;
uniform float aspectRatio;
uniform float near;
uniform float far;
uniform int frameCounter;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float wetness;
uniform float frameTimeCounter;
uniform int fogMode;
uniform int heldBlockLightValue;
uniform float blindness;
uniform float nightVision;

float comp = 1.0-near/far/far;			//distance above that are considered as sky
float invRain06 = 1.0-rainStrength*0.6;

		float distratio(vec2 pos, vec2 pos2) {
	
		return distance(pos*vec2(aspectRatio,1.0),pos2*vec2(aspectRatio,1.0));
	}
float smStep (float edge0,float edge1,float x) {
float t = clamp((x - edge0) / (edge1 - edge0), 0.0, 1.0);
return t * t * (3.0 - 2.0 * t); }

float nrand( vec2 n )
{
	return fract(sin(dot(n.xy, vec2(12.9898, 78.233)))* 43758.5453);
}
float triangWhiteNoise( vec2 n )
{
	//uses white noise for color dithering : gives a somewhat more "filmic" look when noise is visible
	float t = fract( frameTimeCounter );
	float rnd = nrand( n + 0.07*t );

    float center = rnd*2.0-1.0;
    rnd = center*inversesqrt(abs(center));
    rnd = max(-1.0,rnd); 
    return rnd-sign(center);
}
float w0(float a)
{
    return (1.0/6.0)*(a*(a*(-a + 3.0) - 3.0) + 1.0);
}

float w1(float a)
{
    return (1.0/6.0)*(a*a*(3.0*a - 6.0) + 4.0);
}

float w2(float a)
{
    return (1.0/6.0)*(a*(a*(-3.0*a + 3.0) + 3.0) + 1.0);
}

float w3(float a)
{
    return (1.0/6.0)*(a*a*a);
}

float g0(float a)
{
    return w0(a) + w1(a);
}

float g1(float a)
{
    return w2(a) + w3(a);
}

float h0(float a)
{
    return -1.0 + w1(a) / (w0(a) + w1(a));
}

float h1(float a)
{
    return 1.0 + w3(a) / (w2(a) + w3(a));
}

vec4 texture2D_bicubic(sampler2D tex, vec2 uv)
{
	vec4 texelSize = vec4(1.0/vec2(viewWidth,viewHeight),viewWidth,viewHeight);
	
	uv = uv*texelSize.zw;
	vec2 iuv = floor( uv );
	vec2 fuv = fract( uv );

    float g0x = g0(fuv.x);
    float g1x = g1(fuv.x);
    float h0x = h0(fuv.x);
    float h1x = h1(fuv.x);
    float h0y = h0(fuv.y);
    float h1y = h1(fuv.y);

	vec2 p0 = (vec2(iuv.x + h0x, iuv.y + h0y) - 0.5) * texelSize.xy;
	vec2 p1 = (vec2(iuv.x + h1x, iuv.y + h0y) - 0.5) * texelSize.xy;
	vec2 p2 = (vec2(iuv.x + h0x, iuv.y + h1y) - 0.5) * texelSize.xy;
	vec2 p3 = (vec2(iuv.x + h1x, iuv.y + h1y) - 0.5) * texelSize.xy;
	
    return g0(fuv.y) * (g0x * texture2D(tex, p0)  +
                        g1x * texture2D(tex, p1)) +
           g1(fuv.y) * (g0x * texture2D(tex, p2)  +
                        g1x * texture2D(tex, p3));
}
vec3 ACESFilm( vec3 x )
{
    float a = 2.51f;
    float b = 0.03f;
    float c = 2.43f;
    float d = 0.59f;
    float e = 0.14f;
	vec3 r = (x*(a*x+b))/(x*(c*x+d)+e);

    return pow(r,vec3(1.0/2.2));
}
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
void main() {
	
		float luminance = texelFetch(colortex4,ivec2(0),0).x;
	vec3 color = texture2D(colortex4,texcoord).rgb/10.;
	vec2 recipres = vec2(1.0f / viewWidth, 1.0f / viewHeight);
	vec2 bloomcoord = texcoord.xy;
	const float bpow = 0.5;

		

	vec2 coord = texcoord;
	coord.x = coord.x*2896./4944.;
	vec3 dirtyLens = pow(texture2D(depthtex1,coord).rgb,vec3(2.2))*10.;
	
	vec3 blur1 = texture2D_bicubic(gaux4,bloomcoord/pow(2.0,2.0) + vec2(0.0,0.0)).rgb*6.;
	vec3 blur2 = texture2D_bicubic(gaux4,bloomcoord/pow(2.0,3.0) + vec2(0.3,0.0)).rgb*5.;
	vec3 blur3 = texture2D_bicubic(gaux4,bloomcoord/pow(2.0,4.0) + vec2(0.0,0.3)).rgb*4.;
	vec3 blur4 = texture2D_bicubic(gaux4,bloomcoord/pow(2.0,5.0) + vec2(0.1,0.3)).rgb*3.;
	vec3 blur5 = texture2D_bicubic(gaux4,bloomcoord/pow(2.0,6.0) + vec2(0.2,0.3)).rgb*2.;
	vec3 blur6 = texture2D_bicubic(gaux4,bloomcoord/pow(2.0,7.0) + vec2(0.3,0.3)).rgb*1.;
	
	float rainMul = 1.0 + rainStrength*7.;
	
	vec3 blur = blur1*rainMul + blur2*(rainMul) + blur3*(rainMul+dirtyLens*1.0) + blur4*(rainMul+dirtyLens*2.0) + blur5*(rainMul+dirtyLens*3.0) + blur6*(rainMul+dirtyLens*4.0);
	

	color += texture2D(gaux4,texcoord.xy*0.5+0.5+1.0/vec2(viewWidth,viewHeight)).rgb*2.7*(1.+dirtyLens*2.+luminance*3.)/220.;


	color = mix(color,blur2*2.,blindness*0.98)*(1.0-blindness*0.7);

	color += blur*2./7000.;
		color /= luminance;	

	float len = length(texcoord.xy-vec2(.5));
	float len2 = distratio(texcoord.xy,vec2(.5));

	float dc = mix(len,len2,0.1);
    float vignette = smStep(VIGNETTE_END, VIGNETTE_START,  dc);
	float vignetteC = pow(vignette,1.0);

	
	color = color*vignetteC;

	color = mix(color,vec3(0.0),pow(dirtyLens,vec3(0.4))*0.4*pow(1.0-vignetteC,0.4));


	color *= vec3(1.78,1.75,1.8)/6.7;

	color = ACESFilm(color);

	/* DRAWBUFFERS:0 */
    gl_FragData[0] = vec4(color+triangWhiteNoise(texcoord)/256.,1.);





}
