#version 120

/*
AirLoocke42’ shaders, Derived From Chocapic13 v4.4 Beta
Place two leading Slashes in front of the following '#define' lines in order to disable an option.
*/

#define MAX_COLOR_RANGE 16.0

#define GODRAYS
	const float exposure = 5.0;	
	const float density = 0.25;			
	const int NUM_SAMPLES = 8;		
	const float grnoise = 0.0;		
	
#define WATER_REFLECTIONS			
	#define REFLECTION_STRENGTH 1.0

#define RAIN_REFLECTIONS

//- Reflection Algorithm, Do Not Modify -//

const int maxf = 5;				
const float stp = 1.0;			
const float ref = 0.12;			
const float inc = 1.6;			

//- Reflection Algorithm, Do Not Modify -//

varying vec4 texcoord;
varying vec3 sunlight;
varying vec3 lightVector;
varying vec3 ambient_color;

uniform sampler2D composite;
uniform sampler2D gaux4;
uniform sampler2D gaux1;
uniform sampler2D depthtex0;
uniform sampler2D depthtex1;
uniform sampler2D gnormal;
uniform sampler2D gdepth;

uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform vec3 upPosition;
uniform vec3 cameraPosition;
uniform vec3 skyColor;
uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform int isEyeInWater;
uniform int worldTime;
uniform float far;
uniform float near;
uniform float aspectRatio;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float wetness;
uniform float frameTimeCounter;

uniform int fogMode;

float pw = 1.0/ viewWidth;
float ph = 1.0/ viewHeight;

    float matflag = texture2D(gaux1,texcoord.xy).g;
	
    vec3 fragpos = vec3(texcoord.st, texture2D(depthtex0, texcoord.st).r);
    vec3 normal = texture2D(gnormal, texcoord.st).rgb * 2.0 - 1.0;
	
    float sky_lightmap = texture2D(gaux1,texcoord.xy).r;
	
    float iswet = wetness*pow(sky_lightmap,5.0)*sqrt(0.5+max(dot(normal,normalize(upPosition)),0.0));	

    vec4 color = texture2D(composite,texcoord.xy)*16.0;
	
	float time = float(worldTime);
	float transition_fading = 1.0-(clamp((time-12000.0)/300.0,0.0,1.0)-clamp((time-13000.0)/300.0,0.0,1.0) + clamp((time-22800.0)/200.0,0.0,1.0)-clamp((time-23400.0)/200.0,0.0,1.0));
	float night = clamp((time-12000.0)/300.0,0.0,1.0)-clamp((time-22800.0)/200.0,0.0,1.0);

float mat(float n) { return fract(sin(n)*43758.5453); }

float noise(vec2 x){
      vec2 p = floor(x);
      vec2 f = fract(x); 

      float iRes = 32.0;
      float n = p.x + p.y* iRes;

    return mix(mix(mat(n-1.0), mat(n),f.x), mix(mat(n+(iRes-1.0)), mat(n+iRes),f.x),f.y);
}

float getCNoise(vec4 fragpos, float x, float y, float z) {

	vec4 wrldpos = gbufferModelViewInverse * fragpos / far * 2048;

	float common = (wrldpos.y + length(wrldpos.y))/100, t = frameTimeCounter;  
	float f = 0.25, frq = 1.0, ap = 0.5;

	vec2 wind = vec2(t/5.0)/(x+2.0), camPos = (wrldpos.xz*z*0.5/wrldpos.y);
	vec2 pos = -1+16*(camPos + wind/y); pos /= x/y;

 	f += noise((pos*frq))*ap, frq *= 2.1, ap *= 0.5;
	f += noise((pos*frq))*ap, frq *= 2.1, ap *= 0.5;
	f += noise((pos*frq))*ap, frq *= 2.1, ap *= 0.5;
	f += noise((pos*frq))*ap, frq *= 2.1, ap *= 0.5;

	f += sin(pos.x + t)*0.025; f += sin(pos.y + t)*0.025;

	f /= 0.72; float tex = f, b = 0.875, c = tex - (b+0.2);
	if(c <= 0) c = 0; tex = ((1.0 - pow(b, c))*common);

	float getCNoise = tex * (1-rainStrength);

    return getCNoise;
}

float ld(float depth) {
    return (2.0 * near) / (far + near - depth * (far - near));
}

vec3 nvec3(vec4 pos) {
    return pos.xyz/pos.w;
}

vec4 nvec4(vec3 pos) {
    return vec4(pos.xyz, 1.0);
}

float cdist(vec2 coord) {
	return max(abs(coord.s-0.5), abs(coord.t-0.5))*2.0;
}

float luma(vec3 color) {
return dot(color.rgb,vec3(0.299, 0.587, 0.114));
}

vec4 raytrace(vec3 fragpos, vec3 normal, float map) {
    vec4 color = vec4(0.0);
    vec3 start = fragpos;
    vec3 rvector = normalize(reflect(normalize(fragpos), normalize(normal)));
    vec3 vector = stp * rvector;
    vec3 oldpos = fragpos;

    fragpos += vector;
	vec3 tvector = vector;
    int sr = 0;

    for(int i = 0; i < 30; i++){

        vec3 pos = nvec3(gbufferProjection * nvec4(fragpos)) * 0.5 + 0.5;

        if(pos.x < 0 || pos.x > 1 || pos.y < 0 || pos.y > 1 || pos.z < 0 || pos.z > 1.0) break;
        vec3 spos = vec3(pos.st, texture2D(depthtex1, pos.st).r);
        spos = nvec3(gbufferProjectionInverse * nvec4(spos * 2.0 - 1.0));

	if(abs(fragpos.z-spos.z) < pow(length(vector)*map,1.15)){

		sr++;
                if(sr >= maxf){
                    float border = clamp(1.0 - pow(cdist(pos.st), 5.0), 0.0, 1.0);
                    color = texture2D(composite, pos.st);;
					color.a = 1.0;
                    color.a *= border;
                    break;
                }

		tvector -=vector;
	vector *=ref;
	}
        vector *= inc;
        oldpos = fragpos;
        tvector += vector;
		fragpos = start + tvector;
    }
    return color;
}

float getnoise(vec2 pos) {
return abs(fract(sin(dot(pos ,vec2(18.9898f,28.633f))) * 4378.5453f));

}

void main() {
	int land = int(matflag < 0.03);
	int iswater = int(matflag > 0.04 && matflag < 0.07);
	int hand  = int(matflag > 0.75 && matflag < 0.85);
	
	fragpos = nvec3(gbufferProjectionInverse * nvec4(fragpos * 2.0 - 1.0));

	vec3 reflectedVector = reflect(normalize(fragpos), normalize(normal));
	reflectedVector = fragpos + reflectedVector * (far-fragpos.z);

	float normalDotEye = dot(normal, normalize(fragpos));
	float fresnel = clamp(pow(1.0 + normalDotEye, 5.0),0.0,1.0)*0.95 + (1-0.95);
	vec4 reflection = vec4(0.0), fpos = vec4(reflectedVector, 1.0);
	vec4 wrldpos = vec4(0.0);
	
	wrldpos = gbufferModelViewInverse * fpos;	
	wrldpos = wrldpos / far * 128.0;

        float horizon = abs(wrldpos.y - texcoord.y);

	float skyPos = max(pow(max(1.0 - horizon/3500.0, 0.01), 8.0)-0.1, 0.0);
	      skyPos = clamp(skyPos, 0.35, 1.0);

	float vista = max(pow(max(1.0 - horizon/500.0, 0.01), 8.0)-0.1, 0.0);

	vec3 skyGradient = ((ambient_color*16 + sunlight*8)/16.0);

	vec3 skyC = vec3(0.15, 0.4, 0.8) * (1.4 + 1.0*night) * (1.0-rainStrength);
	     skyC += vec3(1.6) * rainStrength * (1.0-night);
	     skyC += vec3(0.1) * rainStrength * night;

	vec3 sunC = sunlight * (1.0-night);
	     sunC += vec3(0.15, 0.6, 1.0) * 10.0 * night;

	skyC += (sunlight * getCNoise(fpos, 24, 2.0, 2));
	skyC += (sunlight * getCNoise(fpos, 8., 1.1, 2));

	skyC = skyGradient * skyPos * skyC;
	skyC = mix(skyC, skyGradient * 0.3, vista);
		
	if (iswater > 0.9 && isEyeInWater == 0) {
	#ifdef WATER_REFLECTIONS
	reflection = raytrace(fragpos, normal, 1.1)*16.0;
	#endif

	reflection.rgb = mix(skyC*4.0, reflection.rgb, reflection.a/16.0);	
	reflection.a = min(reflection.a/16.0 + sky_lightmap,1.0);

	color.rgb += reflection.rgb*fresnel*REFLECTION_STRENGTH*reflection.a;
	color.rgb += (color.a/16.0)*sunlight*(1-rainStrength)*8.0;
	}

	#ifdef RAIN_REFLECTIONS
	if (rainStrength == 1 && iswet > 0.9) {
	reflection = raytrace(fragpos, normal, 0.99)*16.0;
	color.rgb += ((reflection.rgb/16.0)*fresnel*reflection.a);
	}
	#endif
	
	vec3 colmult = mix(vec3(1.0),vec3(0.1,0.25,0.45),isEyeInWater);
	float depth_diff = clamp(pow(ld(texture2D(depthtex0, texcoord.st).r)*3.4,2.0),0.0,1.0);

	color.rgb = mix(color.rgb*colmult,vec3(0.05,0.1,0.15),depth_diff*isEyeInWater);

	float volumetric_cone = max(dot(normalize(fragpos),lightVector),0.0)*transition_fading;

	float fog = exp(-pow(length(fragpos)/160.0,4.0-(1.0*rainStrength))*8.0);
	float fogfactor =  clamp(fog+hand+isEyeInWater,0.0,1.0);
	float rain = rainStrength;

	vec3 fogclr = mix(color.rgb, ambient_color*(1.0-night*rain), 0.2);
	     fogclr += vec3(0.01, 0.02, 0.05)*rain*night; 

	color.rgb = mix(fogclr, color.rgb, fogfactor);	
		
/* DRAWBUFFERS:5 */
	
	vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
	tpos = vec4(tpos.xyz/tpos.w,1.0);
	vec2 pos1 = tpos.xy/tpos.z;
	vec2 lightPos = pos1*0.5+0.5;

	float truepos = pow(clamp(dot(-lightVector,tpos.xyz)/length(tpos.xyz),0.0,1.0),0.25);

	#ifdef GODRAYS
	if (truepos > 0.05) {
	vec2 deltaTextCoord = vec2( texcoord.st - lightPos.xy );
    	vec2 textCoord = texcoord.st;
    	deltaTextCoord *= 1.0 /  float(NUM_SAMPLES) * density;
    	float illuminationDecay = 1.0;
	vec2 noise = vec2(getnoise(textCoord),getnoise(-textCoord.yx+0.05));
	float gr = 0.0;
	float avgdecay = 0.0;
	float distx = abs(texcoord.x*aspectRatio-lightPos.x*aspectRatio);
	float disty = abs(texcoord.y-lightPos.y);
        illuminationDecay = pow(max(1.0-sqrt(distx*distx+disty*disty),0.0),5.0);
    	for(int i=0; i < NUM_SAMPLES ; i++) {
            textCoord -= deltaTextCoord;
        float sample = texture2D(gdepth, textCoord + noise*grnoise).r;
		gr += sample;
    	}
	color.rgb += mix(sunlight,fogclr,rainStrength*0.6)*exposure*(gr/NUM_SAMPLES)*(1.0 - rainStrength*0.9)*illuminationDecay*truepos*transition_fading;
	}

	#endif
	
	float visiblesun = 0.0, nb = 0, temp;

	if (texcoord.x < pw && texcoord.x < ph) {
	for (int i = 0; i < 10;i++) {
		for (int j = 0; j < 10 ;j++) {
		temp = texture2D(gaux1,lightPos + vec2(pw*(i-5.0),ph*(j-5.0))*10.0).g;
		visiblesun +=  1.0-float(temp > 0.04) ;
		nb += 1.0;
		}
	}
	visiblesun /= nb;

	}
	color = clamp(color/MAX_COLOR_RANGE,0.0,1.0);

	gl_FragData[0] = vec4(color.rgb,visiblesun);
	
}