#version 120

/*
Modified Chocapic13 Shader Lite By Airloocke42
*/

#extension GL_ARB_shader_texture_lod : enable 

/* DRAWBUFFERS:0246 */


#define MIX_TEX	0.7	
vec4 watercolor = vec4(0.1,0.2,0.25,0.9); 

const int MAX_OCCLUSION_POINTS = 20;
const float MAX_OCCLUSION_DISTANCE = 100.0;

const float bump_distance = 64.0;		
const float pom_distance = 32.0;		
const float fademult = 0.1;
const float PI = 3.1415927;

varying vec4 color;
varying vec4 texcoord;
varying vec4 lmcoord;
varying vec4 position;
varying vec3 binormal;
varying vec3 normal;
varying vec3 tangent;
varying vec3 viewVector;
varying vec3 wpos;
varying float iswater;

uniform sampler2D texture;
uniform sampler2D noisetex;
uniform int worldTime;
uniform float far;
uniform float rainStrength;
uniform float frameTimeCounter;
uniform vec3 cameraPosition;

float rainx = clamp(rainStrength, 0.0f, 1.0f)/1.0f;

vec2 dx = dFdx(texcoord.xy);
vec2 dy = dFdy(texcoord.xy);

float wave(float n) {
return sin(2 * PI * (n));
}

float waterH(vec3 posxz) {

      float time = frameTimeCounter / 50.0;
      vec2 coord = fract(posxz.xz / 50.0);

      float noise = texture2D(noisetex, coord*2.0 + time).x;
      noise += texture2D(noisetex, coord*4.0 + time).x/2.0;
      noise += texture2D(noisetex, coord*2.0 - time).x;
      noise += texture2D(noisetex, coord*4.0 - time).x/2.0;

      return noise;
}

void main() {	
	
	vec4 tex = vec4((watercolor*length(texture2D(texture, texcoord.xy).rgb*color.rgb)*color).rgb,watercolor.a);
	if (iswater < 0.9)  tex = texture2D(texture, texcoord.xy)*color;
	
	vec3 posxz = wpos.xyz;

	posxz.x += sin(posxz.z+frameTimeCounter)*0.25;
	posxz.z += cos(posxz.x+frameTimeCounter*0.5)*0.25;
	
	float deltaPos = 0.4;
	float h0 = waterH(posxz);
	float h1 = waterH(posxz + vec3(deltaPos,0.0,0.0));
	float h2 = waterH(posxz + vec3(-deltaPos,0.0,0.0));
	float h3 = waterH(posxz + vec3(0.0,0.0,deltaPos));
	float h4 = waterH(posxz + vec3(0.0,0.0,-deltaPos));
	
	float xDelta = ((h1-h0)+(h0-h2))/deltaPos;
	float yDelta = ((h3-h0)+(h0-h4))/deltaPos;
	
	vec3 newnormal = normalize(vec3(xDelta,yDelta,1.0-xDelta*xDelta-yDelta*yDelta));

	vec4 frag2 = vec4((normal) * 0.5f + 0.5f, 1.0f);
			
	float NdotE = pow(abs(dot(normal,normalize(position.xyz))),2.0);

	if (iswater > 0.9) {
		vec3 bump = newnormal*0.5 + newnormal*0.5;
			bump = bump;
			
		
		float bumpmult = 0.025;	
		
		bump = bump * vec3(bumpmult, bumpmult, bumpmult) + vec3(0.0f, 0.0f, 1.0f - bumpmult);
		mat3 tbnMatrix = mat3(tangent.x, binormal.x, normal.x, tangent.y, binormal.y, normal.y, tangent.z, binormal.z, normal.z);
		
		frag2 = vec4(normalize(bump * tbnMatrix) * 0.5 + 0.5, 1.0);
	}
	gl_FragData[0] = tex;

	gl_FragData[1] = frag2;	
	
	gl_FragData[2] = vec4(lmcoord.t, mix(1.0,0.05,iswater), lmcoord.s, 1.0);

	gl_FragData[3] = vec4(vec3(0.0), 1.0);
}