#version 120

varying vec2 texcoord;
varying vec2 lightPos;
varying float avgLuma;
varying vec3 lightColor;
varying float sunVisibility;
varying float Vis;

uniform vec3 skyColor;
uniform vec3 sunPosition;
uniform vec3 upPosition;
uniform int worldTime;
uniform int heldItemId;
uniform int heldBlockLightValue;
uniform float rainStrength;
uniform float wetness;
uniform ivec2 eyeBrightnessSmooth;
uniform float frameTimeCounter;
uniform sampler2D colortex4;
uniform sampler2D depthtex0;
uniform float viewWidth;
uniform float viewHeight;
uniform float near;
uniform float far;
uniform vec3 cameraPosition;
uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;
uniform mat4 shadowProjection;
uniform mat4 shadowModelView;
float comp = 1.0-near/far/far;	
#include "ToD.glsl"
float luma(vec3 color) {
	return sqrt(dot(color*color,vec3(0.299, 0.587, 0.114)));
}
void main() {
	vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
	tpos = vec4(tpos.xyz/tpos.w,1.0);
	vec2 pos1 = tpos.xy/tpos.z;
	lightPos = pos1*0.5+0.5;


	/*--------------------------------*/
	gl_Position = ftransform();
	texcoord = (gl_MultiTexCoord0).xy;
	/*--------------------------------*/

	/*--------------------------------*/
	vec3 sunVec = normalize(sunPosition);
	vec3 moonVec = normalize(-sunPosition);
	vec3 upVec = normalize(upPosition);
	
	float SdotU = dot(sunVec,upVec);
	float MdotU = dot(moonVec,upVec);
	sunVisibility = pow(clamp(SdotU+0.15,0.0,0.3)/0.3,4.4);
	float moonVisibility = pow(clamp(MdotU+0.15,0.0,0.3)/0.3,4.4);
	/*--------------------------------*/
	
	float truepos = sign(sunPosition.z)*1.0;		//1 -> sun / -1 -> moon
	

	

	avgLuma = 0.0;

	float n = 0.0;
	

	
	
	for (int i = -5; i < 6;i++) {
		for (int j = -5; j < 6 ;j++) {
		vec2 ij = vec2(i,j);
		float temp = texture2D(depthtex0,lightPos + sign(ij)*sqrt(abs(ij))*vec2(0.007)).x;
		Vis += step(comp,temp);
		}
	}
	Vis /= 11*11.;
	
	
	
	
	vec3 sunlight = sunlightColor(SdotU)*sunIntensity(SdotU);
	lightColor = mix(sunlight,moonlight*moonIntensity(SdotU)/10.,(truepos+1.0)/2.);
}