#include "ToD.glsl"	
#define MOONLIGHT_MULTIPLIER 1.0 // [0.0 0.25 0.5 0.75 1.0 1.25 1.5 1.75 2.]
#define MIN_LIGHT 1.0 // [0.0 0.25 0.5 0.75 1.0 1.25 1.5 1.75 2.0 3.0 4.0 5.0] 
uniform ivec2 eyeBrightnessSmooth;
uniform float nightVision;
//hardcoded lighting model, could be stored into texture
vec3 lightColor(in vec2 lmcoord, in vec3 normal, in vec3 sunVec, in vec3 moonVec, in vec3 upVec, in bool mat, in float moonMul){
	float SdotU = dot(sunVec,upVec);
	float sunInt = sunIntensity(SdotU);
	float moonInt = moonIntensity(SdotU);
	
	vec3 sunlight =  sunlightColorRain(sunlightColor(SdotU),rainStrength);

	float skyL = lmcoord.t*1.03225806452-0.5/16.0*1.03225806452;
	float skyL2 = skyL*skyL;
	
	float torch_lightmap = 16.0-min(15.,(lmcoord.s-0.5/16.)*16.*16./15);
	float fallof1 = clamp(1.0 - pow(torch_lightmap/16.0,4.0),0.0,1.0);
	torch_lightmap = fallof1*fallof1/(torch_lightmap*torch_lightmap+1.0);

	float NdotL = dot(normal,sunVec);
	float NdotU = dot(normal,upVec);

	float upLight = sqrt(NdotU*0.1*0.7+0.35*0.7);
	float coef = pow(NdotL*0.4+0.6,3.)+upLight;
	coef = (mat ? abs(dot(sunVec,upVec))*0.3+NdotL*0.3+0.9 : coef);
	vec3 dayLight = sunlight*coef*skyL2*1.8 + mix(vec3(0.1,0.2,0.5),vec3(0.23),rainStrength)*0.35;
	
	float coefNight = pow(-NdotL*0.4+0.6,3.)+upLight;
	coefNight = (mat ? abs(dot(-sunVec,upVec))*0.3-NdotL*0.3+0.9 : coefNight);	
	vec3 nightLight = moonlight*mix(coefNight,0.5,rainStrength)*skyL2*1.8 ;
	
	float torchMul = max(1.0-eyeBrightnessSmooth.y/255.,1.0-sunInt/1.77);
	
	return (dayLight*skyL*sunInt + nightLight*skyL*moonInt*0.075*MOONLIGHT_MULTIPLIER*(1.0+nightVision) + 0.001*MIN_LIGHT  + 0.01*nightVision + torch_lightmap*vec3(1.1,0.42,0.045)/vec3(1.1,1.25,1.25)*8.*torchMul+0.001)*vec3(1.1,1.25,1.25);

}