#define DRAW_SUN //if not using custom sky


vec3 drawSun(float cosY, float sunInt){
	#ifdef DRAW_SUN
	return (clamp(cosY/0.0005-0.999/0.0005,0.,1.)*1000.*sunInt)*nsunlight*(1.0-rainStrength*0.992);
	#endif
	#ifndef DRAW_SUN
	return vec3(0.);
	#endif
}

vec3 getFogColor(vec3 sVector,float cosT) {
	float mCosT = clamp(cosT,0.0,1.);
	float absCosT = 1.0-max(cosT*0.82+0.26,0.2);
	float cosY = dot(sunVec,sVector);
	float Y = fastAcos(cosY);


	//gradient
	vec3 grad1 = mix(sky1,sky2,absCosT*absCosT);
	float sunscat = clamp(cosY,0.0,1.0);
	vec3 grad3 = mix(grad1,nsunlight,(sunscat*sunscat)*(sunscat*(0.7-mCosT*0.7)));


	return grad3;
}

vec3 getSkyColor(vec3 sVector, float sunInt,float moonInt,float cosT) {
	const vec3 moonlight = vec3(0.8, 1.1, 1.4) * 0.06;

	float mCosT = clamp(cosT,0.0,1.);
	float absCosT = 1.0-max(cosT*0.82+0.26,0.2);
	float cosY = clamp(dot(sunVec,sVector),-1,1.);
	float Y = fastAcos(cosY);

	const float a = -1.;
	const float b = -0.32;
	const float c = 10.0;
	const float d = -3.0;
	const float e = 0.45;

	//luminance (cie model)
	float L0 = (1.0+a*exp(b/mCosT))*(1.0+c*(exp(d*Y)-exp(d*3.1415/2.))+e*cosY*cosY);

	//gradient
	vec3 grad3 = getFogColor(sVector,cosT);

	cosY = -cosY;
	Y = PI - Y;
	const float c2 = 5.0;
	float L0Moon = (1.0+a*exp(b/mCosT))*(1.0+c2*(exp(d*Y)-exp(d*3.1415/2.))+e*cosY*cosY);

	return grad3*(pow(L0,1.0-rainStrength*0.5)/dot(grad3,vec3(1./2.7))*sunInt) + drawSun(-cosY,sunInt) + pow(L0Moon,1.0-rainStrength*0.5)*moonlight*moonInt*0.4*(1.0+rainStrength*0.5);

}


vec3 drawStars(vec3 pos){
	float elevation = clamp(pos.y,0.,1.);
	vec2 uv = pos.xz/pos.y*sqrt(elevation)*2.;
	float noise  = texture2D(noisetex, uv).x;

	
	return max(noise-0.975,0.)*vec3(1.)*elevation*(1.0 - rainStrength*0.999999);
}

vec3 calcAtmFog(in vec3 fogClr,in vec3 fposition,in vec3 color, float sunInt,float moonInt){

	float SdotL = dot(normalize(fposition),sunVec);
	float d = (length(fposition)*tmult)*(tmult*tmult);
	float fogFactorIn = exp(-d/500.*0.6);
	
	fogClr = normalize(pow(fogClr,vec3(1.-fogFactorIn*0.25)))*mix(1.0+exp(SdotL)*1.2+SdotL*SdotL,8.0,rainStrength*0.1)*sunInt*(1.-rainStrength*0.6);
	fogClr += vec3(0.8, 1.1, 1.4)*(1.0+SdotL*SdotL)*moonInt/25./vec3(1.3,1.15,1.)*(1.-rainStrength*0.5);
	
	
	return mix(fogClr*pow(eyeBrightnessSmooth.y/255.,0.2),color,fogFactorIn);
}