//Water Render Part Version v2.5

//This file is part of Basic Shader.
//Read LICENSE First at composite.fsh

//Water Properties

const mat2 octave_m = mat2(0.7, -1.55,  1.55,  0.7);

const float height_mul[5] = float[5] (
	0.52, 0.34, 0.20, 0.22, 0.16
);
const float total_height =
  height_mul[0] + height_mul[1] + height_mul[2] + height_mul[3] + height_mul[4];
const float rcp_total_height = 1.0 / total_height;

#define SEA_HEIGHT 0.43 

const float SEA_CHOPPY = 4.0;
const float SEA_SPEED = 0.78;
const float SEA_FREQ = 0.18;
const int ITER_GEOMETRY = 3;

vec2 cube(in vec2 x) {
	return x * x * (3.0 - 2.0 * x);
}

vec2 SmoothNoiseCoord(in vec2 coord) { 
	coord *= 64;
	coord  = floor(coord) + cube(fract(coord)) + 0.5;
	coord /= 64;	
	return coord;
}

float SharpenWave(in float wave) {
	wave = 1.0 - abs(wave * 2.0 - 1.0);
	if (wave > 0.78) wave = 5.0 * wave - wave * wave * 2.5 - 1.6;
	return wave;
}

float sea_octave_micro(vec2 uv, float choppy) {
    uv *= 6.0f;
	uv += hashmix(SmoothNoiseCoord(uv));
	vec2 wv = 1.0-abs(sin(uv));
	vec2 swv = abs(cos(uv));
	wv = mix(wv,swv,wv);
	return pow(1.0-pow(wv.x * wv.y,0.75),choppy);
}

float doWave(vec3 p, in float lod) {

	float freq = SEA_FREQ;
	float amp = SEA_HEIGHT;
	float choppy = SEA_CHOPPY;
	vec2 uv = p.xz ; 
		 uv.x *= 0.75;
		 p.y += frameTimeCounter * 0.1;
		 uv += cos(p.y) * cos(p.y * 2) * sin(p.y * 8) * cos(p.y * 15) * 0.6;

	float wave_speed = frameTimeCounter * SEA_SPEED;

	float d, h = 0.0;
	for(int i = 0; i < ITER_GEOMETRY; i++) {
		d = sea_octave_micro((uv+wave_speed)*freq,choppy);
		h += d * amp;
		uv *= octave_m; freq *= 1.9; amp *= height_mul[i]; wave_speed *= -1.3;
		choppy = mix(choppy,1.0,0.2);
	}

	return SharpenWave((h * rcp_total_height - SEA_HEIGHT)) * lod / 1.5f;
	
}