#version 120
#extension GL_EXT_gpu_shader4 : enable

varying vec2 texcoord;

uniform sampler2D depthtex0;
uniform sampler2D colortex1;

uniform vec3 nsunColor;

uniform vec3 sunPosition;
uniform float skyIntensity;
uniform float skyIntensityNight;
uniform float fogAmount;
uniform float rainStrength;
uniform ivec2 eyeBrightnessSmooth;
uniform float frameTimeCounter;

#include "lib/color_transforms.glsl"
#include "lib/color_dither.glsl"
#include "lib/projections.glsl"
vec3 sunVec = normalize(mat3(gbufferModelViewInverse) *sunPosition);
#include "lib/sky_gradient.glsl"

#define fsign(a)  (clamp((a)*1e35,0.,1.)*2.-1.)
float triangularize(float dither)
{
    float center = dither*2.0-1.0;
    dither = center*inversesqrt(abs(center));
    dither = max(-1.0,dither); 
    return dither-fsign(center);
}
vec3 fp10Dither(vec3 color,float dither){
	const vec3 mantissaBits = vec3(6.,6.,5.);
	vec3 exponent = floor(log2(color));
	return color + dither*exp2(-mantissaBits)*exp2(exponent);
}
float interleaved_gradientNoise(){
	return fract(52.9829189*fract(0.06711056*gl_FragCoord.x + 0.00583715*gl_FragCoord.y));
}
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////

void main() {
/* DRAWBUFFERS:1 */
	vec3 color = texture2D(colortex1,texcoord).rgb;
		
	float z = texture2D(depthtex0,texcoord).x;
	if (z < 1.0){

		vec3 fragpos = toScreenSpace(vec3(texcoord,z));
		float dist = length(fragpos);
		vec3 np3 = mat3(gbufferModelViewInverse) * (fragpos/(dist));
		vec3 skyColor = getSkyColor(np3,1.,1.,np3.y) ;

		float fogFactorAbs = exp(-dist*fogAmount*0.3);
		float fogFactorScat = exp(-dist*fogAmount*0.8);
		
		vec3 col0 = normalize(skyColor)*(skyIntensity*mix(vec3(1.),vec3(0.8,0.9,1.),rainStrength)+skyIntensityNight*0.01)*2.;
		vec3 fogColor = mix(col0,skyColor,clamp(dist/512.,0.,1.));
		
		color.rgb = fp10Dither(fogColor*(1.0-fogFactorScat)*(eyeBrightnessSmooth.y/255.0)*10.+color*fogFactorAbs,triangularize(interleaved_gradientNoise()));
	
	}

	gl_FragData[0] = vec4(color,1.);


}