#version 120
#extension GL_EXT_gpu_shader4 : enable
#define Exposure_Speed 1.0 //[0.25 0.5 0.75 1.0 1.25 1.5 1.75 2.0 2.25 2.5 2.75 3.0 4.0 5.0]

varying vec2 texcoord;
varying float exposureA;
varying float avgBrightness;


uniform sampler2D colortex3;

uniform float frameTime;
uniform float nightVision;
#define fsign(a)  (clamp((a)*1e35,0.,1.)*2.-1.)
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
float luma(vec3 color) {
	return sqrt(dot(color*color,vec3(0.299, 0.587, 0.114)));
}
//spiral sampling (numbers tweaked for 9 samples)
vec2 tapLocation(int sampleNumber,int nb, float nbRot)
{
    float alpha = float(sampleNumber)/nb;
    float angle = alpha * (nbRot * 6.28);

    float ssR = alpha;
    float sin_v, cos_v;

	sin_v = sin(angle);
	cos_v = cos(angle);
	
    return vec2(cos_v, sin_v)*ssR;
}
void main() {

	gl_Position = ftransform();
	texcoord = gl_MultiTexCoord0.xy;
	float avgLuma = 0.0;
	int n=400;
		
	for (int i = 0;i <n; i++ ){
		vec2 tc = tapLocation(i,n,30.)*0.2+0.5;
		avgLuma += luma(texture2D(colortex3,tc).xyz);

		
	}
	float exposure = avgLuma/n;
	
avgBrightness = clamp(mix(exposure,texelFetch2D(colortex3,ivec2(0),0).g,0.95),0.00003051757,65000.);
float targetExposure = 0.36*pow(avgBrightness,-1.0/(2.2-nightVision*0.6));
float currentExposure = clamp(pow(texelFetch2D(colortex3,ivec2(0),0).r,1.0/3.0),0.03125,3.5*(1.0+nightVision*19.));

float a = 0.05;
float rad = sqrt(currentExposure*a);
float rtarget = sqrt(targetExposure*a);
float dir = sign(rtarget-rad);
float dist = abs(rtarget-rad);
float maxApertureChange=0.0002*frameTime/0.016666*(1.0+dist*dist*20.)*Exposure_Speed;

if (dir>0.0) maxApertureChange *= 1.0+nightVision*20.;
rad = rad+dir*min(dist,maxApertureChange);

float exposureF = clamp(rad*rad/a,0.03125,3.5*(1.0+nightVision*19.));
exposureA=exposureF;
}
