#version 400 compatibility

	const int shadowMapResolution = 4096;		//shadowmap resolution
	const float shadowDistance = 140.0;		//draw distance of shadows

	const float sunPathRotation = -35.0f;
	#define SHADOW_MAP_BIAS 0.8

#define ALBEDO_MULTIPLIER 1.0 //[0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5]

/*






!! DO NOT REMOVE !! !! DO NOT REMOVE !!

This code is from Chocapic13' shaders
Read the terms of modification and sharing before changing something below please !
!! DO NOT REMOVE !! !! DO NOT REMOVE !!


Sharing and modification rules

Sharing a modified version of my shaders:
-You are not allowed to claim any of the code included in "Chocapic13' shaders" as your own
-You can share a modified version of my shaders if you respect the following title scheme : " -Name of the shaderpack- (Chocapic13' Shaders edit) "
-You cannot use any monetizing links
-The rules of modification and sharing have to be same as the one here (copy paste all these rules in your post), you cannot make your own rules
-I have to be clearly credited
-You cannot use any version older than "Chocapic13' Shaders V4" as a base, however you can modify older versions for personal use
-Common sense : if you want a feature from another shaderpack or want to use a piece of code found on the web, make sure the code is open source. In doubt ask the creator.
-Common sense #2 : share your modification only if you think it adds something really useful to the shaderpack(not only 2-3 constants changed)


Special level of permission; with written permission from Chocapic13, if you think your shaderpack is an huge modification from the original (code wise, the look/performance is not taken in account):
-Allows to use monetizing links
-Allows to create your own sharing rules
-Shaderpack name can be chosen
-Listed on Chocapic13' shaders official thread
-Chocapic13 still have to be clearly credited


Using this shaderpack in a video or a picture:
-You are allowed to use this shaderpack for screenshots and videos if you give the shaderpack name in the description/message
-You are allowed to use this shaderpack in monetized videos if you respect the rule above.


Minecraft website:
-The download link must redirect to the link given in the shaderpack's official thread
-You are not allowed to add any monetizing link to the shaderpack download

If you are not sure about what you are allowed to do or not, PM Chocapic13 on http://www.minecraftforum.net/
Not respecting these rules can and will result in a request of thread/download shutdown to the host/administrator, with or without warning. Intellectual property stealing is punished by law.











*/
//#define DISABLE_SSAO_DEPTH_FILTER 	//Keep it disabled unless you are using POM!
#define UNDERWATERFIX //fixes shadows and other stuff underwater
//#define BANDINGFIX //enable this only if you are using minecraft 1.8.9 and lower
#define GODRAYS
		const float density = 0.1;
		const float grnoise = 0.9;			//amount of noise

//////////////////////////////END OF ADJUSTABLE VARIABLES
//////////////////////////////END OF ADJUSTABLE VARIABLES
//////////////////////////////END OF ADJUSTABLE VARIABLES

const int maxf = 3;				//number of refinements
const float stp = 1.5;			//size of one step for raytracing algorithm
const float ref = 0.025;			//refinement multiplier
const float inc = 2.2;			//increasement factor at each step
/*--------------------------------*/
in vec2 texcoord;
in vec3 sunVec;
in vec3 moonVec;
in vec3 upVec;
in float tr;
in float tempSample;
in vec3 sunlight;

in float SdotU;
in float MdotU;
in float sunVisibility;
in float moonVisibility;
in vec3 scatSunlight;

in vec3 ambientUp;
in vec3 ambientLeft;
in vec3 ambientRight;
in vec3 ambientB;
in vec3 ambientF;
in vec3 ambientDown;
in vec2 tempOffset;

uniform sampler2D gaux4;
uniform sampler2D gaux1;
uniform sampler2D depthtex2;
uniform sampler2D depthtex0;
uniform sampler2D noisetex;
uniform sampler2D gdepthtex;
uniform sampler2D gcolor;
uniform sampler2D gdepth;
uniform sampler2D gnormal;
uniform sampler2D composite;
uniform sampler2D shadow;


int noiseTextureResolution  = 128;
uniform vec3 cameraPosition;
uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferPreviousProjection;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;
uniform mat4 shadowModelView;
uniform mat4 shadowProjection;
uniform mat4 gbufferPreviousModelView;
uniform ivec2 eyeBrightnessSmooth;
uniform int isEyeInWater;
uniform float near;
uniform float far;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float frameTimeCounter;
uniform int frameCounter;
uniform int worldTime;

const vec3 moonlight = vec3(0.55, 0.9, 1.35) * 0.001;
const vec3 moonlightS =vec3(0.575, 1.05, 1.4) * 0.01;
float comp = 1.0-near/far/far;			//distance above that are considered as sky
float invRain06 = 1.0-rainStrength*0.6;



vec3 decode (vec2 enc)
{
    vec2 fenc = enc*4-2;
    float f = dot(fenc,fenc);
    float g = sqrt(1-f/4.0);
    vec3 n;
    n.xy = fenc*g;
    n.z = 1-f/2;
    return n;
}



vec3 YCoCg2RGB(vec3 c){
		c.y-=0.5;
		c.z-=0.5;
		return vec3(c.r+c.g-c.b, c.r + c.b, c.r - c.g - c.b);
	}

float edge_filter(vec2 center, vec2 a0, vec2 a1, vec2 a2, vec2 a3){
	  const float THRESH=30./255.;

	  vec4 lum = vec4(a0.x, a1.x , a2.x, a3.x);
	  vec4 w = 1.0-step(THRESH, abs(lum - center.x));
	  float W = w.x + w.y + w.z + w.w;
	  //Handle the special case where all the weights are zero.
	  //In HDR scenes it's better to set the chrominance to zero.
	  //Here we just use the chrominance of the first neighbor.
	  w.x = (W==0.0)? 1.0:w.x;  W = (W==0.0)? 1.0:W;

	  return (w.x*a0.y+w.y*a1.y+w.z*a2.y+w.w* a3.y)/W;
}

float ld(float depth) {
    return (2.0 * near) / (far + near - depth * (far - near));		// (-depth * (far - near)) = (2.0 * near)/ld - far - near
}
vec4 ld4(vec4 depth) {
    return (2.0 * near) / (far + near - depth * (far - near));		// (-depth * (far - near)) = (2.0 * near)/ld - far - near
}
vec3 drawSun(vec3 fposition,vec3 color) {
vec3 sVector = normalize(fposition);

float angle = (1.0-max(dot(sVector,sunVec),0.0));
float sun = 1.0-smoothstep(0.0015,0.0024,angle);
sun *= (1.0-rainStrength*0.9925)*sunVisibility;
vec3 sunlightB = mix(pow(sunlight,vec3(1.0))*2.2*120,vec3(0.25,0.3,0.4),rainStrength*0.8);

return mix(color,sunlightB,sun);

}

float interleaved_gradientNoise(){
	vec2 coord = gl_FragCoord.xy;
	float noise = fract(52.9829189*fract(0.06711056*coord.x + 0.00583715*coord.y)+tempSample);
	return noise;
}

vec3 RGB2YCoCg(vec3 c){
		return vec3( 0.25*c.r+0.5*c.g+0.25*c.b, 0.5*c.r-0.5*c.b +0.5, -0.25*c.r+0.5*c.g-0.25*c.b +0.5);
	}
	
	
vec2 tapLocation(int sampleNumber, float spinAngle,int nb, float nbRot)
{
	float startJitter = (spinAngle/6.28);
    float alpha = sqrt(float(sampleNumber*1.0f + startJitter) * (1.0 / (nb+ startJitter)));
    float angle = alpha * (nbRot * 6.28) + spinAngle;

    float ssR = alpha;
    float sin_v, cos_v;

	sin_v = sin(angle);
	cos_v = cos(angle);
	
    return vec2(cos_v, sin_v)*ssR;
}

vec3 fpDither(vec3 color,float dither){
	const vec3 mantissaBits = vec3(6.,6.,5.);
	vec3 exponent = floor(log2(color));
	return color + dither*exp2(-mantissaBits)*exp2(exponent);
}
float BlueNoise(){
	vec2 nTC = mod(gl_FragCoord.xy,32.);
	 return fract(texelFetch(noisetex,ivec2(nTC),0).x+tempSample);
	
}
// earth shadow hack
const float pi = 3.141592653589793238462643383279502884197169;

float RayleighPhase(float cosViewSunAngle)
{
	/*
	Rayleigh phase function.
			   3
	p(θ) =	________   [1 + cos(θ)^2]
			   16π
	*/

	return (3.0 / (16.0*pi)) * (1.0 + pow(max(cosViewSunAngle, 0.0), 2.0));
}

float hgPhase(float cosViewSunAngle, float g)
{

	/*
	Henyey-Greenstein phase function.
			   1		 		1 − g^2 
	p(θ) =	________   ____________________________
			   4π		[1 + g^2 − 2g cos(θ)]^(3/2)
	*/


	return (1.0 / (4.0 * pi)) * ((1.0 - pow(g, 2.0)) / pow(1.0 + pow(g, 2.0) - 2.0*g * cosViewSunAngle, 1.5));
}

vec3 totalMie(vec3 lambda, vec3 K, float T, float v)
{
	float c = (0.2 * T ) * 10E-18;
	return 0.434 * c * pi * pow((2.0 * pi) / lambda, vec3(v - 2.0)) * K;
}

vec3 totalRayleigh(vec3 lambda, float n, float N, float pn){
	return (24.0 * pow(pi, 3.0) * pow(pow(n, 2.0) - 1.0, 2.0) * (6.0 + 3.0 * pn))
	/ (N * pow(lambda, vec3(4.0)) * pow(pow(n, 2.0) + 2.0, 2.0) * (6.0 - 7.0 * pn));
}

float SunIntensity(float zenithAngleCos, float sunIntensity, float cutoffAngle, float steepness)
{
	return sunIntensity * max(0.0, 1.0 - exp(-((cutoffAngle - acos(zenithAngleCos))/steepness)));
}


float calcSun(vec3 fragpos, vec3 sunVec){

	const float sunAngularDiameterCos = 0.99873194915;

	float cosViewSunAngle = dot(normalize(fragpos.rgb), sunVec);
	float sundisk = smoothstep(sunAngularDiameterCos,sunAngularDiameterCos+0.0001,cosViewSunAngle);

	return 1000.0 * sundisk * (1.0 - rainStrength);

}

float calcMoon(vec3 fragpos, vec3 moonVec){

	const float moonAngularDiameterCos = 0.99833194915;

	float cosViewSunAngle = dot(normalize(fragpos.rgb), moonVec);
	float moondisk = smoothstep(moonAngularDiameterCos,moonAngularDiameterCos+0.001,cosViewSunAngle);

	return clamp(4.0 * moondisk, 0.0, 15.0) * (1.0 - rainStrength);

}

vec3 getAtmosphericScattering(vec3 color, vec3 fragpos){

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	float turbidity = 6.;
	float rayleighCoefficient = 2.;

	// constants for mie scattering
	const float mieCoefficient = 0.008;
	const float mieDirectionalG = 0.76;
	const float v = 4.0;

	// Wavelength of the primary colors RGB in nanometers.
	const vec3 primaryWavelengths = vec3(680, 550, 450) * 1.0E-9;
	
	float n = 1.00029; // refractive index of air
	float N = 2.54743E25; // number of molecules per unit volume for air at 288.15K and 1013mb (sea level -45 celsius)
	float pn = 0.035;	// depolarization factor for standard air

	// optical length at zenith for molecules
	float rayleighZenithLength = 8.4E3 ;
	float mieZenithLength = 1.25E3;
	
	const vec3 K = vec3(0.686, 0.678, 0.666);

	float sunIntensity = 1000.0;

	// earth shadow hack
	float cutoffAngle = pi * 0.5128205128205128;
	float steepness = 1.5;

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	// Cos Angles
	float cosViewSunAngle = dot(normalize(fragpos.rgb), sunVec);
	float cosSunUpAngle = dot(sunVec, upVec) * 0.95 + 0.05; //Has a lower offset making it scatter when sun is below the horizon.
	float cosUpViewAngle = dot(upVec, normalize(fragpos.rgb));
	float sunAngle = max(0.0, cosSunUpAngle * 0.95 + 0.05);
	
	vec3 sunE = vec3(1.,0.899,0.828)*SunIntensity(cosSunUpAngle, sunIntensity, cutoffAngle, steepness);  // Get sun intensity based on how high in the sky it is
	
	vec3 totalRayleigh = totalRayleigh(primaryWavelengths, n, N, pn);

	vec3 rayleighAtX = totalRayleigh * rayleighCoefficient;

	vec3 mieAtX = totalMie(primaryWavelengths, K, turbidity, v) * mieCoefficient;

	float zenithAngle = max(0.0, cosUpViewAngle);

	float rayleighOpticalLength = rayleighZenithLength / zenithAngle;
	float mieOpticalLength = mieZenithLength / zenithAngle;
	
	float rayleighOpticalLengthSun = rayleighZenithLength / sunAngle;
	float mieOpticalLengthSun = mieZenithLength / sunAngle;
	
	vec3 Fex = exp(-(rayleighAtX * rayleighOpticalLength + mieAtX * mieOpticalLength));
	vec3 FexSun = exp(-(rayleighAtX * rayleighOpticalLengthSun + mieAtX * mieOpticalLengthSun));

	vec3 rayleighXtoEye = rayleighAtX * RayleighPhase(cosViewSunAngle)*exp(-(rayleighAtX * rayleighOpticalLengthSun*0.1));
	vec3 mieXtoEye = vec3(1.,0.899,0.828)*mieAtX *  hgPhase(cosViewSunAngle , mieDirectionalG)*exp(-(rayleighAtX * rayleighOpticalLengthSun + mieAtX * mieOpticalLengthSun));

	vec3 totalLightAtX = rayleighAtX + mieAtX;
	vec3 lightFromXtoEye = rayleighXtoEye + mieXtoEye;

	vec3 scattering = sunE * (lightFromXtoEye / totalLightAtX);
	float undergroundLighting = clamp((eyeBrightnessSmooth.y/255.-2/16.)*4.,0.0,1.0); //avoid light leaking udnerground
	vec3 sky = scattering *(1.0-Fex);
	//sky *= mix(vec3(1.0),pow(scattering * Fex,vec3(0.5)),clamp(pow(1.0-cosSunUpAngle,5.0),0.0,1.0));
	float SdotE = dot(sunVec,normalize(fragpos.xyz));
	float EdotU = clamp(1.0-dot(upVec,normalize(fragpos.xyz)),0.,1.25);
	vec3 rainSky = vec3(0.1,0.14,0.2)*sunlight*0.15*exp(SdotE*SdotE*SdotE*2. + EdotU*EdotU*EdotU) + vec3(0.1,0.12,0.15)*length(sunlight);
	return sky*vec3(1.2,1.3,1.5)*2.8*sunVisibility*(1.0-rainStrength)+rainSky*rainStrength/0.0075*0.5;
}

vec3 getAtmosphericScattering2(float dist,vec3 fragpos,vec3 color,float VL){
	float tr2 = clamp(abs(worldTime*1.-17975.0)-5275.,0.,200.)/200.;
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	float turbidity = 4.;
	float rayleighCoefficient = 2.0;

	// constants for mie scattering
	const float mieCoefficient = 0.024;
	const float mieDirectionalG = 0.76;
	const float v = 4.0;

	// Wavelength of the primary colors RGB in nanometers.
	const vec3 primaryWavelengths = vec3(680, 550, 450) * 1.0E-9;
	
	float n = 1.00029; // refractive index of air
	float N = 2.54743E25; // number of molecules per unit volume for air at 288.15K and 1013mb (sea level -45 celsius)
	float pn = 0.035;	// depolarization factor for standard air

	// optical length at zenith for molecules
	float rayleighZenithLength = 8.4E3 ;
	float mieZenithLength = 1.25E3;
	
	const vec3 K = vec3(0.686, 0.678, 0.666);

	float sunIntensity = 1000.0;

	// earth shadow hack
	float cutoffAngle = pi * 0.5128205128205128;
	float steepness = 1.5;

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	// Cos Angles
	float cosViewSunAngle = dot(normalize(fragpos.rgb), sunVec);
	float cosSunUpAngle = dot(sunVec, upVec) * 0.95 + 0.05; //Has a lower offset making it scatter when sun is below the horizon.
	float cosUpViewAngle = pow(abs(dot(upVec, normalize(fragpos.rgb))),1.6)*sign(dot(upVec, normalize(fragpos.rgb)));

	vec3 sunE = vec3(1.,0.899,0.828)*SunIntensity(cosSunUpAngle, sunIntensity, cutoffAngle, steepness);  // Get sun intensity based on how high in the sky it is
	
	vec3 totalRayleigh = totalRayleigh(primaryWavelengths, n, N, pn);

	vec3 rayleighAtX = totalRayleigh * rayleighCoefficient;

	vec3 mieAtX = totalMie(primaryWavelengths, K, turbidity, v) * mieCoefficient;

	float zenithAngle = max(0.0, cosUpViewAngle);

	float rayleighOpticalLength = rayleighZenithLength / zenithAngle;
	float mieOpticalLength = mieZenithLength / zenithAngle;

	vec3 wVec = normalize((gbufferModelViewInverse*vec4(normalize(fragpos),0.0)).xyz);
	
	
	vec3 Fex = exp(-(rayleighAtX  + mieAtX)*dist);
	vec3 Fexsun = vec3(exp(-(rayleighCoefficient * 0.00002853075 * rayleighOpticalLength + mieAtX * mieOpticalLength)));

	vec3 rayleighXtoEye = rayleighAtX * RayleighPhase(cosViewSunAngle);
	vec3 mieXtoEye = mieAtX *  hgPhase(cosViewSunAngle , mieDirectionalG);

	vec3 totalLightAtX = rayleighAtX + mieAtX;
	vec3 lightFromXtoEye = rayleighXtoEye*(0.5+VL*tr2*tr2) + mieXtoEye*VL*3.*scatSunlight*tr2*tr2;

	vec3 scattering = sunE * (lightFromXtoEye / totalLightAtX);

	vec3 sky = scattering * (1.0-Fex);
	float SdotE = dot(sunVec,normalize(fragpos.xyz));
	float EdotU = clamp(1.0-dot(upVec,normalize(fragpos.xyz)),0.,1.25);
	vec3 caveFog = (1.0-exp(-dist/512.))*vec3(0.001) * (1.0+VL*5.);
	float undergroundLighting = clamp((eyeBrightnessSmooth.y/255.-2/16.)*4.,0.0,1.0); //avoid light leaking udnerground
		vec3 rainSky =  vec3(0.1,0.14,0.2)*sunlight*0.01*exp(SdotE*SdotE*SdotE*4.)*(3.4+VL) + vec3(0.1,0.12,0.15)*length(sunlight)*(1.1+VL*0.33);
	return color * Fex * exp(-dist/22.*rainStrength*rainStrength*rainStrength) + mix(caveFog,sky*0.6*sunVisibility*(1.0-rainStrength)+rainSky*rainStrength*(1.0-exp(-dist/22.))*0.2,undergroundLighting);
}

vec4 smoothfilter(in sampler2D tex, in vec2 uv)
{
	const float textureResolution = 32.;
	uv = uv*textureResolution + 0.5;
	vec2 iuv = floor( uv );
	vec2 fuv = fract( uv );
	uv = iuv + (fuv*fuv)*(3.0-2.0*fuv); 
	uv = uv/textureResolution - 0.5/textureResolution;
	return texture2D( tex, uv);
}


float densityAtPos(in vec3 pos)
{

	pos /= 18.;
	pos.xz *= 0.5;


	vec3 p = floor(pos);
	vec3 f = fract(pos);
	
	f = (f*f) * (3.-2.*f);
	f=sqrt(f);
	vec2 uv =  p.xz + f.xz + p.y * 17.0;

	vec2 coord =  uv / 32.;
	vec2 coord2 =  uv / 32. + 17. / 32.;
	float xy1 = smoothfilter(noisetex, coord).x;
	float xy2 = smoothfilter(noisetex, coord2).x;
	return mix(xy1, xy2, f.y);
}



float cloud_height = 260.;
float maxHeight = 460.;
const int maxIT_clouds = 8; 
float center = cloud_height*0.5+maxHeight*0.5;
float difcenter = maxHeight-center;





float cloudVol(in vec3 pos){
	float mult = (pos.y-center)/difcenter;
	
	
	vec3 samplePos = pos*vec3(0.5,0.5,0.5)*0.35+frameTimeCounter*vec3(0.5,0.,0.5);
	float noise = 0.0;
	float tot = 0.0;
	for(int i=0 ; i < 4; i++){
		noise += densityAtPos(samplePos*exp(i*1.05)*0.6+frameTimeCounter*i*vec3(0.5,0.,0.5)*0.6)*exp(-i*0.8);
		tot += exp(-i*0.8);
	}

	
	//noise /= 1.0+1./2.+1/4.+1/8.+1/16.;
	
	float cloud = 1.0-pow(0.4,max(noise/tot-0.56-mult*mult*0.3+rainStrength*0.12,0.0)*2.2);
	
return cloud;
}

float cloudPlane(in vec3 pos){

	return cloudVol(pos)*40.;
}

float bayer2(vec2 a){
	a = floor(a);
    return fract(dot(a,vec2(0.5,a.y*0.75)));
}
#define bayer4(a)   (bayer2( .5*(a))*.25+bayer2(a))
#define bayer8(a)   (bayer4( .5*(a))*.25+bayer2(a))
#define bayer16(a)  (bayer8( .5*(a))*.25+bayer2(a))
#define bayer32(a)  (bayer16(.5*(a))*.25+bayer2(a))
#define bayer64(a)  (bayer32(.5*(a))*.25+bayer2(a))
#define bayer128(a) fract(bayer64(.5*(a))*.25+bayer2(a)+tempSample)

vec4 renderClouds(vec4 fragposition, vec3 color) {
	
		//bayer looks better on clouds than blue noise (probably better taa convergence)
		float dither = bayer128(gl_FragCoord.xy);
		
		
		
		//setup ray in projected shadow map space
		vec4 albedo = texture2D(gcolor,texcoord);
		bool land = !(dot(albedo.rgb,vec3(1.0))<0.00000000001 );

		float SdotU = dot(normalize(fragposition.xyz),sunVec);
		float z2 = length(fragposition);
		float z = -fragposition.z;
		
		
		//project pixel position into projected shadowmap space
		fragposition = gbufferModelViewInverse*fragposition;
		
		vec3 worldV = fragposition.xyz;
		
		fragposition = shadowModelView*fragposition;
		fragposition = shadowProjection*fragposition;
		
		//project view origin into projected shadowmap space
		vec4 start = (gbufferModelViewInverse*vec4(0.0,0.0,0.,1.));
		vec3 dV_view = worldV;

		
		vec3 progress_view = dV_view*dither+cameraPosition;
		
		float vL = 0.0;
		float total_extinction = 1.0;

	float mult = 500.0;
	float startY = 0.0;
	
	float distW = length(worldV);
	worldV = normalize(worldV)*(land? distW : 2200.) + cameraPosition; //makes max cloud distance not dependant of render distance
	dV_view = normalize(dV_view);
	
	//3 ray setup cases : below cloud plane, in cloud plane and above cloud plane
	if (cameraPosition.y <= cloud_height){
		startY = cloud_height;	
		float maxHeight2 = min(maxHeight,worldV.y);	//stop ray when intersecting before cloud plane end
		
		//setup ray to start at the start of the cloud plane and end at the end of the cloud plane
		dV_view *= -(maxHeight2-startY)/dV_view.y/maxIT_clouds;
		vec3 startOffset = dV_view*dither;

		progress_view = startOffset + cameraPosition + dV_view*(maxHeight2-cameraPosition.y)/(dV_view.y);
	
	
		mult = length(dV_view)/50.;
		if (worldV.y < cloud_height) return vec4(0.,0.,0.,1.);	//don't trace if no intersection is possible
	}
	
	if (cameraPosition.y > cloud_height && cameraPosition.y < maxHeight){
		if (dV_view.y <= 0.0) {
		startY = cameraPosition.y;			
		float maxHeight2 = max(cloud_height,worldV.y);	//stop ray when intersecting before cloud plane end
		
		//setup ray to start at eye position and end at the end of the cloud plane
		dV_view *= abs(maxHeight2-startY)/abs(dV_view.y)/maxIT_clouds;

		
		mult = length(dV_view)/50.;
		progress_view = dV_view*dither + cameraPosition + dV_view*maxIT_clouds;
		dV_view *= -1.0;
		}
		else
		if (dV_view.y > 0.0) {		
		startY = cameraPosition.y;			
		float maxHeight2 = min(maxHeight,worldV.y);	//stop ray when intersecting before cloud plane end
		
		//setup ray to start at eye position and end at the end of the cloud plane
		dV_view *= -abs(maxHeight2-startY)/abs(dV_view.y)/maxIT_clouds;

		mult = length(dV_view)/50.;
		progress_view = dV_view*dither + cameraPosition - dV_view*maxIT_clouds;

		}

		
	}
	
	if (cameraPosition.y >= maxHeight){
		startY = maxHeight;			
		float maxHeight2 = max(cloud_height,worldV.y);	//stop ray when intersecting before cloud plane end

		//setup ray to start at eye position and end at the end of the cloud plane
		dV_view *= -abs(maxHeight2-startY)/abs(dV_view.y)/maxIT_clouds;
		progress_view = dV_view*dither + cameraPosition + dV_view*(maxHeight2-cameraPosition.y)/dV_view.y;
		mult = length(dV_view)/50.;
		if (worldV.y > maxHeight) return vec4(0.,0.,0.,1.);	//don't trace if no intersection is possible
	}

	mult = length(dV_view)/256.;
	

	color = vec3(0.0);
	
	total_extinction = 1.0;
	float sunIntensity = exp(SdotU*SdotU*SdotU*2.)+0.7;
	float moonIntensity = exp(-SdotU*SdotU*SdotU*2.)+1.;

	vec3 sunContribution = sunlight*1.7*sunIntensity*(1.0-rainStrength*0.99);
	vec3 ambient = ambientUp*0.8;
	vec3 moonContribution = moonIntensity*moonlight*moonVisibility*0.75*(1.0-rainStrength*0.99);
	vec3 rainLight = sqrt(sunlight)*rainStrength*0.15 + moonlight*1.5;
	
	for (int i=0;i<maxIT_clouds;i++) {
		float cloud = cloudPlane(progress_view);
		float lightsourceVis = pow(clamp(progress_view.y-cloud_height,0.,200.)/200.,2.3);
		color = mix(color,sunContribution*lightsourceVis+ambient + lightsourceVis*moonContribution+lightsourceVis*rainLight,1.0-exp(-cloud*mult));
		total_extinction *= exp(-cloud*mult);
		progress_view += dV_view;
	}

	//color = vec3(mult,0.,0.)
	return vec4(color,total_extinction);

		
}

float manualShadowFilter(vec2 center,vec2 offset, bool translucent, float diffthresh, float comparedepth,float weight){
	vec2 pos = center+offset;
	const float invShadowRes = 1.0 /shadowMapResolution;
	
	const float threshMul = 4096.;
	
	float thresh = diffthresh * (1.0+length(offset)/invShadowRes);

	

	thresh = thresh;
	//use a quasi-step function for normal shadows and a smooth depth gradient for translucent objects
	const float constStep = pow(2,-25.);
	float minDiffthesh = thresh*float(translucent) + constStep;
	float diffthresh0 = thresh-thresh*float(translucent);
	vec4 sampleS = textureGather( shadow, pos, 0)+diffthresh0;
	
	//way faster than conditionnal assignment
	vec4 shadow4 = clamp(-(sampleS-comparedepth),0.,minDiffthesh);

	
	//filter (same result as shadow2D)
	vec2 filterWeight = fract(pos*shadowMapResolution - 0.5);
    float temp0 = mix( shadow4.x, shadow4.y, filterWeight.x );
    float temp1 = mix( shadow4.w, shadow4.z, filterWeight.x );
	

    return mix( temp1, temp0, filterWeight.y )/minDiffthesh;
	
	
	
}
float calcDistort(vec2 worlpos){
	
	vec2 pos = abs(worlpos * 1.165);

	float distb = pow(pow(pos.x, 12.) + pow(pos.y, 12.), 1.0 / 12.0);
	return 1.0/((1.0 - SHADOW_MAP_BIAS) + distb * SHADOW_MAP_BIAS);
}
#define diagonal3(m) vec3((m)[0].x, (m)[1].y, m[2].z)

#define  projMAD(m, v) (diagonal3(m) * (v) + (m)[3].xyz)
vec3 toClipSpace3(vec3 viewSpacePosition) {
    return projMAD(gbufferProjection, viewSpacePosition) / -viewSpacePosition.z * 0.5 + 0.5;
}
vec4 iProjDiag = vec4(gbufferProjectionInverse[0].x, gbufferProjectionInverse[1].y, gbufferProjectionInverse[2].zw);
vec3 toScreenSpace(vec3 p) {
        vec3 p3 = p * 2. - 1.;
        vec4 fragposition = iProjDiag * p3.xyzz + gbufferProjectionInverse[3];
        return fragposition.xyz / fragposition.w;
}

vec3 toShadowSpace(vec3 p3){
    p3 = mat3(gbufferModelViewInverse) * p3 + gbufferModelViewInverse[3].xyz;
    p3 = mat3(shadowModelView) * p3 + shadowModelView[3].xyz;
    p3 = diagonal3(shadowProjection) * p3 + shadowProjection[3].xyz;

    return p3;
}
float nrand( vec2 n )
{
	return fract(sin(dot(n.xy, vec2(12.9898, 78.233)))* 43758.5453);
}
float triangWhiteNoise( vec2 n )
{
	//uses white noise for color dithering : gives a somewhat more "filmic" look when noise is visible
	float t = fract( frameTimeCounter );
	float rnd = nrand( n + 0.07*t );

    float center = rnd*2.0-1.0;
    rnd = center*inversesqrt(abs(center));
    rnd = max(-1.0,rnd); 
    return rnd-sign(center);
}
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
void main() {
gl_FragData[2] = texture2D(gaux4,texcoord);
#ifdef UNDERWATERFIX
float mulfov = 1.0;
if (isEyeInWater>0.1){
float fov = atan(1./gbufferProjection[1][1]);
float fovUnderWater = fov*0.85;
mulfov = gbufferProjection[1][1]*tan(fovUnderWater); 
}
#endif
#ifndef UNDERWATERFIX
const float mulfov = 1.0;
#endif

vec3 occlusion = vec3(0.);


float Depth = texture2D(depthtex2, texcoord).z;
vec4 albedo = texture2D(gcolor,texcoord);
bool land = !(dot(albedo.rgb,vec3(1.0))<0.00000000001 || (Depth > comp));
bool translucent = albedo.b > 0.69 && albedo.b < 0.71;
bool emissive = albedo.b > 0.59 && albedo.b < 0.61;
vec3 color = vec3(albedo.rg,0.0);



	vec2 offset = tempOffset;



	vec2 jitter = offset/vec2(viewWidth,viewHeight);

vec4 fragpos = gbufferProjectionInverse * (vec4(texcoord-jitter,Depth,1.0) * 2.0 - 1.0);
fragpos /= fragpos.w;
fragpos.xy *= mulfov;


vec3 normalT = decode(texture2D(gdepth,texcoord).xy);

float pw = 1.0/ viewWidth;
float ph = 1.0/ viewHeight;
float lDepth = ld(Depth);

const float minStep = -0.000001;
float invFar = 1.0/far;
vec4 blur = vec4(texture2D(composite,texcoord).xy,1.,1.0);
vec4 blur1 = vec4(texture2D(composite,texcoord + vec2(-0.5*pw,1.5*ph)).xyz,1.0);
vec4 blur2 = vec4(texture2D(composite,texcoord + vec2(1.5*pw,0.5*ph)).xyz,1.0);
vec4 blur3 = vec4(texture2D(composite,texcoord + vec2(0.5*pw,-1.5*ph)).xyz,1.0);
vec4 blur4 = vec4(texture2D(composite,texcoord + vec2(-1.5*pw,-0.5*ph)).xyz,1.0);

//bilateral blur 17 samples w/ bilinear filtering, rejected 4 by 4 
//x:ssao y:VL zw:total samples
vec4 depth1 = ld4(textureGather(depthtex2,texcoord + vec2(-0.5*pw,1.5*ph),0));
blur = blur + step(dot(abs(depth1-lDepth),vec4(far)),vec4(0.5,10.,0.5,10.))*vec4(blur1.x,blur1.y,1.,1.);

vec4 depth2 = ld4(textureGather(depthtex2,texcoord + vec2(1.5*pw,0.5*ph),0));
blur = blur + step(dot(abs(depth2-lDepth),vec4(far)),vec4(0.5,10.,0.5,10.))*vec4(blur2.x,blur2.y,1.,1.);


vec4 depth3 = ld4(textureGather(depthtex2,texcoord + vec2(0.5*pw,-1.5*ph),0));
blur = blur + step(dot(abs(depth3-lDepth),vec4(far)),vec4(0.5,10.,0.5,10.))*vec4(blur3.x,blur3.y,1.,1.);

vec4 depth4 = ld4(textureGather(depthtex2,texcoord + vec2(-1.5*pw,-0.5*ph),0));
blur = blur + step(dot(abs(depth4-lDepth),vec4(far)),vec4(0.5,10.,0.5,10.))*vec4(blur4.x,blur4.y,1.,1.);


blur.xy /= blur.zw;


if (land && dot(albedo.rgb,vec3(1.0))>0.00000000001){
vec2 a0 = texture2D(gcolor,texcoord + vec2(1.0/viewWidth,0.0)).rg;
vec2 a1 = texture2D(gcolor,texcoord - vec2(1.0/viewWidth,0.0)).rg;
vec2 a2 = texture2D(gcolor,texcoord + vec2(0.0,1.0/viewHeight)).rg;
vec2 a3 = texture2D(gcolor,texcoord - vec2(0.0,1.0/viewHeight)).rg;
vec4 lumas = vec4(a0.x,a1.x,a2.x,a3.x);
vec4 chromas = vec4(a0.y,a1.y,a2.y,a3.y);

const vec4 THRESH = vec4(30./255.);

vec4 w = 1.0-step(THRESH, abs(lumas - color.x));
float W = dot(w,vec4(1.0));

w.x = (W==0.0)? 1.0:w.x;  W = (W==0.0)? 1.0:W;

float chroma = dot(w,chromas)/W;



bool pattern = (mod(gl_FragCoord.x,2.0)==mod(gl_FragCoord.y,2.0));
color.b= chroma;
color.rgb = (pattern)?color.rbg:color.rgb;
color.rgb = YCoCg2RGB(color.rgb);

color = pow(max(color,0.0),vec3(2.2))*ALBEDO_MULTIPLIER*0.9;



vec3 normal = texture2DLod(gnormal,texcoord,0).xyz;

	bool iswater = normal.z < 0.2499 && dot(normal,normal) > 0.0;
	bool isice = normal.z > 0.2499 && normal.z < 0.4999 && dot(normal,normal) > 0.0;

//occlusion.rgb = occlusion.rgb*2.0-1.0;
//color += colorBleed;

//color *= 10*dot(cp,vec4(1.0));

float avgocc = blur.x;

//avgocc =  celshade(texcoord);
//avgocc = 1.0;


float NdotL = dot(normalT,sunVec);
float NdotU = dot(normalT,upVec);

	float skyL = max(texture2D(gdepth,texcoord).w-2./16.0,0.0)*1.14285714286;
	float torch_lightmap = 16.0-min(15.,(texture2D(gdepth,texcoord).z-0.5/16.)*16.*16./15);


	float fallof1 = clamp(1.0 - pow(torch_lightmap/16.0,4.0),0.0,1.0);
	torch_lightmap = fallof1*fallof1/(torch_lightmap*torch_lightmap+1.0);

/*
	torch_lightmap 		= 6.4 - min(torch_lightmap * 6.16,5.6);
	torch_lightmap 		= 0.1 / torch_lightmap / torch_lightmap - 0.002595;*/
	float c_emitted = dot((color.rgb),vec3(1.0,0.6,0.4))/2.0;
	float emitted 		= emissive? clamp(c_emitted*c_emitted,0.0,1.0)*torch_lightmap : 0.0;




	vec2 visibility = vec2(sunVisibility,moonVisibility);



	float SkyL2 = skyL*skyL;
	float skyc2 = mix(1.0,SkyL2,skyL);

	float tr2 = clamp(abs(worldTime*1.-17975.0)-5275.,0.,200.)/200.;
	vec4 bounced = vec4(NdotL,NdotL,NdotL,NdotU) * vec4(-0.08*skyL*skyL,0.33,0.7,0.1) + vec4(0.75,0.66,0.7,0.25);

	bounced *= vec4(skyc2,skyc2,visibility.x-tr*visibility.x,0.8);


	vec3 LightC = mix(moonlight*0.85,sunlight,tr2*tr2)*tr*(1.0-rainStrength*0.998);

	
	vec3 wNormal = (gbufferModelViewInverse*vec4(normalT,0.0)).rgb;
	vec3 ambientCol = ambientUp*max(wNormal.y,0.) + ambientDown*max(-wNormal.y,0.) + ambientLeft*max(-wNormal.x,0.)+ ambientRight*max(wNormal.x,0.)+ ambientB*max(wNormal.z,0.)+ ambientF*max(-wNormal.z,0.);
	ambientCol += 0.25*sunlight*(bounced.x + bounced.z)*(0.03+tr*0.17)/0.4*(1.0-rainStrength*0.98)  + length(sunlight)*0.2*(1.0-rainStrength*0.9);
	ambientCol += sunlight*(NdotL*0.5+0.45)*sunVisibility*(1.0-tr)*(1.0-tr)*4.*(1.0-rainStrength*0.98);
	vec3 ambientC =  avgocc*(translucent? 1.1 : 1.0 )*ambientCol*SkyL2*0.3 + vec3(1.1,0.42,0.045)*(emitted*15.*color + torch_lightmap*avgocc)*0.2 + 0.00008*avgocc;





	NdotL = clamp((worldTime > 12700 && worldTime < 23250)? -NdotL : NdotL,0.0,1.);
	float diffuse = pow(NdotL,0.9)*0.9; //modified diffuse sahding



	diffuse = translucent? abs(dot(sunVec,upVec))*0.2+NdotL*0.2+0.6 : diffuse;
	
	float blockerCount = 0.0;
	vec3 worldposition = mat3(gbufferModelViewInverse) * fragpos.xyz + gbufferModelViewInverse[3].xyz;
	if (diffuse > 0.001){
    worldposition = mat3(shadowModelView) * worldposition + shadowModelView[3].xyz;
    worldposition = diagonal3(shadowProjection) * worldposition + shadowProjection[3].xyz;
	


	float distortFactor = calcDistort(worldposition.xy);


	vec2 pos = abs(worldposition.xy) * 1.165;

	float distb = pow(pow(pos.x, 12.) + pow(pos.y, 12.), 1.0 / 12.0);
	vec2 wpos = pos;
	distortFactor = 1.0/((1.0 - SHADOW_MAP_BIAS) + distb * SHADOW_MAP_BIAS);
	worldposition.xy *= distortFactor/0.97;

	float dist = min(abs(wpos.y-wpos.x),abs(1.0-wpos.y-wpos.x));
	float diffmul = clamp(dist/distortFactor,0.016,0.02)-0.016;
	float diffmul2 = 1.0-clamp(distortFactor-2.4,0.,0.1)/0.1;
	diffmul = mix(3.,1.,min(diffmul2+diffmul/0.004,1.));


	if (max(abs(worldposition.x),abs(worldposition.y)) < 0.99) {
		float noise = BlueNoise();
		float diffthresh = translucent? 0.0002+0.0002*abs(SdotU) : diffmul*0.025/distortFactor/distortFactor*(0.008*tan(acos(NdotL)) + 0.025);

				worldposition = worldposition * vec3(0.5f,0.5,0.5/2.5) + vec3(0.5,0.5,0.5);
				float comparedepth = worldposition.z;
				

				noise = noise*2.0*3.14159265359;
				//float noise = interleaved_gradientNoise(gl_FragCoord.xy-0.5)*3.14159265359*2.0;

			mat2 noiseM = mat2( cos( noise ), -sin( noise ),
                           sin( noise ), cos( noise )
                            );
							
				float shading = 0.0;
				float avgdepth = .0;
					vec2 scales = vec2(0.0,60.);
					const float mult = 12.;


					float avgBlockerDepth = 0.0;

					float rdMul = distortFactor*(1.0*0.2/shadowMapResolution+mult*0.2/shadowMapResolution);
					float diffthreshM = diffthresh*mult*0.3/diffmul*distortFactor;
											for(int i = 0; i < 9; i++){		
												vec2 offsetS = tapLocation(i,noise,9,2.);
												vec4 d4 = textureGather( shadow, worldposition.xy+offsetS*rdMul, 0);
												vec4 b4  = step(d4,vec4(comparedepth-length(offsetS)*diffthreshM-diffthreshM)); 
											
												blockerCount += dot(b4, vec4(1.0));
												avgBlockerDepth += dot( d4, b4 );
											}
										if (blockerCount >= 0.9)
											avgBlockerDepth /= blockerCount;
										else {
											avgBlockerDepth = comparedepth;
										}
					float ssample = max(comparedepth - avgBlockerDepth,0.0)*1000.*2.5/2;
					avgdepth = clamp(ssample, scales.x, scales.y)/(scales.y);

					avgdepth = avgdepth*mult;

					avgdepth = mix(avgdepth,mult,rainStrength);
					float stepSize = (1.)/shadowMapResolution*distortFactor*0.2+avgdepth/shadowMapResolution*distortFactor*0.2;
					float weight;
					
	
				float wMul = avgdepth*distortFactor*0.2;
				
				//don't do fast sampling if neighboorhood has high quality sampling 
				float blockerCountMax = blockerCount + abs(dFdx(blockerCount)) + abs(dFdy(blockerCount));
				float blockerCountMin = blockerCount - abs(dFdx(blockerCount)) - abs(dFdy(blockerCount));
				
				if (blockerCountMax > 1 && blockerCountMin < 35 && stepSize > 3./shadowMapResolution){	
					
						shading = 0.;
					for(int i = 0; i < 30; i++){
						vec2 offsetS = tapLocation(i,noise,30,2.);
					
								float weight = 1.0+length(offsetS)*wMul;
								shading += manualShadowFilter(worldposition.xy,offsetS*stepSize, translucent, diffthresh, comparedepth,weight)/30.;
						}
						//shading = 600.;
					

				}
				//fast sampling if fully shadowed or no shadows
				else {
					shading = 0.;
					for(int i = 0; i < 9; i++){
						vec2 offsetS = tapLocation(i,noise,9,2.);
					
								float weight = 1.0+length(offsetS)*wMul;
								shading += manualShadowFilter(worldposition.xy,offsetS*stepSize, translucent, diffthresh, comparedepth,weight)/9.;
						}

					//shading = 90;

				}
				float lightDir = (worldTime > 12700 && worldTime < 23250)? -0.5 : 1.0;
				diffuse += translucent? pow(clamp(dot(normalize(fragpos.xyz),sunVec*lightDir),0.,1.),60.)*20 : 0.;
				diffuse *= 1.0 - shading;	


	}

	
	}
	
diffuse *= mix(skyL,1.,clamp((eyeBrightnessSmooth.y/255.-2/16.)*4.,0.0,1.0)); //avoid light leaking udnerground
bool isnsun = (iswater||isice) || ((!iswater||!isice) && isEyeInWater == 1);
color = color*(diffuse*LightC*(isnsun?SkyL2*skyL:1.0)*1.45+ambientC*(isnsun?1.0/(SkyL2*skyL*0.5+0.5):1.0)*1.3)*1.0;
//color = vec3(blur.yyy);
vec4 fragpos2 = gbufferProjectionInverse * (vec4(texcoord-jitter,texture2D(depthtex0,texcoord).x,1.0) * 2.0 - 1.0);
fragpos2 /= fragpos2.w;
fragpos2.xy *= mulfov;
float lengthDiff = length(fragpos.xyz-fragpos2.xyz);
if (isEyeInWater == 0 || lengthDiff > 0.0000001){
lengthDiff = lengthDiff < 0.0000001? length(fragpos.xyz) : lengthDiff;

	
color = getAtmosphericScattering2(lengthDiff*0.5,fragpos.xyz,color,blur.y);
color += moonlight*(0.1+blur.y*4.)*(lengthDiff/2048.)*(exp(dot(moonVec,normalize(fragpos2.xyz))*1.))*moonVisibility*(1.0-rainStrength*0.5);
}


}
else {


	vec4 worldp = gbufferModelViewInverse*fragpos;
	worldp.xyz = normalize(worldp.xyz)*1256;
	worldp = gbufferModelView*worldp;
	


	
	vec3 res = getAtmosphericScattering(vec3(0.),normalize(fragpos.xyz));
	color.rgb = max(res*0.0075,0.);

}




/* DRAWBUFFERS:317 */
	gl_FragData[0] = clamp(vec4(fpDither(color*10.,triangWhiteNoise(texcoord)),1.0),0.,65000.);
	gl_FragData[1] = vec4(0.,0.,0.,1.);
	if (dot(fragpos.xyz,upVec) > 0. || cameraPosition.y > 220) gl_FragData[1] = renderClouds(fragpos,vec3(0.));
	
	gl_FragData[2].b = blur.y;
}
