#version 400 compatibility
/*
!! DO NOT REMOVE !!
This code is from Chocapic13' shaders
Read the terms of modification and sharing before changing something below please !
!! DO NOT REMOVE !!
*/

	const float shadowMapResolution = 4096;		//shadowmap resolution
	

#define UNDERWATERFIX //fixes shadows and other stuff underwater
#define SHADOW_MAP_BIAS 0.80
in vec4 color;
in vec2 texcoord;
in vec2 lmcoord;
in vec4 ambientNdotL;
in vec4 sunlightMat;
in float dist;
in vec2 temporalOffsets;

in vec3 binormal;
in vec3 normal;
in vec3 tangent;
in vec3 viewVector;

uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;
uniform mat4 shadowProjection;
uniform mat4 shadowModelView;

uniform sampler2D noisetex;
uniform sampler2D texture;
uniform sampler2D shadow;
uniform sampler2D gaux4;

uniform int frameCounter;
uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform vec3 cameraPosition;
uniform vec3 upPosition;
uniform int fogMode;
uniform int worldTime;
uniform float wetness;
uniform float rainStrength;
uniform float frameTimeCounter;
uniform float viewWidth;
uniform float viewHeight;
uniform int heldBlockLightValue;
uniform int isEyeInWater;

#include "lib/waterBump.glsl"
	
vec3 sunlight = sunlightMat.rgb;
float mat = sunlightMat.a;



vec4 encode (vec3 n,float dif)
{
    float p = sqrt(n.z*8+8);
	
	float vis = lmcoord.t;
	if (ambientNdotL.a > 0.9) vis = vis / 4.0;
	if (ambientNdotL.a > 0.4 && ambientNdotL.a < 0.6) vis = vis/4.0+0.25;
	if (ambientNdotL.a < 0.1) vis = vis/4.0+0.5;
		
	
    return vec4(n.xy/p + 0.5,vis,1.0);
}
float HaltonSeq(int prime, int index)
    {
        float r = 0.;
        float f = 1.;
        int i = index;
        while (i > 0)
        {
            f /= prime;
            r += f * (i % prime);
            i = int(i / float(prime));
        }
        return r;
    }
float interleaved_gradientNoise(){
	int frame = int(mod(frameCounter*1.0,16.));
	float tempSample = HaltonSeq(3,frame+1);
	vec2 coord = gl_FragCoord.xy;
	float noise = fract(52.9829189*fract(0.06711056*coord.x + 0.00583715*coord.y)+tempSample);
	return noise;
}

vec2 tapLocation(int sampleNumber, float spinAngle,int nb, float nbRot)
{
	
	float startJitter = (spinAngle/6.28);
    float alpha = sqrt(float(sampleNumber*1.0f + startJitter) * (1.0 / (nb+ startJitter)));
    float angle = alpha * (nbRot * 6.28) + spinAngle;

    float ssR = alpha;
    float sin_v, cos_v;

	sin_v = sin(angle);
	cos_v = cos(angle);
	
    return vec2(cos_v, sin_v)*ssR;
}
	#define PW_DEPTH 0.75 //[0.5 1.0 1.5 2.0 2.5 3.0]
	#define PW_POINTS 2 //[2 4 6 8 16 32]
vec3 getParallaxDisplacement(vec3 posxz, float iswater) {

	float waveZ = mix(2.0,0.25,iswater);
	float waveM = mix(0.0,2.0,iswater);

	vec3 parallaxPos = posxz;
	vec2 vec = viewVector.xy / dist * (1.0 / float(PW_POINTS)) * 22.0 * PW_DEPTH * (1.0-rainStrength*PW_DEPTH);
	float waterHeight = getWaterBump(posxz.xz - posxz.y, waveM, waveZ, iswater) * 0.5;
	
	for(int i = 0; i < PW_POINTS; i++){
		parallaxPos.xz += waterHeight * vec;
		waterHeight = getWaterBump(parallaxPos.xz - parallaxPos.y, waveM, waveZ, iswater) * 0.5;
	}
	return parallaxPos;
}
float manualShadowFilter(vec2 center,vec2 offset, bool translucent, float diffthresh, float comparedepth,float weight){
	vec2 pos = center+offset;
	const float invShadowRes = 1.0 /shadowMapResolution;
	
	const float threshMul = 4096.;
	
	float thresh = diffthresh * (1.0+length(offset)/invShadowRes);

	

	thresh = thresh;
	//use a quasi-step function for normal shadows and a smooth depth gradient for translucent objects
	const float constStep = pow(2,-25.);
	float minDiffthesh = thresh*float(translucent) + constStep;
	float diffthresh0 = thresh-thresh*float(translucent);
	vec4 sampleS = textureGather( shadow, pos, 0)+diffthresh0;
	
	//way faster than conditionnal assignment
	vec4 shadow4 = clamp(-(sampleS-comparedepth),0.,minDiffthesh);

	
	//filter (same result as shadow2D)
	vec2 filterWeight = fract(pos*shadowMapResolution - 0.5);
    float temp0 = mix( shadow4.x, shadow4.y, filterWeight.x );
    float temp1 = mix( shadow4.w, shadow4.z, filterWeight.x );
	

    return mix( temp1, temp0, filterWeight.y )/minDiffthesh;
	
	
	
}
float calcDistort(vec2 worlpos){
	
	vec2 pos = abs(worlpos * 1.165);

	float distb = pow(pow(pos.x, 12.) + pow(pos.y, 12.), 1.0 / 12.0);
	return 1.0/((1.0 - SHADOW_MAP_BIAS) + distb * SHADOW_MAP_BIAS);
}
#define diagonal3(m) vec3((m)[0].x, (m)[1].y, m[2].z)

#define  projMAD(m, v) (diagonal3(m) * (v) + (m)[3].xyz)
vec3 toClipSpace3(vec3 viewSpacePosition) {
    return projMAD(gbufferProjection, viewSpacePosition) / -viewSpacePosition.z * 0.5 + 0.5;
}
vec4 iProjDiag = vec4(gbufferProjectionInverse[0].x, gbufferProjectionInverse[1].y, gbufferProjectionInverse[2].zw);
vec3 toScreenSpace(vec3 p) {
        vec3 p3 = p * 2. - 1.;
        vec4 fragposition = iProjDiag * p3.xyzz + gbufferProjectionInverse[3];
        return fragposition.xyz / fragposition.w;
}

vec3 toShadowSpace(vec3 p3){
    p3 = mat3(gbufferModelViewInverse) * p3 + gbufferModelViewInverse[3].xyz;
    p3 = mat3(shadowModelView) * p3 + shadowModelView[3].xyz;
    p3 = diagonal3(shadowProjection) * p3 + shadowProjection[3].xyz;

    return p3;
}
float BlueNoise(){
	vec2 nTC = mod(gl_FragCoord.xy,32.);
	 return fract(texelFetch(noisetex,ivec2(nTC),0).x+temporalOffsets.y*viewHeight);
	
}
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////

void main() {

	#ifdef UNDERWATERFIX
float mulfov = 1.0;
if (isEyeInWater>0.1){
float fov = atan(1./gbufferProjection[1][1]);
float fovUnderWater = fov*0.85;
mulfov = gbufferProjection[1][1]*tan(fovUnderWater); 
}
#endif
#ifndef UNDERWATERFIX
const float mulfov = 1.0;
#endif
	float mat = ambientNdotL.a;
	float iswater = clamp(mat*2.0-1.,0.,1.);
	float isice = float(mat > 0.4 && mat < 0.6);

		



	

	

	vec4 fragposition = gbufferProjectionInverse*(vec4(gl_FragCoord.xy/vec2(viewWidth,viewHeight)-temporalOffsets*0.5,gl_FragCoord.z,1.0)*2.0-1.0);
	fragposition /= fragposition.w;
	fragposition.xy*= mulfov;

	
	vec3 worldposition = mat3(gbufferModelViewInverse) * fragposition.xyz + gbufferModelViewInverse[3].xyz;
	vec3 wpos = worldposition.xyz;


			vec3 posxz = wpos+cameraPosition;
	mat3 tbnMatrix = mat3(tangent.x, binormal.x, normal.x,
	  tangent.y, binormal.y, normal.y,
	  tangent.z, binormal.z, normal.z);

	
		posxz = getParallaxDisplacement(posxz, iswater);
		
	vec4 albedo = texture2D(texture, texcoord.xy)*color;
	albedo.rgb = pow(albedo.rgb,vec3(2.2));
	if (iswater > 0.9) albedo.rgb = vec3(0.35,0.67,0.72);
	if (isice > 0.9 ) albedo = vec4(vec3(0.45,0.67,0.9)*0.63,0.3);
	vec3 colorrgb = albedo.rgb;
	
	
	vec3 bump;
	bump = getWaveHeight(posxz.xz - posxz.y,iswater);
	
	//const float bumpmult = 0.13457;
	float bumpmult = 0.25*(isice*0.8+iswater);
	
	bump = bump * vec3(bumpmult, bumpmult, bumpmult) + vec3(0.0f, 0.0f, 1.0f - bumpmult);
						  
	vec4 frag2 = vec4(normalize(bump * tbnMatrix), 1.0);

	float shading = 1.0;
	
	float diffuse = dot(normalize(sunPosition),frag2.rgb);
	diffuse = (worldTime > 12700 && worldTime < 23250)? -diffuse : diffuse;
	
	
	if (diffuse > 0. && iswater < 0.9){
    worldposition = mat3(shadowModelView) * worldposition + shadowModelView[3].xyz;
    worldposition = diagonal3(shadowProjection) * worldposition + shadowProjection[3].xyz;
	


	float distortFactor = calcDistort(worldposition.xy);


	vec2 pos = abs(worldposition.xy) * 1.165;

	float distb = pow(pow(pos.x, 12.) + pow(pos.y, 12.), 1.0 / 12.0);
	vec2 wpos = pos;
	distortFactor = 1.0/((1.0 - SHADOW_MAP_BIAS) + distb * SHADOW_MAP_BIAS);
	worldposition.xy *= distortFactor/0.97;

	float dist = min(abs(wpos.y-wpos.x),abs(1.0-wpos.y-wpos.x));
	float diffmul = clamp(dist/distortFactor,0.016,0.02)-0.016;
	float diffmul2 = 1.0-clamp(distortFactor-2.4,0.,0.1)/0.1;
	diffmul = mix(3.,1.,min(diffmul2+diffmul/0.004,1.));
	


		float blockerCount = 0.0;
	
	if (max(abs(worldposition.x),abs(worldposition.y)) < 0.99) {
		float noise = BlueNoise();
		float diffthresh =  diffmul*0.025/distortFactor/distortFactor*(0.008*tan(acos(diffuse)) + 0.025);

				worldposition = worldposition * vec3(0.5f,0.5,0.5/2.5) + vec3(0.5,0.5,0.5);
				float comparedepth = worldposition.z;
				

				noise = noise*2.0*3.14159265359;
				//float noise = interleaved_gradientNoise(gl_FragCoord.xy-0.5)*3.14159265359*2.0;

			mat2 noiseM = mat2( cos( noise ), -sin( noise ),
                           sin( noise ), cos( noise )
                            );
							
			
				float avgdepth = .0;
					vec2 scales = vec2(0.0,60.);
					const float mult = 12.;


					float avgBlockerDepth = 0.0;

					float rdMul = distortFactor*(1.0*0.2/shadowMapResolution+mult*0.2/shadowMapResolution);
					float diffthreshM = diffthresh*mult*0.3/diffmul*distortFactor;
											for(int i = 0; i < 9; i++){		
												vec2 offsetS = tapLocation(i,noise,9,2.);
												vec4 d4 = textureGather( shadow, worldposition.xy+offsetS*rdMul, 0);
												vec4 b4  = step(d4,vec4(comparedepth-length(offsetS)*diffthreshM-diffthreshM)); 
											
												blockerCount += dot(b4, vec4(1.0));
												avgBlockerDepth += dot( d4, b4 );
											}
										if (blockerCount >= 0.9)
											avgBlockerDepth /= blockerCount;
										else {
											avgBlockerDepth = comparedepth;
										}
					float ssample = max(comparedepth - avgBlockerDepth,0.0)*1000.*2.5/2;
					avgdepth = clamp(ssample, scales.x, scales.y)/(scales.y);

					avgdepth = avgdepth*mult;

					avgdepth = mix(avgdepth,mult,rainStrength);
					float stepSize = (1.)/shadowMapResolution*distortFactor*0.2+avgdepth/shadowMapResolution*distortFactor*0.2;
					float weight;
					
	
				float wMul = avgdepth*distortFactor*0.2;
				
				//don't do fast sampling if neighboorhood has high quality sampling 
				float blockerCountMax = blockerCount + abs(dFdx(blockerCount)) + abs(dFdy(blockerCount));
				float blockerCountMin = blockerCount - abs(dFdx(blockerCount)) - abs(dFdy(blockerCount));
				
				if (blockerCountMax > 1 && blockerCountMin < 35 && stepSize > 3./shadowMapResolution){	
					
						shading = 0.;
					for(int i = 0; i < 30; i++){
						vec2 offsetS = tapLocation(i,noise,30,2.);
					
								float weight = 1.0+length(offsetS)*wMul;
								shading += manualShadowFilter(worldposition.xy,offsetS*stepSize, false, diffthresh, comparedepth,weight)/30.;
						}
						//shading = 600.;
					

				}
				//fast sampling if fully shadowed or no shadows
				else {
					shading = 0.;
					for(int i = 0; i < 9; i++){
						vec2 offsetS = tapLocation(i,noise,9,2.);
					
								float weight = 1.0+length(offsetS)*wMul;
								shading += manualShadowFilter(worldposition.xy,offsetS*stepSize, false, diffthresh, comparedepth,weight)/9.;
						}

					//shading = 90;

				}


					
	}
	
	}

	vec3 sunlight = (1.0-shading)*sunlight*clamp(diffuse,0.,1.)*(1.0-rainStrength*0.99)*0.85;
	






	vec3 fColor = colorrgb*(sunlight*1.45+ambientNdotL.rgb*1.3);

	//fColor = texAniso(gaux4,posxz.xz/100.,vec2(1/2048.),normal.xyz,fragposition.xyz).xyz*0.1;
	//fColor = vec3(abs(dFdx(posxz.xy).xyy)*10.);
	float alpha = mix(albedo.a,0.11,iswater);
//alpha = 1.0;
/* DRAWBUFFERS:526 */
	gl_FragData[0] = vec4(fColor,alpha);
	gl_FragData[1] = encode(frag2.rgb,diffuse);
	gl_FragData[2] = vec4(normalize(albedo.rgb+0.00001),alpha);
}